/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.GetterOrSetter;
import org.appwork.utils.DebugMode;

public class Setter
implements GetterOrSetter {
    public final String key;
    public final Method method;
    public final Type type;
    public final List<String> alternativeKeys;
    public final Field field;
    public final ClassCache cc;
    private static final List<String> NULL_LIST = Collections.unmodifiableList(new ArrayList());

    public Field getField() {
        return this.field;
    }

    public List<String> getAlternativeKeys() {
        return this.alternativeKeys;
    }

    public Setter(ClassCache cc, String name, Method m) {
        this(cc, name, null, m, null);
    }

    public Setter(ClassCache cc, String name, List<String> alternativeKeys, Method m, Field field) {
        this.cc = cc;
        this.key = name;
        this.field = field;
        this.method = m;
        m.setAccessible(true);
        this.alternativeKeys = alternativeKeys == null ? NULL_LIST : Collections.unmodifiableList(alternativeKeys);
        this.type = m.getGenericParameterTypes()[0];
    }

    public String toString() {
        return this.method.toString();
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public Type getType() {
        return this.type;
    }

    public void setValue(Object inst, Object parameter) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.type instanceof Class && ((Class)this.type).isEnum() && parameter != null && !((Class)this.type).isAssignableFrom(parameter.getClass())) {
            parameter = Enum.valueOf((Class)this.type, parameter + "");
            DebugMode.logInIDEOnly(new Exception("This should not happen! This is job of the mapper"));
        }
        this.method.invoke(inst, parameter);
    }
}

