/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.sunwrapper.sun.swing;

import java.awt.Component;
import java.awt.FontMetrics;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.appwork.utils.ReflectionUtils;

public class SwingUtilities2Wrapper {
    private static Method clipStringIfNecessaryMethod = null;
    private static boolean preferNativeClipStringMethod = true;
    private static Method stringWithMethod;
    private static boolean preferNativeStringWidthMethod;
    private static Method skipClickCountMethodMethod;
    private static boolean preferNativeSkipClickCountMethod;
    private static final StringBuilder SKIP_CLICK_COUNT;

    private static String internalClipStringIfNecessary(JComponent component, FontMetrics fontMetrics, String str, int availableWidth) {
        if (str == null || str.length() == 0 || str.trim().length() == 0) {
            return str;
        }
        if (availableWidth == 0) {
            return "";
        }
        boolean normalized = false;
        char[] charArray = str.toCharArray();
        int length = charArray.length;
        while (length > 0) {
            int stringWidth = fontMetrics.charsWidth(charArray, 0, length);
            if (stringWidth > availableWidth) {
                if (!normalized) {
                    normalized = true;
                    float percent = 100.0f / (float)availableWidth * (float)stringWidth;
                    length = Math.min(length, (int)((float)length / percent * 100.0f) + 5);
                    continue;
                }
                --length;
                continue;
            }
            if (length == charArray.length) {
                return str;
            }
            return new String(charArray, 0, length);
        }
        return "";
    }

    private static Method findStringWidthMethod(JComponent component, FontMetrics fontMetrics, String str) {
        Object[] params = new Object[]{component, fontMetrics, str};
        try {
            return ReflectionUtils.findMatchingMethod("sun.swing.SwingUtilities2", "stringWidth", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return ReflectionUtils.findMatchingMethod("javax.swing.plaf.basic.BasicGraphicsUtils", "getStringWidth", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static Method findClipStringMethod(JComponent component, FontMetrics fontMetrics, String str, int availableWidth) {
        Object[] params = new Object[]{component, fontMetrics, str, availableWidth};
        try {
            return ReflectionUtils.findMatchingMethod("sun.swing.SwingUtilities2", "clipStringIfNecessary", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return ReflectionUtils.findMatchingMethod("javax.swing.plaf.basic.BasicGraphicsUtils", "getClippedString", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static String clipStringIfNecessary(JComponent component, FontMetrics fontMetrics, String str, int availableWidth) {
        try {
            if (fontMetrics == null) {
                throw new IllegalArgumentException("Fontmetrics may not be null");
            }
            Method method = clipStringIfNecessaryMethod;
            if (method == null && preferNativeClipStringMethod) {
                clipStringIfNecessaryMethod = method = SwingUtilities2Wrapper.findClipStringMethod(component, fontMetrics, str, availableWidth);
            }
            if (method != null) {
                String ret = (String)method.invoke(null, component, fontMetrics, str, availableWidth);
                while (ret.length() > 0 && ret.endsWith(".") && SwingUtilities2Wrapper.stringWidth(component, fontMetrics, ret) > availableWidth) {
                    ret = ret.substring(0, ret.length() - 1);
                }
                return ret;
            }
            preferNativeClipStringMethod = false;
            return SwingUtilities2Wrapper.internalClipStringIfNecessary(component, fontMetrics, str, availableWidth);
        }
        catch (NoClassDefFoundError e) {
            preferNativeClipStringMethod = false;
        }
        catch (IllegalAccessError e) {
            preferNativeClipStringMethod = false;
        }
        catch (Exception ignore) {
            preferNativeClipStringMethod = false;
        }
        return str;
    }

    public static int stringWidth(JComponent component, FontMetrics fontMetrics, String str) {
        try {
            Method method = stringWithMethod;
            if (method == null && preferNativeStringWidthMethod) {
                stringWithMethod = method = SwingUtilities2Wrapper.findStringWidthMethod(component, fontMetrics, str);
            }
            if (method != null) {
                return ((Number)method.invoke(null, component, fontMetrics, str)).intValue();
            }
            preferNativeStringWidthMethod = false;
        }
        catch (NoClassDefFoundError e) {
            preferNativeStringWidthMethod = false;
        }
        catch (IllegalAccessError e) {
            preferNativeStringWidthMethod = false;
        }
        catch (Exception ignore) {
            preferNativeStringWidthMethod = false;
        }
        return fontMetrics.stringWidth(str);
    }

    private static Method findSkipClickCountMethod(Component dispatchComponent, int count) {
        Object[] params = new Object[]{dispatchComponent, count};
        try {
            return ReflectionUtils.findMatchingMethod("sun.swing.SwingUtilities2", "setSkipClickCount", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static void setSkipClickCount(Component dispatchComponent, int count) {
        try {
            Method method = skipClickCountMethodMethod;
            if (method == null && preferNativeSkipClickCountMethod) {
                skipClickCountMethodMethod = method = SwingUtilities2Wrapper.findSkipClickCountMethod(dispatchComponent, count);
            }
            if (method != null) {
                method.invoke(null, dispatchComponent, count);
            } else {
                preferNativeSkipClickCountMethod = false;
                if (dispatchComponent instanceof JTextComponent && ((JTextComponent)dispatchComponent).getCaret() instanceof DefaultCaret) {
                    ((JTextComponent)dispatchComponent).putClientProperty(SKIP_CLICK_COUNT, count);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            preferNativeSkipClickCountMethod = false;
        }
        catch (IllegalAccessError e) {
            preferNativeSkipClickCountMethod = false;
        }
        catch (Exception ignore) {
            preferNativeSkipClickCountMethod = false;
        }
    }

    static {
        preferNativeStringWidthMethod = true;
        skipClickCountMethodMethod = null;
        preferNativeSkipClickCountMethod = true;
        SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
    }
}

