/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.ide;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.appwork.app.gui.BasicGui;
import org.appwork.resources.AWUTheme;
import org.appwork.resources.IconRefImpl;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.searchcombo.SearchComboBox;

public class SearchComboBoxExample {
    public static void main(String[] args) {
        BasicGui gui = new BasicGui(SearchComboBox.class.getSimpleName()){

            @Override
            protected void layoutPanel() {
                try {
                    final SearchComboBox<String> box1 = new SearchComboBox<String>(){
                        private static final long serialVersionUID = 743905470697711746L;

                        @Override
                        protected Icon getIconForValue(String value) {
                            return value == null ? new IconRefImpl("close").icon(28) : AWUTheme.getInstance().getIcon(value, 28);
                        }

                        @Override
                        protected String getTextForValue(String value) {
                            return value + "-icon";
                        }
                    };
                    String p = AWUTheme.I().getPath();
                    ArrayList<String> list = new ArrayList<String>();
                    URL images = AWUTheme.class.getResource(p + "images");
                    for (String s : new File(images.toURI()).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".png");
                        }
                    })) {
                        list.add(s.replace(".png", ""));
                    }
                    MigPanel contentPane = new MigPanel("ins 10,wrap 1", "[grow,fill]", "[]");
                    this.getFrame().setContentPane(contentPane);
                    box1.setList(list);
                    box1.setBorder(BorderFactory.createEtchedBorder());
                    this.getFrame().getContentPane().add(box1);
                    final JToggleButton toggle = new JToggleButton("Toggle Allow unknown");
                    this.getFrame().getContentPane().add(toggle);
                    toggle.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            box1.setUnkownTextInputAllowed(toggle.isSelected());
                        }
                    });
                    final JToggleButton toggle2 = new JToggleButton("Toggle HelpText");
                    this.getFrame().getContentPane().add(toggle2);
                    toggle2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            box1.setHelpText(toggle2.isSelected() ? "I'm Help Text" : null);
                        }
                    });
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void requestExit() {
                System.exit(1);
            }
        };
    }
}

