/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;

public abstract class ExtRadioColumn<E>
extends ExtColumn<E>
implements ActionListener {
    private static final long serialVersionUID = -5391898292508477789L;
    private final JRadioButton renderer = new JRadioButton();
    private final JRadioButton editor = new JRadioButton();

    public ExtRadioColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                boolean b2;
                boolean b1 = ExtRadioColumn.this.getBooleanValue(o1);
                if (b1 == (b2 = ExtRadioColumn.this.getBooleanValue(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return b1 && !b2 ? -1 : 1;
                }
                return !b1 && b2 ? -1 : 1;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editor.removeActionListener(this);
        this.fireEditingStopped();
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
        this.editor.removeActionListener(this);
        this.editor.setSelected(this.getBooleanValue(value));
        this.editor.addActionListener(this);
    }

    @Override
    public final void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.setSelected(this.getBooleanValue(value));
    }

    protected abstract boolean getBooleanValue(E var1);

    @Override
    public final Object getCellEditorValue() {
        return this.editor.isSelected();
    }

    @Override
    public int getClickcount() {
        return 1;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }

    @Override
    public int getMinWidth() {
        return 30;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void resetEditor() {
        this.editor.setHorizontalAlignment(0);
        this.editor.setOpaque(false);
    }

    @Override
    public void resetRenderer() {
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setOpaque(false);
    }

    protected abstract void setBooleanValue(boolean var1, E var2);

    @Override
    public final void setValue(Object value, E object) {
        this.setBooleanValue((Boolean)value, object);
    }
}

