/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.defaultimpl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.StorageException;
import org.appwork.storage.simplejson.mapper.MapperException;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.UrlFactoryInterface;
import org.appwork.updatesys.client.UrlModifier;
import org.appwork.updatesys.client.iid.HIDProviderInterface;
import org.appwork.updatesys.client.iid.UIDProviderInterface;
import org.appwork.updatesys.transport.DataExchange;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.reflection.Clazz;

public class UrlFactoryImpl
implements UrlFactoryInterface {
    protected final UpdateClient client;
    protected final List<UrlModifier> modifier = new CopyOnWriteArrayList<UrlModifier>();

    public UpdateClient getClient() {
        return this.client;
    }

    public UrlFactoryImpl(UpdateClient client) {
        this.client = client;
    }

    @Override
    public void addModifier(UrlModifier urlModifier) {
        this.getModifier().add(urlModifier);
    }

    protected List<UrlModifier> getModifier() {
        return this.modifier;
    }

    protected void append(StringBuilder sb) throws InterruptedException {
    }

    protected void trackException(Throwable e) throws InterruptedException {
        this.getClient().trackException(e);
    }

    @Override
    public URL createUrl(DataExchange<?> exchange) throws InterruptedException {
        String custom;
        StringBuilder sb = new StringBuilder();
        String updateServer = this.getClient().getUpdateServer();
        sb.append(updateServer);
        if (!updateServer.endsWith("/")) {
            sb.append("/");
        }
        if ((custom = exchange.buildCustomURL()) == null) {
            Class<?> clazz = exchange.getClass();
            while (clazz.getName().contains("$")) {
                clazz = clazz.getSuperclass();
            }
            sb.append(this.encode(clazz.getSimpleName().toLowerCase(Locale.ENGLISH)));
            sb.append("?");
            boolean isSelfTest = this.getClient().isSelfTestProcess();
            sb.append("st=" + (isSelfTest ? 1 : 0));
            sb.append("&");
            sb.append("rt");
            sb.append("=");
            sb.append(isSelfTest ? "ST" : "SO");
            String jarname = this.getJarName();
            if (StringUtils.isNotEmpty(jarname)) {
                sb.append("&");
                sb.append("jn");
                sb.append("=");
                sb.append(this.encode(jarname));
            }
            sb.append("&");
            sb.append("pv");
            sb.append("=");
            sb.append(UpdateClient.PROTOCOL_VERSION);
            sb.append("&");
            sb.append("cv");
            sb.append("=");
            sb.append(20210716001L);
            sb.append("&");
            sb.append("pkh");
            sb.append("=");
            sb.append(this.getKeyHash());
            sb.append("&");
            sb.append("app");
            sb.append("=");
            sb.append(this.encode(this.getAppID()));
            sb.append("&");
            sb.append("os");
            sb.append("=");
            sb.append(this.getOSID());
            sb.append("&");
            sb.append("osr");
            sb.append("=");
            sb.append(this.getOSRelease());
            sb.append("&");
            sb.append("arch");
            sb.append("=");
            sb.append(this.getARCHFamily());
            sb.append("&");
            sb.append("os64");
            sb.append("=");
            sb.append(this.isOs64Bit() ? 1 : 0);
            sb.append("&");
            sb.append("jvm64");
            sb.append("=");
            sb.append(this.isJVM64Bit() ? 1 : 0);
            sb.append("&");
            sb.append("java");
            sb.append("=");
            sb.append(JVMVersion.get());
            try {
                UIDProviderInterface uidProvider = this.getClient().getUIDProvider();
                if (uidProvider != null) {
                    uidProvider.appendToUrl(sb);
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                this.trackException(e);
            }
            try {
                HIDProviderInterface hidProvider = this.getClient().getHIDProvider();
                if (hidProvider != null) {
                    hidProvider.appendToUrl(sb);
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                this.trackException(e);
            }
            try {
                this.append(sb);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                this.trackException(e);
            }
            for (Method m : exchange.getClass().getMethods()) {
                m.setAccessible(true);
                if (!m.getName().startsWith("get") || !m.getName().endsWith("UrlParameter") || m.getParameterTypes().length != 0) continue;
                try {
                    StringBuilder key = new StringBuilder();
                    key.append("&");
                    key.append(m.getName().substring(3, m.getName().length() - 12).toLowerCase(Locale.ENGLISH));
                    key.append("=");
                    String value = m.getReturnType() == String.class ? this.encode((String)m.invoke(exchange, new Object[0])) : (Clazz.isEnum(m.getReturnType()) ? this.encode(((Enum)m.invoke(exchange, new Object[0])).name()) : this.encode(this.serializeToJson(m.invoke(exchange, new Object[0]))));
                    if (!StringUtils.isNotEmpty(value)) continue;
                    sb.append((CharSequence)key);
                    sb.append(value);
                }
                catch (Exception e) {
                    this.trackException(e);
                }
            }
            sb.append("&");
            sb.append(this.getClient().getServerTime().now().getMs());
            sb.append(".").append(Time.systemIndependentCurrentJVMTimeMillis());
        } else {
            sb.append(custom);
        }
        String url = sb.toString();
        for (UrlModifier urlModifier : this.getModifier()) {
            try {
                String modifiedURL = urlModifier.run(url);
                URLHelper.verifyURL(new URL(modifiedURL));
                url = modifiedURL;
            }
            catch (Throwable e) {
                this.trackException(e);
            }
        }
        try {
            if (!url.contains("&lng=")) {
                String modifiedURL = url = url + "&lng=" + this.encode(TranslationFactory.getDesiredLanguage());
                URLHelper.verifyURL(new URL(modifiedURL));
                url = modifiedURL;
            }
        }
        catch (Throwable e) {
            this.trackException(e);
        }
        try {
            String exchangedURL = exchange.modifyFinalUrl(url);
            URLHelper.verifyURL(new URL(exchangedURL));
            url = exchangedURL;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.trackException(e);
        }
        try {
            return this.createFinalURL(url);
        }
        catch (IOException e) {
            this.trackException(e);
            throw new WTFException(e);
        }
    }

    protected URL createFinalURL(String url) throws IOException {
        return new URL(url);
    }

    protected String serializeToJson(Object object) {
        try {
            SimpleMapper mapper = new SimpleMapper();
            mapper.setPrettyPrintEnabled(false);
            return mapper.getMapper().create(object).toString();
        }
        catch (MapperException e) {
            this.getClient().getLogger().log(e);
            try {
                return JSonStorage.serializeToJson(object);
            }
            catch (StorageException e2) {
                throw Exceptions.addSuppressed(e2, e);
            }
        }
    }

    public String getKeyHash() {
        return this.getClient().getKeyHash();
    }

    @Deprecated
    protected String encode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    protected String getAppID() {
        return this.getClient().getSetup().getApplicationIdentifier();
    }

    protected String getJarName() {
        String name = UpdateClient.class.getName().replaceAll("\\.", "/") + ".class";
        String url = Application.getRessourceURL(name).toString();
        int index = url.indexOf(".jar!");
        if (index < 0) {
            return null;
        }
        try {
            return new File(new URL(url.substring(4, index + 4)).toURI()).getName();
        }
        catch (MalformedURLException e) {
            this.getClient().getLogger().log(e);
        }
        catch (URISyntaxException e) {
            this.getClient().getLogger().log(e);
        }
        return null;
    }

    protected String getOSRelease() {
        return CrossSystem.OS.name();
    }

    protected String getOSID() {
        return CrossSystem.OS.getFamily().name();
    }

    protected String getARCHFamily() {
        return CrossSystem.ARCH.name();
    }

    protected boolean isJVM64Bit() {
        return Application.is64BitJvm();
    }

    protected boolean isOs64Bit() {
        return CrossSystem.is64BitOperatingSystem();
    }
}

