/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.defaultimpl.http;

import com.btr.proxy.search.ProxySearch;
import java.io.File;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.LogAndIgnoreException;
import org.appwork.updatesys.client.defaultimpl.http.HttpClientImpl;
import org.appwork.updatesys.client.defaultimpl.http.ProxySelectorSettings;
import org.appwork.updatesys.client.defaultimpl.http.UpdateHttpClientOptions;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.http.ProxySelectorInterface;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.crypto.Crypto;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;
import org.appwork.utils.net.httpconnection.proxy.WindowsProxyUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ProxyDialog;

public class ProxySelectorImpl
implements ProxySelectorInterface {
    private static final List<HTTPProxy> PL_FILE_LIST = new ArrayList<HTTPProxy>();
    public static final byte[] IV = new byte[]{1, 2, 17, 2, 0, 84, 1, 3, 1, 1, 18, 1, 1, 1, 34, 1};
    public static final byte[] KEY = new byte[]{1, 3, 17, 1, 1, 84, 1, 1, 1, 2, -63, 1, 17, 1, 34, -12};
    public static final String PROXYLIST = "proxylist";
    private volatile boolean askUserForProxyEnabled = false;
    private Set<HTTPProxy> allSuccessCache;
    private Map<String, List<HTTPProxy>> cache;
    private Map<String, Set<HTTPProxy>> successCache;
    private volatile HTTPProxy latestUserProxy;
    private final AtomicInteger requests = new AtomicInteger();
    private List<HTTPProxy> systemProxies;
    private List<HTTPProxy> windowsProxies;
    protected final List<HTTPProxy> customProxies = new CopyOnWriteArrayList<HTTPProxy>();
    protected final LogInterface logger;
    private boolean initDone = false;
    private ProxySelector proxyVoleSelector;
    private long latestCacheClear = -1L;
    protected final HashMap<HTTPProxy, HTTPProxy> replaceMap = new HashMap();
    private final Map<Thread, Boolean> askAuthDialogPermissionMap = new WeakHashMap<Thread, Boolean>();
    private final Map<Thread, Boolean> askNoConnectionDialogPermissionMap = new WeakHashMap<Thread, Boolean>();

    @Deprecated
    public ProxySelectorImpl(HttpClientImpl http) {
        this(http.getLogger());
    }

    public ProxySelectorImpl(LogInterface logger) {
        ArrayList<HTTPProxyStorable> proxyStorable;
        this.logger = logger == null ? LogV3.I().getDefaultLogger() : logger;
        ProxySelectorSettings settings = this.createProxySelectorSettings();
        if (settings != null && (proxyStorable = settings.getProxies()) != null && proxyStorable.size() > 0) {
            int size = proxyStorable.size();
            for (int index = 0; index < size; ++index) {
                HTTPProxyStorable ps = proxyStorable.get(index);
                if (ps == null) continue;
                HTTPProxy p = HTTPProxy.getHTTPProxy(ps);
                if (p != null) {
                    logger.info("Restore Custom Proxy(" + index + "|" + size + "): " + JSonStorage.serializeToJson(ps));
                    this.customProxies.add(p);
                    continue;
                }
                logger.info("Failed Custom Proxy(" + index + "|" + size + "): " + JSonStorage.serializeToJson(ps));
            }
        }
    }

    public ProxySelectorImpl() {
        this((LogInterface)null);
    }

    protected ProxySelectorSettings createProxySelectorSettings() {
        ProxySelectorSettings ret = JsonConfig.create("cfg/ProxySelector", ProxySelectorSettings.class);
        this.mergeDeprecatedProxyStorages(ret, "cfg/updateclient/HttpSettings");
        this.mergeDeprecatedProxyStorages(ret, "cfg/http");
        return ret;
    }

    protected void mergeDeprecatedProxyStorages(ProxySelectorSettings ret, String path) {
        File file = Application.getResource(path + ".proxy.json");
        URL url = Application.class.getClassLoader().getResource(path + ".proxy.json");
        if (file.exists() || url != null) {
            HTTPProxyStorable newProxy = JsonConfig.create(path, UpdateHttpClientOptions.class).getProxy();
            if (newProxy != null) {
                HashSet<String> avoidDupes = new HashSet<String>();
                ArrayList<HTTPProxyStorable> newList = new ArrayList<HTTPProxyStorable>();
                ArrayList<HTTPProxyStorable> existingList = ret.getProxies();
                if (existingList != null) {
                    for (HTTPProxyStorable existingProxy : existingList) {
                        if (!avoidDupes.add(JSonStorage.serializeToJson(existingProxy))) continue;
                        newList.add(existingProxy);
                    }
                }
                if (avoidDupes.add(JSonStorage.serializeToJson(newProxy))) {
                    newList.add(newProxy);
                }
                ret.setProxies(newList);
            }
            file.delete();
        }
    }

    protected Map<String, List<HTTPProxy>> createCache() {
        return new HashMap<String, List<HTTPProxy>>();
    }

    protected Set<HTTPProxy> createAllSuccessCache() {
        return new HashSet<HTTPProxy>();
    }

    protected Map<String, Set<HTTPProxy>> createSuccessCache() {
        return new HashMap<String, Set<HTTPProxy>>();
    }

    protected String _getTranslationProxyDialogAuthRequired(URL url) {
        return "The Updater cannot connect to the Internet! Your Proxy Server requires authentication. \r\nCheck your credentials...";
    }

    protected String _getTranslationProxyDialogNoConnection(URL url) {
        return "The Updater cannot connect to the Internet! Please check your connection settings...";
    }

    protected String _getTranslationProxyDialogTitleAuthRequired(URL ur) {
        return _AWU.T.proxydialog_title();
    }

    protected String _getTranslationProxyDialogTitleNoConnection(URL ur) {
        return _AWU.T.proxydialog_title();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HTTPProxy dialog(Object context, ProxyDialog pd) throws DialogClosedException, DialogCanceledException, ProxySelectorException {
        int request = this.requests.incrementAndGet();
        System.out.println("Request proxy:" + request);
        ProxySelectorImpl proxySelectorImpl = this;
        synchronized (proxySelectorImpl) {
            try {
                if (this.latestUserProxy != null) {
                    HTTPProxy hTTPProxy2 = this.latestUserProxy;
                    return hTTPProxy2;
                }
                this.showDialog(pd);
                HTTPProxy newProxy = pd.getProxy();
                if (newProxy != null) {
                    this.latestUserProxy = newProxy;
                }
                HTTPProxy hTTPProxy = newProxy;
                return hTTPProxy;
            }
            finally {
                if (this.requests.decrementAndGet() == 0) {
                    this.latestUserProxy = null;
                }
            }
        }
    }

    protected void showDialog(ProxyDialog pd) throws DialogClosedException, DialogCanceledException {
        Dialog.getInstance().showDialog(pd);
    }

    protected synchronized void addDupeSafe(Set<HTTPProxy> destSet, Iterable<HTTPProxy> source) {
        if (source != null && destSet != null) {
            block3: for (HTTPProxy add : source) {
                if (add == null) continue;
                switch (add.getType()) {
                    case DIRECT: 
                    case HTTP: 
                    case HTTPS: 
                    case SOCKS4: 
                    case SOCKS4A: 
                    case SOCKS5: {
                        if (!StringUtils.isEmpty(add.getHost())) break;
                        continue block3;
                    }
                }
                HTTPProxy replace = this.replaceMap.get(add);
                if (replace != null) {
                    add = replace;
                }
                for (HTTPProxy result : destSet) {
                    if (result != null && (result.getType() != add.getType() || !StringUtils.equals(result.getHost(), add.getHost()) || result.getPort() != add.getPort())) continue;
                    continue block3;
                }
                destSet.add(add);
            }
        }
    }

    @Override
    public synchronized List<HTTPProxy> getProxies(Object context, URL url) {
        this.ensureInit();
        List<HTTPProxy> ret = this.cache.get(this.getCacheKey(url));
        if (ret == null || ret.size() == 0) {
            LinkedHashSet<HTTPProxy> resultSet = new LinkedHashSet<HTTPProxy>();
            Set<HTTPProxy> success = this.getDomainSuccessCache(url);
            if (success != null) {
                this.addDupeSafe(resultSet, success);
            } else {
                this.addDupeSafe(resultSet, this.allSuccessCache);
            }
            this.addCustomProxy(resultSet);
            this.logger.info("Add PL List Proxies: " + PL_FILE_LIST);
            this.addDupeSafe(resultSet, PL_FILE_LIST);
            this.addProxyVoleList(url, resultSet);
            LinkedHashSet<HTTPProxy> proxiesThatHaveASmallerSuccessChance = new LinkedHashSet<HTTPProxy>();
            if (CrossSystem.isWindows()) {
                this.logger.info("Add Windows Proxies: " + this.windowsProxies);
                this.addDupeSafe(proxiesThatHaveASmallerSuccessChance, this.windowsProxies);
            }
            this.logger.info("Add System Proxies: " + this.systemProxies);
            this.addDupeSafe(proxiesThatHaveASmallerSuccessChance, this.systemProxies);
            this.logger.info("Add none Proxy");
            this.addDupeSafe(proxiesThatHaveASmallerSuccessChance, Arrays.asList(HTTPProxy.NONE));
            ArrayList<HTTPProxy> secondPriority = new ArrayList<HTTPProxy>(proxiesThatHaveASmallerSuccessChance);
            this.sortProxies(url, secondPriority);
            this.addDupeSafe(resultSet, secondPriority);
            ret = new ArrayList<HTTPProxy>(resultSet);
            this.cache.put(this.getCacheKey(url), ret);
        }
        return Collections.unmodifiableList(ret);
    }

    protected void sortProxies(URL url, List<HTTPProxy> ret) {
    }

    private synchronized Set<HTTPProxy> getDomainSuccessCache(URL url) {
        return this.successCache.get(this.getCacheKey(url));
    }

    protected void addProxyVoleList(URL url, Set<HTTPProxy> resultSet) {
        try {
            ProxySelector lProxyVoleSelector = this.proxyVoleSelector;
            if (lProxyVoleSelector == null) {
                this.logger.info("No proxy Vole Selector: " + url);
            } else {
                List<Proxy> plist = lProxyVoleSelector.select(url.toURI());
                List<? extends HTTPProxy> vole = HTTPProxy.convert(plist);
                for (HTTPProxy hTTPProxy : vole) {
                    hTTPProxy.setDoNotStoreInstance(true);
                }
                this.logger.info("Test proxy Vole Selector: " + url + ">" + vole);
                if (vole != null) {
                    this.addDupeSafe(resultSet, new ArrayList<HTTPProxy>(vole));
                }
            }
        }
        catch (Throwable e) {
            LogAndIgnoreException.logTo(e, this.logger);
        }
    }

    protected String getCacheKey(URL url) {
        return url.getHost();
    }

    protected void addCustomProxy(Set<HTTPProxy> resultSet) {
        this.logger.info("Add Custom List Proxies: " + this.customProxies);
        this.addDupeSafe(resultSet, this.customProxies);
    }

    public synchronized Set<HTTPProxy> getSuccessCache() {
        this.ensureInit();
        return new HashSet<HTTPProxy>(this.allSuccessCache);
    }

    private synchronized void ensureInit() {
        if (!this.initDone) {
            this.clearCache();
        }
    }

    public boolean isAskUserForProxyEnabled(Object context, boolean authOnly) {
        return this.askUserForProxyEnabled;
    }

    public synchronized void clearCache() {
        this.latestCacheClear = Time.systemIndependentCurrentJVMTimeMillis();
        this.successCache = this.createSuccessCache();
        this.allSuccessCache = this.createAllSuccessCache();
        this.cache = this.createCache();
        if (CrossSystem.isWindows()) {
            try {
                this.windowsProxies = WindowsProxyUtils.getWindowsRegistryProxies();
                if (this.windowsProxies != null) {
                    for (HTTPProxy p : this.windowsProxies) {
                        p.setDoNotStoreInstance(true);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        try {
            this.systemProxies = HTTPProxy.getFromSystemProperties();
            if (this.systemProxies != null) {
                for (HTTPProxy p : this.systemProxies) {
                    p.setDoNotStoreInstance(true);
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        this.initProxyVoleSelector();
        this.initDone = true;
    }

    protected void initProxyVoleSelector() {
        try {
            ProxySelector lProxyVoleSelector;
            this.logger.info("Proxy Vole Update");
            ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
            this.proxyVoleSelector = lProxyVoleSelector = proxySearch.getProxySelector();
            this.logger.info("Proxy Vole Selector: " + lProxyVoleSelector);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    @Override
    public synchronized HTTPProxy onNoConnection(Object context, List<HTTPProxy> proxyList, URL url) throws ProxySelectorException {
        this.ensureInit();
        try {
            boolean clearCache;
            if (proxyList == null) {
                proxyList = new ArrayList<HTTPProxy>();
            }
            boolean bl = clearCache = proxyList.size() == 0;
            if (!clearCache) {
                if (Time.systemIndependentCurrentJVMTimeMillis() - this.latestCacheClear > 600000L) {
                    clearCache = true;
                } else {
                    Set<HTTPProxy> sc = this.getDomainSuccessCache(url);
                    if (sc != null) {
                        for (HTTPProxy p : proxyList) {
                            if (!sc.contains(p)) continue;
                            clearCache = true;
                            break;
                        }
                    }
                }
            }
            if (clearCache) {
                List<HTTPProxy> proxiesBeforeClear = this.getProxies(context, url);
                this.logger.info("Clear Proxy Cache due to onNoConnection");
                long latestCacheClearTmp = this.latestCacheClear;
                Map<String, Set<HTTPProxy>> successCacheTmp = this.successCache;
                Set<HTTPProxy> allSuccessCacheTmp = this.allSuccessCache;
                Map<String, List<HTTPProxy>> cacheTmp = this.cache;
                List<HTTPProxy> windowsProxiesTmp = this.windowsProxies;
                List<HTTPProxy> systemProxiesTmp = this.systemProxies;
                this.clearCache();
                List<HTTPProxy> proxiesAfterClear = this.getProxies(context, url);
                HashSet<HTTPProxy> diff = new HashSet<HTTPProxy>(proxiesAfterClear);
                diff.removeAll(proxyList);
                diff.removeAll(proxiesBeforeClear);
                if (diff.size() == 0) {
                    this.logger.info("Cache Clear did not help. restore old cache.");
                    this.latestCacheClear = latestCacheClearTmp;
                    this.successCache = successCacheTmp;
                    this.successCache.remove(this.getCacheKey(url));
                    this.allSuccessCache = allSuccessCacheTmp;
                    this.cache = cacheTmp;
                    this.windowsProxies = windowsProxiesTmp;
                    this.systemProxies = systemProxiesTmp;
                } else {
                    this.logger.info("Cache Clear result: new proxies found: " + diff);
                    Iterator iterator = diff.iterator();
                    if (iterator.hasNext()) {
                        HTTPProxy p = (HTTPProxy)iterator.next();
                        this.logger.info("New Proxy Found. try " + p);
                        return p;
                    }
                    this.logger.info("Did not find a new Proxy - continue");
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        if (!this.isDialogAskNoConnectionAllowedForCurrentThread(context) || !this.isAskUserForProxyEnabled(context, false)) {
            return null;
        }
        HTTPProxy used = proxyList.size() == 0 ? null : proxyList.get(0);
        ProxyDialog pd = this.createDialogForNoConnection(context, url, used);
        try {
            return this.dialog(context, pd);
        }
        catch (DialogClosedException e) {
            this.logger.log(e);
        }
        catch (DialogCanceledException e) {
            this.logger.log(e);
        }
        return null;
    }

    @Override
    public synchronized boolean onSuccess(Object context, URL url, HTTPProxy proxy) {
        this.ensureInit();
        Set<HTTPProxy> lst = this.getDomainSuccessCache(url);
        if (lst == null) {
            lst = this.createAllSuccessCache();
        }
        String cacheKey = this.getCacheKey(url);
        boolean ret = lst.add(proxy);
        this.successCache.put(cacheKey, lst);
        this.allSuccessCache.add(proxy);
        if (ret) {
            this.cache.remove(cacheKey);
        }
        return ret;
    }

    public void setAskUserForProxyEnabled(boolean askUserForProxyEnabled) {
        this.askUserForProxyEnabled = askUserForProxyEnabled;
    }

    protected HTTPProxy updateNTLMProxyAuth(HTTPProxy usedProxy, List<String> proxyAuths) {
        this.ensureInit();
        if (proxyAuths != null) {
            for (String authMethod : proxyAuths) {
                if (!"NTLM".equalsIgnoreCase(authMethod)) continue;
                if (!usedProxy.isPreferNativeImplementation()) {
                    usedProxy.setPreferNativeImplementation(true);
                    return usedProxy;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public synchronized HTTPProxy updateProxyAuth(Object context, int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) throws ProxySelectorException {
        HTTPProxy replacedDuringSyncLock;
        this.ensureInit();
        ArrayList<HTTPProxy> removeFromReplaceMap = new ArrayList<HTTPProxy>();
        for (Map.Entry<HTTPProxy, HTTPProxy> es : this.replaceMap.entrySet()) {
            if (es.getValue() != null && !es.getValue().equals(usedProxy)) continue;
            removeFromReplaceMap.add(es.getKey());
        }
        for (HTTPProxy h : removeFromReplaceMap) {
            this.replaceMap.remove(h);
        }
        if (removeFromReplaceMap.size() > 0) {
            this.cache.remove(this.getCacheKey(url));
        }
        if ((replacedDuringSyncLock = this.replaceMap.get(usedProxy)) != null && !usedProxy.equals(replacedDuringSyncLock) && replacedDuringSyncLock != null) {
            return replacedDuringSyncLock;
        }
        HTTPProxy ret = this.updateNTLMProxyAuth(usedProxy, proxyAuths);
        if (ret != null) {
            if (usedProxy != ret) {
                this.replaceMap.put(usedProxy, ret);
            }
            return ret;
        }
        if (!this.isDialogAskAuthRequiredAllowedForCurrentThread(context) || !this.isAskUserForProxyEnabled(context, true)) {
            return null;
        }
        if (proxyAuths == null || proxyAuths.size() <= 0) {
            return this.onNoConnection(context, this.getProxies(context, url), url);
        }
        ProxyDialog pd = this.createDialogForProxyAuthMissing(usedProxy, url);
        pd.setAuthRequired(true);
        try {
            HTTPProxy ret2 = this.dialog(context, pd);
            if (usedProxy != ret2) {
                this.replaceMap.put(usedProxy, ret2);
            }
            return ret2;
        }
        catch (DialogClosedException e) {
            this.logger.log(e);
        }
        catch (DialogCanceledException e) {
            this.logger.log(e);
        }
        return null;
    }

    protected ProxyDialog createDialogForNoConnection(Object context, URL url, HTTPProxy used) {
        ProxyDialog pd = new ProxyDialog(used, this._getTranslationProxyDialogNoConnection(url));
        pd.setTitle(this._getTranslationProxyDialogTitleNoConnection(url));
        return pd;
    }

    protected ProxyDialog createDialogForProxyAuthMissing(HTTPProxy usedProxy, URL url) {
        ProxyDialog pd = new ProxyDialog(usedProxy, this._getTranslationProxyDialogAuthRequired(url));
        pd.setTitle(this._getTranslationProxyDialogTitleAuthRequired(url));
        return pd;
    }

    @Override
    public boolean setDialogAskAuthRequiredAllowedForCurrentThread(boolean b) {
        return this.setDialogAskAuthRequiredAllowedForCurrentThread(Thread.currentThread(), b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDialogAskAuthRequiredAllowedForCurrentThread(Thread t, boolean b) {
        this.logger.finer("Set Thread DialogAskAuthRequiredAllowed " + b);
        Map<Thread, Boolean> map = this.askAuthDialogPermissionMap;
        synchronized (map) {
            Boolean old = b ? this.askAuthDialogPermissionMap.remove(t) : this.askAuthDialogPermissionMap.put(t, b);
            return old == null || old != false;
        }
    }

    @Override
    public boolean setDialogAskNoConnectionAllowedForCurrentThread(boolean b) {
        return this.setDialogAskNoConnectionAllowedForCurrentThread(Thread.currentThread(), b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDialogAskNoConnectionAllowedForCurrentThread(Thread t, boolean b) {
        this.logger.finer("Set Thread DialogAskNoConnectionAllowed " + b);
        Map<Thread, Boolean> map = this.askNoConnectionDialogPermissionMap;
        synchronized (map) {
            Boolean old = b ? this.askNoConnectionDialogPermissionMap.remove(t) : this.askNoConnectionDialogPermissionMap.put(t, b);
            return old == null || old != false;
        }
    }

    @Override
    public boolean isDialogAskAuthRequiredAllowedForCurrentThread(Object context) {
        return this.isDialogAskAuthRequiredAllowedForCurrentThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDialogAskAuthRequiredAllowedForCurrentThread(Thread t) {
        Boolean ret;
        Map<Thread, Boolean> map = this.askAuthDialogPermissionMap;
        synchronized (map) {
            ret = this.askAuthDialogPermissionMap.get(t);
        }
        return ret == null || ret != false;
    }

    @Override
    public boolean isDialogAskNoConnectionAllowedForCurrentThread(Object context) {
        return this.isDialogAskNoConnectionAllowedForCurrentThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDialogAskNoConnectionAllowedForCurrentThread(Thread t) {
        Boolean ret;
        Map<Thread, Boolean> map = this.askNoConnectionDialogPermissionMap;
        synchronized (map) {
            ret = this.askNoConnectionDialogPermissionMap.get(t);
        }
        return ret == null || ret != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File pl = null;
        try {
            ArrayList<HTTPProxyStorable> restored;
            pl = Application.getTempResource("pl");
            if (pl.exists() && (restored = JSonStorage.restoreFromString(Crypto.decrypt(IO.readFile(Application.getTempResource("pl")), KEY, IV), new TypeRef<ArrayList<HTTPProxyStorable>>(){})) != null) {
                for (HTTPProxyStorable pd : restored) {
                    HTTPProxy p = HTTPProxy.getHTTPProxy(pd);
                    if (p == null) continue;
                    PL_FILE_LIST.add(p);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (pl != null) {
                pl.delete();
                pl.deleteOnExit();
            }
        }
    }
}

