/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.iid;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.iid.ChangeableIDProviderInterface;
import org.appwork.updatesys.client.iid.IDsStorable;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.StringUtils;
import org.appwork.utils.extioexceptions.CouldNotWriteFileExtIOException;
import org.appwork.utils.logging2.LogInterface;

public abstract class AbstractChangeableIDProvider
implements ChangeableIDProviderInterface {
    protected final UpdateClient client;
    protected volatile IDsStorable ids;
    protected File idFile;

    @Override
    public String getAcceptedID() throws ExtIOException, InterruptedException {
        IDsStorable ids = this.ids;
        return ids == null ? null : ids.getAcceptedID();
    }

    @Override
    public boolean updateID(String newID) throws ExtIOException, InterruptedException {
        if (!this.isValidID(newID)) {
            return false;
        }
        if (StringUtils.equals(newID, this.getAcceptedID())) {
            if (this.ids.getNewID() != null) {
                this.ids.setNewID(null);
                this.save();
            }
            return false;
        }
        if (StringUtils.equals(newID, this.getNewID())) {
            return false;
        }
        this.ids.setNewID(newID);
        this.save();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDsStorable loadIDsFromDisk() {
        File file = this.getIdFile();
        if (file != null && file.isFile()) {
            this.getLogger().info(this + " ID File: " + file);
            try {
                IDsStorable ids = null;
                FileInputStream fis = this.getClient().getFileSystem().openFileInputStream(file);
                try {
                    ids = JSonStorage.getMapper().inputStreamToObject((InputStream)fis, IDsStorable.TYPE);
                }
                finally {
                    fis.close();
                }
                if (ids != null) {
                    return ids;
                }
                this.getLogger().info("ID: empty!");
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    protected String encode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    @Override
    public String getNewID() throws ExtIOException, InterruptedException {
        return this.ids == null ? null : this.ids.getNewID();
    }

    @Override
    public void appendToUrl(StringBuilder url) throws InterruptedException, ExtIOException {
        try {
            String acceptedID = this.getAcceptedID();
            if (acceptedID != null) {
                url.append("&" + this.getParameterNameForAcceptedID() + "=" + this.encode(acceptedID));
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        try {
            String newID = this.getNewID();
            if (newID != null) {
                url.append("&" + this.getParameterNameForNewID() + "=" + this.encode(newID));
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
    }

    protected abstract String getParameterNameForNewID();

    protected abstract String getParameterNameForAcceptedID();

    public AbstractChangeableIDProvider(UpdateClient updateClient) throws ExtIOException {
        this.client = updateClient;
        this.init();
    }

    protected UpdateClient getClient() {
        return this.client;
    }

    protected LogInterface getLogger() {
        return this.getClient().getLogger();
    }

    protected void init() throws ExtIOException {
        this.idFile = new File(this.getClient().getPathBuilder().getUIDFile(this.getClient()).getParentFile(), this.getFileName());
        this.ids = this.loadIDsFromDisk();
        if (this.ids == null) {
            this.ids = new IDsStorable();
        }
    }

    protected String getFileName() {
        return "uid";
    }

    protected boolean writeString(File file, String uid) throws ExtIOException {
        return AbstractChangeableIDProvider.writeStringSecureAndValidateContents(this.getClient(), file, uid);
    }

    public static boolean writeStringSecureAndValidateContents(final UpdateClient client, final File file, final String string) throws ExtIOException {
        return Boolean.TRUE.equals(new NonInterruptibleRunnable<Boolean, ExtIOException>(){

            @Override
            public Boolean run() throws ExtIOException, InterruptedException {
                String existing;
                FileAccessHandler fileSystem = client.getFileSystem();
                String string2 = existing = file.isFile() ? fileSystem.readFileToString(file) : null;
                if (StringUtils.equals(string, existing)) {
                    return false;
                }
                File tmp = new File(file.getAbsolutePath() + ".tmp");
                fileSystem.secureWrite(tmp, string.getBytes(UpdateClient.UTF8), true);
                String read = fileSystem.readFileToString(tmp);
                if (StringUtils.equals(read, string)) {
                    fileSystem.moveFile(tmp, file, true);
                    return true;
                }
                tmp.delete();
                throw new CouldNotWriteFileExtIOException(UpdTrans.I().getErrorCannotWriteFile(file), null, file);
            }
        }.startAndWait());
    }

    @Override
    public boolean hasValidID() throws ExtIOException, InterruptedException {
        return this.isValidID(this.getNewID()) || this.isValidID(this.getAcceptedID());
    }

    protected abstract boolean isValidID(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() throws ExtIOException, InterruptedException {
        IDsStorable ids = this.ids;
        if (this.writeString(this.getIdFile(), JSonStorage.serializeToJson(ids))) {
            this.getLogger().info(this.getClient().getSetup().getApplicationIdentifier() + ": Saved UIDs: " + JSonStorage.serializeToJson(ids));
            File historyFile = new File(this.getIdFile().getAbsolutePath() + ".history");
            FileOutputStream fos = this.getClient().getFileSystem().openFileOutputStream(historyFile, true);
            try {
                try {
                    if (historyFile.length() > 0L) {
                        fos.write(",\r\n".getBytes(UpdateClient.UTF8));
                    }
                    JSonStorage.getMapper().writeObject(fos, new HistoryEntry(ids));
                }
                finally {
                    fos.close();
                }
            }
            catch (IOException e) {
                this.getLogger().exception("Exception in ChangeableUIDProvider.save", e);
            }
        }
    }

    protected File getIdFile() {
        return this.idFile;
    }

    @Override
    public void onServerSentAcceptedID(String id) throws ExtIOException, InterruptedException {
        if (this.isValidID(id) && !StringUtils.equalsIgnoreCase(this.getAcceptedID(), id)) {
            IDsStorable newIds = new IDsStorable();
            newIds.setAcceptedID(id);
            if (this.ids != null) {
                newIds.setExtras(this.ids.getExtras());
            }
            this.ids = newIds;
            this.save();
        }
    }

    public static class HistoryEntry
    implements Storable {
        private String dateFormatted;
        private IDsStorable ids;
        private long date;

        public IDsStorable getIds() {
            return this.ids;
        }

        public void setIds(IDsStorable ids) {
            this.ids = ids;
        }

        public String getDateFormatted() {
            return this.dateFormatted;
        }

        public void setDateFormatted(String dateFormatted) {
            this.dateFormatted = dateFormatted;
        }

        public HistoryEntry() {
        }

        public HistoryEntry(IDsStorable ids) {
            this.date = System.currentTimeMillis();
            this.dateFormatted = new Date(this.date).toString();
            this.ids = ids;
        }

        public long getDate() {
            return this.date;
        }

        public void setDate(long date) {
            this.date = date;
        }
    }
}

