/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashSet;
import org.appwork.exceptions.WTFException;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.AbstractBackupFileWriter;
import org.appwork.updatesys.client.install.BackupFileReader;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ExtIOException;

public class BackupFileWriterImpl
extends AbstractBackupFileWriter {
    private final BufferedWriter writer;
    private int counter;
    private final File file;
    private final HashSet<Integer> set;
    private FileOutputStream fos;

    public BackupFileWriterImpl(UpdateClient client, File backupFile) throws ExtIOException, InterruptedException {
        this(client, backupFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupFileWriterImpl(UpdateClient client, File backupFile, boolean append) throws ExtIOException, InterruptedException {
        block15: {
            this.file = backupFile;
            backupFile.getParentFile().mkdirs();
            if (append && backupFile.exists() && backupFile.length() > 0L) {
                this.set = new HashSet();
                try {
                    BackupFileReader reader = new BackupFileReader(client, backupFile);
                    try {
                        InstallerAction entry;
                        while ((entry = reader.read()) != null) {
                            this.set.add(entry.hashCode());
                        }
                        break block15;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (ExtIOException e) {
                    throw e;
                }
                catch (ClosedByInterruptException e) {
                    throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                }
                catch (IOException e) {
                    throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
                }
            }
            this.set = null;
        }
        try {
            FileAccessHandler fileSystem = client.getFileSystem();
            fileSystem.mkdirs(backupFile.getParentFile());
            this.fos = fileSystem.openFileOutputStream(backupFile, append);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fos, "UTF-8"));
        }
        catch (ExtIOException e) {
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (IOException e1) {
                    Exceptions.addSuppressed(e, e1);
                }
            }
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
        this.counter = this.file.length() > 0L ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean write(InstallerAction entry) throws IOException {
        if (entry == null) {
            return false;
        }
        if (this.set != null && this.set.contains(entry.hashCode())) {
            return false;
        }
        if (this.counter > 0) {
            this.writer.write("\r\n");
        }
        ++this.counter;
        this.writer.write(entry.getID());
        for (String s : entry.getParameters()) {
            this.writer.write("\r\n");
            this.writer.write(s);
        }
        this.writer.flush();
        return true;
    }
}

