/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.tracker;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.UpdateClientBatchRequest;
import org.appwork.updatesys.client.http.HttpClientInterface;
import org.appwork.updatesys.client.servertime.ServerTimeHandler;
import org.appwork.updatesys.client.tracker.BatchRequestWithCustomHttpClient;
import org.appwork.updatesys.client.tracker.TrackConfig;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.exchange.AbstractTrackDataItem;
import org.appwork.updatesys.transport.exchange.CannotRestoreItemException;
import org.appwork.updatesys.transport.exchange.SendBlocker;
import org.appwork.updatesys.transport.exchange.SyncedTime;
import org.appwork.updatesys.transport.exchange.TrackDataItemLogEntry;
import org.appwork.updatesys.transport.exchange.batch.BatchRequest;
import org.appwork.updatesys.transport.exchange.batch.BatchResponse;
import org.appwork.updatesys.transport.exchange.batch.JobRequest;
import org.appwork.updatesys.transport.exchange.track.ExceptionTrackData;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.NonInterruptibleRunnableSimple;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.BasicHTTP.BasicHTTPException;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class Tracker {
    protected final UpdateClient updateClient;
    protected final File file;
    protected List<TrackDataItemLogEntry> entries;
    protected final AtomicReference<Thread> thread = new AtomicReference<Object>(null);
    protected final TrackConfig config;
    protected final HttpClientInterface httpClient;
    protected final AtomicLong doNotSendAnythingUntil = new AtomicLong(-1L);
    private volatile boolean disposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureThread() {
        Tracker tracker = this;
        synchronized (tracker) {
            Thread thread;
            if (this.thread.get() == null && !this.disposed && this.thread.compareAndSet(null, thread = new Thread("Track Sender " + this.getUpdateClient()){

                private boolean isAbort() {
                    return Thread.currentThread() != Tracker.this.thread.get() || Tracker.this.disposed;
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK], 0[TRYBLOCK]], but top level block is 12[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            })) {
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void dispose() {
        new NonInterruptibleRunnableSimple(){

            @Override
            protected void execute() throws InterruptedException {
                Tracker.this.dispose_interruptible();
            }
        }.startAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose_interruptible() throws InterruptedException {
        Thread thread;
        Tracker tracker = this;
        synchronized (tracker) {
            this.disposed = true;
            thread = this.thread.getAndSet(null);
        }
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }

    protected int getMaxBatchSize() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<TrackDataItemLogEntry> getEntriesReadyToSend(int maxReturn) {
        Tracker tracker = this;
        synchronized (tracker) {
            ArrayList<TrackDataItemLogEntry> ret = new ArrayList<TrackDataItemLogEntry>();
            if (Time.systemIndependentCurrentJVMTimeMillis() < this.doNotSendAnythingUntil.get()) {
                return ret;
            }
            Iterator<TrackDataItemLogEntry> it = this.getEntries().iterator();
            int modificationCount = 0;
            try {
                while (it.hasNext()) {
                    TrackDataItemLogEntry entry;
                    block13: {
                        entry = it.next();
                        if (entry == null) {
                            ++modificationCount;
                            it.remove();
                            continue;
                        }
                        if (Time.systemIndependentCurrentJVMTimeMillis() <= entry.getDoNotSendBefore()) continue;
                        try {
                            SendBlocker sc = entry._getItem()._getSendBlocker();
                            if (sc != null && !sc.readyToSend(entry._getItem())) {
                            }
                            break block13;
                        }
                        catch (CannotRestoreItemException e1) {
                            it.remove();
                            ++modificationCount;
                            this.getUpdateClient().getLogger().exception("Exception in Tracker.getEntriesReadyToSend", e1);
                        }
                        continue;
                    }
                    ret.add(entry);
                    if (maxReturn <= 0 || ret.size() < maxReturn) continue;
                    ArrayList<TrackDataItemLogEntry> arrayList = ret;
                    return arrayList;
                }
            }
            finally {
                if (modificationCount > 0) {
                    this.writeEntries();
                }
            }
            return ret;
        }
    }

    public Tracker(UpdateClient updateClient) {
        this.updateClient = updateClient;
        this.file = this.getStorageFile(updateClient);
        this.config = JsonConfig.create(TrackConfig.class);
        this.httpClient = updateClient.getBuilder().createHTTPClient(updateClient);
    }

    protected HttpClientInterface getHttpClient() {
        return this.httpClient;
    }

    public File getFile() {
        return this.file;
    }

    public final File getStorageFile(UpdateClient updateClient) {
        return new File(updateClient.getPathBuilder().getUIDFile(updateClient).getParentFile(), "unsentTracks");
    }

    protected UpdateClient getUpdateClient() {
        return this.updateClient;
    }

    public boolean pushItem(final AbstractTrackDataItem item) {
        try {
            if (!this.isEnabled() || item == null) {
                return false;
            }
            try {
                item.setCv(20210716001L);
            }
            catch (Throwable e) {
                this.getUpdateClient().getLogger().log(e);
            }
            try {
                item.setSt(this.getUpdateClient().isSelfTestProcess());
            }
            catch (Throwable e) {
                this.getUpdateClient().getLogger().log(e);
            }
            try {
                item.setPv(UpdateClient.PROTOCOL_VERSION);
            }
            catch (Throwable e) {
                this.getUpdateClient().getLogger().log(e);
            }
            this.initOnce();
            item.setDate(this.getUpdateClient().getServerTime().now());
            this.getUpdateClient().getLogger().info("Track " + item.getClass().getName());
            new NonInterruptibleRunnable<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws RuntimeException {
                    Tracker tracker = Tracker.this;
                    synchronized (tracker) {
                        Iterator<TrackDataItemLogEntry> it = Tracker.this.getEntries().iterator();
                        while (it.hasNext()) {
                            TrackDataItemLogEntry next = it.next();
                            if (next == null) {
                                it.remove();
                                continue;
                            }
                            try {
                                if (next._getItem() != item) continue;
                                Tracker.this.writeEntries();
                                Tracker.this.ensureThread();
                                Tracker.this.notifyAll();
                                return null;
                            }
                            catch (CannotRestoreItemException e) {
                                it.remove();
                                Tracker.this.getUpdateClient().getLogger().log(e);
                            }
                        }
                        Tracker.this.entries.add(new TrackDataItemLogEntry(item));
                        while (Tracker.this.entries.size() > Tracker.this.config.getMaxBacklogSize()) {
                            TrackDataItemLogEntry removed = Tracker.this.entries.remove(0);
                            if (removed == null) continue;
                            try {
                                Tracker.this.getUpdateClient().getLogger().info("Discard Tracker entry: " + JSonStorage.serializeToJson(removed._getItem()));
                            }
                            catch (CannotRestoreItemException e) {
                                Tracker.this.getUpdateClient().getLogger().log(e);
                            }
                        }
                        Tracker.this.writeEntries();
                        Tracker.this.ensureThread();
                        Tracker.this.notifyAll();
                    }
                    return null;
                }
            }.startAndWait();
            return true;
        }
        catch (RuntimeException e) {
            try {
                this.getUpdateClient().getLogger().log(e);
            }
            catch (RuntimeException e1) {
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws InterruptedException {
        int maxEntriesPerRequest = 25;
        while (true) {
            List<TrackDataItemLogEntry> sendNow = this.getEntriesReadyToSend(-1);
            ArrayList<TrackDataItemLogEntry> done = new ArrayList<TrackDataItemLogEntry>();
            Object lastSentBatchRequest = null;
            try {
                Object br = null;
                for (TrackDataItemLogEntry entry : sendNow) {
                    try {
                        AbstractTrackDataItem trackDataItem = entry._getItem();
                        if (br == null) {
                            br = new BatchRequestWithCustomHttpClient(this.getUpdateClient(), this.getHttpClient());
                        }
                        TrackItemJobRequest job = new TrackItemJobRequest(entry, trackDataItem._getType().name(), trackDataItem._toStorableToSend());
                        ((BatchRequest)br).add(job.withID());
                        if ((maxEntriesPerRequest <= 0 || ((BatchRequest)br).getJobs().size() < maxEntriesPerRequest) && !this.isBatchRequestBigEnoughToSend((BatchRequest)br)) continue;
                        try {
                            lastSentBatchRequest = br;
                            this.sendBatchRequest(done, (UpdateClientBatchRequest)br);
                        }
                        finally {
                            br = null;
                        }
                    }
                    catch (CannotRestoreItemException e1) {
                        this.getUpdateClient().getLogger().log(e1);
                        done.add(entry);
                    }
                }
                if (br == null) break;
                try {
                    lastSentBatchRequest = br;
                    this.sendBatchRequest(done, (UpdateClientBatchRequest)br);
                }
                finally {
                    br = null;
                }
            }
            catch (TransportException e) {
                HTTPConnection connection;
                BasicHTTPException http = Exceptions.getInstanceof(e, BasicHTTPException.class);
                if (http != null && (connection = http.getConnection()) != null) {
                    if ((connection.getResponseCode() == HTTPConstants.ResponseCode.SERVERERROR_INTERNAL.getCode() || connection.getResponseCode() == HTTPConstants.ResponseCode.REQUEST_URL_TOO_LONG.getCode() || connection.getResponseCode() == HTTPConstants.ResponseCode.REQUEST_ENTITY_TOO_LARGE.getCode()) && maxEntriesPerRequest != 1) {
                        maxEntriesPerRequest = Math.max(1, ((BatchRequest)lastSentBatchRequest).getJobs().size() / 2);
                        this.getUpdateClient().getLogger().warning("Batch Request failed due to ResponseCode " + HTTPConstants.ResponseCode.get(connection.getResponseCode()));
                        continue;
                    }
                    if (connection.getResponseCode() == HTTPConstants.ResponseCode.ERROR_BAD_REQUEST.getCode()) {
                        this.getUpdateClient().getLogger().warning("Batch Request failed due to ResponseCode " + HTTPConstants.ResponseCode.get(connection.getResponseCode()) + " (Server does not support Batch Requests yet)");
                        this.doNotSendAnythingUntil.set(Math.max(this.doNotSendAnythingUntil.get(), Time.systemIndependentCurrentJVMTimeMillis() + 21600000L));
                        return;
                    }
                }
                this.getUpdateClient().getLogger().exception("Exception in Tracker.send", e);
                this.doNotSendAnythingUntil.set(Math.max(this.doNotSendAnythingUntil.get(), Time.systemIndependentCurrentJVMTimeMillis() + 120000L));
            }
            finally {
                if (done.size() <= 0) continue;
                Tracker tracker = this;
                synchronized (tracker) {
                    if (this.getEntries().removeAll(done)) {
                        this.writeEntries();
                    }
                }
                continue;
            }
            break;
        }
    }

    private boolean isBatchRequestBigEnoughToSend(BatchRequest br) throws InterruptedException {
        byte[] bytesUnCompressed = br.toByteArray();
        if (bytesUnCompressed.length < 512000) {
            return false;
        }
        CountingOutputStream countingOutputStream = new CountingOutputStream(new NullOutputStream());
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(countingOutputStream);
            gzip.write(bytesUnCompressed);
            gzip.close();
        }
        catch (ClosedByInterruptException e) {
            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
        return countingOutputStream.transferedBytes() >= 102400L;
    }

    protected void sendBatchRequest(List<TrackDataItemLogEntry> done, UpdateClientBatchRequest br) throws InterruptedException, TransportException {
        try {
            BatchResponse batchResponse = this.getUpdateClient().batchRequest(br);
            for (JobRequest j : br.getJobs()) {
                if (!(j instanceof TrackItemJobRequest)) continue;
                if (Boolean.TRUE.equals(j._getResponse().restoreParameter(TypeRef.BOOLEAN))) {
                    done.add(((TrackItemJobRequest)j).entry);
                    continue;
                }
                ((TrackItemJobRequest)j).entry.setDoNotSendBefore(Time.systemIndependentCurrentJVMTimeMillis() + 3600000L);
                this.getUpdateClient().getLogger().warning("Server refused to accept the item and/or cannot handle the sent type: " + j.toString() + " - do not send again before " + new Date(((TrackItemJobRequest)j).entry.getDoNotSendBefore()));
            }
        }
        catch (RuntimeException e) {
            this.getUpdateClient().getLogger().log(e);
            this.doNotSendAnythingUntil.set(Math.max(this.doNotSendAnythingUntil.get(), Time.systemIndependentCurrentJVMTimeMillis() + 120000L));
            for (JobRequest j : br.getJobs()) {
                if (!(j instanceof TrackItemJobRequest)) continue;
                ((TrackItemJobRequest)j).entry.setDoNotSendBefore(Time.systemIndependentCurrentJVMTimeMillis() + 3600000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEntries() {
        Tracker tracker = this;
        synchronized (tracker) {
            try {
                this.getUpdateClient().getLogger().info("Write Track Data Entries: " + this.getEntries().size());
                this.write(this.getEntries(), this.getFile());
            }
            catch (ExtIOException e) {
                this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.writeEntries", e);
            }
            catch (StorageException e) {
                this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.writeEntries", e);
            }
            catch (RuntimeException e) {
                this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.writeEntries", e);
            }
        }
    }

    public void write(List<TrackDataItemLogEntry> entries, File file) throws ExtIOException, StorageException {
        this.getUpdateClient().getFileSystem().secureWrite(file, JSonStorage.serializeToJsonByteArray(entries), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOnce() {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.entries == null) {
                this.entries = (List)new NonInterruptibleRunnable<List<TrackDataItemLogEntry>, RuntimeException>(){

                    @Override
                    public List<TrackDataItemLogEntry> run() throws RuntimeException, InterruptedException {
                        if (Tracker.this.getFile().isFile()) {
                            try {
                                return Tracker.this.read(Tracker.this.getFile());
                            }
                            catch (ExtIOException e) {
                                Tracker.this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.TrafficTracker", e);
                            }
                            catch (InterruptedException e) {
                                Tracker.this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.TrafficTracker", e);
                            }
                        }
                        return null;
                    }
                }.startAndWait();
                if (this.entries == null) {
                    this.entries = new ArrayList<TrackDataItemLogEntry>();
                } else if (this.entries.size() > 0) {
                    this.ensureThread();
                }
                if (this.updateClient.getServerTime().isSynced()) {
                    this.onTimeSync(this.getUpdateClient().getServerTime());
                }
            }
        }
    }

    protected List<TrackDataItemLogEntry> getEntries() {
        return this.entries;
    }

    public List<TrackDataItemLogEntry> read(File file) throws ExtIOException, InterruptedException {
        if (file != null && file.isFile()) {
            String json = this.getUpdateClient().getFileSystem().readFileToString(file);
            return JSonStorage.restoreFromString(json, new TypeRef<ArrayList<TrackDataItemLogEntry>>(){});
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public ExceptionTrackData wrap(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ExceptionTrackData data = new ExceptionTrackData(throwable);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeSync(final ServerTimeHandler serverTimeHandler) {
        try {
            Tracker tracker = this;
            synchronized (tracker) {
                block16: {
                    if (this.getEntries() == null) {
                        return;
                    }
                    Iterator<TrackDataItemLogEntry> it = this.getEntries().iterator();
                    final AtomicBoolean writeRequired = new AtomicBoolean(false);
                    block11: while (true) {
                        while (it.hasNext()) {
                            TrackDataItemLogEntry entry = it.next();
                            if (entry == null) {
                                writeRequired.set(true);
                                it.remove();
                                continue;
                            }
                            try {
                                AbstractTrackDataItem item = entry._getItem();
                                ReflectionUtils.walkThroughObject(item, new ReflectionUtils.WalkThroughObjectCallBack(){

                                    @Override
                                    public void onObject(String path, Type type, Object obj) {
                                        if (type != null && type instanceof Class && SyncedTime.class.isAssignableFrom((Class)type) && obj != null && ((SyncedTime)obj).sync(serverTimeHandler)) {
                                            writeRequired.set(true);
                                        }
                                    }
                                });
                                continue block11;
                            }
                            catch (CannotRestoreItemException e1) {
                                it.remove();
                                writeRequired.set(true);
                                this.getUpdateClient().getLogger().log(e1);
                            }
                            catch (RuntimeException e) {
                                this.getUpdateClient().trackException(e);
                                this.getUpdateClient().getLogger().log(e);
                            }
                        }
                        break block16;
                        {
                            continue block11;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (writeRequired.get()) {
                            this.writeEntries();
                        }
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.getUpdateClient().trackException(e);
            this.getUpdateClient().getLogger().log(e);
        }
    }

    public static class TrackItemJobRequest
    extends JobRequest {
        public final TrackDataItemLogEntry entry;

        public TrackItemJobRequest() {
            this.entry = null;
        }

        public TrackItemJobRequest(TrackDataItemLogEntry entry, String name, Object parameter) {
            super(name, parameter);
            this.entry = entry;
        }
    }
}

