/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.updatesys.service.ConnectService;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.DesktopSupportWindows;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.ProcessOutput;

public class ConnectServiceWindowsImpl
extends ConnectService {
    public ArrayList<File> getPossibleInstallationDirectories() {
        String pfx86;
        String pfx8664;
        ArrayList<File> directories = new ArrayList<File>();
        List<String> installDirsFromRegistry = this.readInstallDirectoryFromRegistry();
        LogV3.I().getDefaultLogger().info("Search Service Installation in (registry):" + installDirsFromRegistry);
        if (installDirsFromRegistry != null && installDirsFromRegistry.size() > 0) {
            for (String installDirFromRegistry : installDirsFromRegistry) {
                if (installDirFromRegistry == null) continue;
                this.collect(new File(installDirFromRegistry), directories);
            }
        }
        if (StringUtils.isNotEmpty(pfx8664 = DesktopSupportWindows.getProgramFiles(null))) {
            this.add(new File(pfx8664, "AppWork/ConnectService"), directories);
            this.add(new File(pfx8664, "ConnectService"), directories);
            this.add(new File(pfx8664, "Connect Service"), directories);
        }
        if (StringUtils.isNotEmpty(pfx86 = DesktopSupportWindows.get32BitProgramFiles(null))) {
            this.collect(new File(pfx86, "ConnectServices"), directories);
            this.add(new File(pfx86, "AppWork/ConnectService"), directories);
            this.add(new File(pfx86, "Connect Service"), directories);
            this.add(new File(pfx86, "ConnectService"), directories);
        }
        this.add(new File(pfx86, "KTM/ConnectService"), directories);
        this.add(new File(pfx8664, "KTM/ConnectService"), directories);
        return directories;
    }

    protected List<String> readInstallDirectoryFromRegistry() {
        String directory;
        ArrayList<String> ret = new ArrayList<String>();
        ProcessOutput result = null;
        try {
            result = ProcessBuilderFactory.runCommand("reg", "query", "HKLM\\Software\\AppWork\\Connect", "/reg:32", "/v", "Directory");
            if (result.getExitCode() != 0) {
                result = ProcessBuilderFactory.runCommand("reg", "query", "HKLM\\Software\\WOW6432Node\\AppWork\\Connect", "/v", "Directory");
            }
            if (result.getExitCode() != 0) {
                result = ProcessBuilderFactory.runCommand("reg", "query", "HKLM\\Software\\AppWork\\Connect", "/v", "Directory");
            }
        }
        catch (Throwable e) {
            LogV3.I().getDefaultLogger().log(e);
        }
        if (result != null && StringUtils.isNotEmpty(directory = new Regex(result.getStdOutString(), ".*Directory\\s+REG_SZ\\s+(.*?)\\s*$").getMatch(0))) {
            ret.add(directory);
        }
        try {
            result = ProcessBuilderFactory.runCommand("wmic", "/namespace:\\\\root\\default", "class", "stdregprov", "call", "GetStringValue", "sSubKeyName=SOFTWARE\\WOW6432Node\\AppWork\\Connect", "sValueName=Directory");
            directory = new Regex(result.getStdOutString(), ".*sValue\\s*=\\s*\"?([^\";]+)\"?;.*").getMatch(0);
            if (StringUtils.isNotEmpty(directory) && !ret.contains(directory = directory.replace("\\\\", "\\"))) {
                ret.add(directory);
            }
        }
        catch (Throwable e) {
            LogV3.I().getDefaultLogger().log(e);
        }
        try {
            result = ProcessBuilderFactory.runCommand("wmic", "/namespace:\\\\root\\default", "class", "stdregprov", "call", "GetStringValue", "sSubKeyName=SOFTWARE\\AppWork\\Connect", "sValueName=Directory");
            directory = new Regex(result.getStdOutString(), ".*sValue\\s*=\\s*\"?([^\";]+)\"?;.*").getMatch(0);
            if (StringUtils.isNotEmpty(directory) && !ret.contains(directory = directory.replace("\\\\", "\\"))) {
                ret.add(directory);
            }
        }
        catch (Throwable e) {
            LogV3.I().getDefaultLogger().log(e);
        }
        return ret;
    }
}

