/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.utils.awfc.AWFCUtils;

public class DeduplicationSignature {
    private final String rel;
    private final DeduplicationMode mode;

    public String getRel() {
        return this.rel;
    }

    public DeduplicationMode getMode() {
        return this.mode;
    }

    public DeduplicationSignature(DeduplicationMode mode, String rel) {
        this.mode = mode;
        this.rel = rel;
    }

    public byte[] create() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.write(bos);
        return bos.toByteArray();
    }

    public void write(OutputStream os) throws IOException {
        AWFCUtils utils = new AWFCUtils(os);
        utils.writeShort(1);
        utils.writeString(this.mode.name());
        utils.writeString(this.rel);
    }

    public static DeduplicationSignature read(InputStream is) throws IOException {
        AWFCUtils utils = new AWFCUtils(is);
        int version = utils.readShort();
        switch (version) {
            case 1: {
                try {
                    return new DeduplicationSignature(DeduplicationMode.valueOf(utils.readString()), utils.readString());
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Unsupported DeduplicationMode", e);
                }
            }
        }
        throw new IOException("Unsupported DeduplicationSignature version=" + version);
    }
}

