/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;

public class RemovedJarFile {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final MODE mode;
    private final String path;

    public static RemovedJarFile readZipEntry(InputStream is) throws IOException {
        String removeFile = new String(IO.readStream(2048, is), UTF8);
        String[] parse = new Regex(removeFile, "^(R?D|F),(.+)").getRow(0);
        if ("RD".equals(parse[0])) {
            return new RemovedJarFile(MODE.RECURSIVE, parse[1]);
        }
        if ("D".equals(parse[0])) {
            return new RemovedJarFile(MODE.DIRECTORY, parse[1]);
        }
        if ("F".equals(parse[0])) {
            return new RemovedJarFile(MODE.FILE, parse[1]);
        }
        throw new IOException("Unknown format: " + removeFile);
    }

    public RemovedJarFile(MODE mode, String rel) {
        this.mode = mode;
        this.path = rel.endsWith("/") ? rel.substring(0, rel.length() - 1) : rel;
    }

    public byte[] createRemoveFile() throws IOException {
        StringBuilder sb = new StringBuilder();
        switch (this.mode) {
            case RECURSIVE: {
                sb.append("RD,");
                break;
            }
            case DIRECTORY: {
                sb.append("D,");
                break;
            }
            case FILE: {
                sb.append("F,");
            }
        }
        sb.append(this.path);
        return sb.toString().getBytes(UTF8);
    }

    public String getPath() {
        if (this.isDirectory() && !this.path.endsWith("/")) {
            return this.path + "/";
        }
        return this.path;
    }

    public boolean isDirectory() {
        return !MODE.FILE.equals((Object)this.getMode());
    }

    public MODE getMode() {
        return this.mode;
    }

    public static enum MODE {
        FILE,
        DIRECTORY,
        RECURSIVE;

    }
}

