/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.txtresource.LocaleMap;
import org.appwork.updatesys.transport.exchange.setup.ErrorMessageProvider;
import org.appwork.updatesys.transport.exchange.setup.ModuleNameProvider;
import org.appwork.utils.Exceptions;

@StorableValidatorIgnoresMissingSetter
public class ExceptionMatcher
implements Storable {
    private Exception exception;

    public ExceptionMatcher() {
    }

    public ExceptionMatcher(Exception installException) {
        this.exception = installException;
    }

    public String getClassName() {
        if (this.exception == null) {
            return null;
        }
        return this.exception.getClass().getName();
    }

    public String getSimpleClassName() {
        if (this.exception == null) {
            return null;
        }
        return this.exception.getClass().getSimpleName();
    }

    public String getStacktrace() {
        if (this.exception == null) {
            return null;
        }
        return Exceptions.getStackTrace(this.exception);
    }

    @StorableDoc(value="The module name object you defined in the ClientOptions or Setup json")
    public LocaleMap getModuleName() {
        if (this.exception == null || !(this.exception instanceof ModuleNameProvider)) {
            return null;
        }
        return ((ModuleNameProvider)((Object)this.exception)).getModuleName();
    }

    @StorableDoc(value="The error message object you defined in the CLientOptions or Setup json")
    public LocaleMap getMessage() {
        if (this.exception == null || !(this.exception instanceof ErrorMessageProvider)) {
            return null;
        }
        return ((ErrorMessageProvider)((Object)this.exception)).getErrorMessage();
    }
}

