/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.signature;

import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.simplejson.JSonFactory;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.storage.simplejson.JsonObjectLinkedHashMap;
import org.appwork.storage.simplejson.ParserException;
import org.appwork.utils.Hash;
import org.appwork.utils.crypto.AWSign;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.encoding.Base64;

public class JSONSignaturefactory {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int VERSION = 1;
    private static final Comparator<? super String> SORTER = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    };

    public static String create(String json, PrivateKey privateKey, String ... ignores) throws SignatureViolationException {
        JSonNode mapped = JSONSignaturefactory.parseAndCleanJSon(json, ignores);
        return Base64.encodeToString(AWSign.createSign(mapped.toString().getBytes(UTF8), privateKey, true));
    }

    protected static JSonNode parseAndCleanJSon(String json, String ... ignores) throws SignatureViolationException {
        JSonNode mapped;
        try {
            mapped = new SortedJsonFactory(json).parse();
        }
        catch (ParserException e2) {
            throw new SignatureViolationException(e2);
        }
        if (ignores != null && mapped instanceof JSonObject) {
            for (String s : ignores) {
                ((JSonObject)mapped).remove(s);
            }
        }
        return mapped;
    }

    public static void verifyParsed(String json, String signature, PublicKey publicKey, String ... ignores) throws SignatureViolationException {
        if (signature == null) {
            throw new SignatureViolationException("signature is null");
        }
        JSonNode mapped = JSONSignaturefactory.parseAndCleanJSon(json, ignores);
        String id = mapped.toString();
        try {
            AWSign.verify(id.getBytes(UTF8), publicKey, Base64.decode(signature), true);
        }
        catch (SignatureViolationException e) {
            Exception e1 = new Exception("JSON: " + id);
            e1.setStackTrace(new StackTraceElement[0]);
            e.addSuppressed(e1);
            throw e;
        }
    }

    public static String getDataHashSha256(String json, String ... ignores) {
        JSonNode mapped;
        try {
            mapped = JSONSignaturefactory.parseAndCleanJSon(json, ignores);
        }
        catch (SignatureViolationException e) {
            throw new WTFException(e);
        }
        return Hash.getSHA256(mapped.toString());
    }

    public static class SortedJSonObject
    extends JsonObjectLinkedHashMap {
        public SortedJSonObject() {
        }

        public SortedJSonObject(Map<String, JSonNode> map) {
            super(map);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            ArrayList keys = new ArrayList(this.keySet());
            Collections.sort(keys, SORTER);
            for (String key : keys) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                JSonNode next = (JSonNode)this.get(key);
                sb.append(this.toStringKey(key));
                sb.append(":");
                sb.append(next.toString());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static class SortedJsonFactory
    extends JSonFactory {
        public SortedJsonFactory(String json) {
            super(json, false);
        }

        @Override
        protected JSonObject createJSonObject() {
            return new SortedJSonObject();
        }
    }
}

