/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.TransferHandler;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Regex;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.parser.HTMLParser;

public class ClipboardUtils {
    public static final DataFlavor fileListFlavor;
    public static final DataFlavor stringFlavor;
    private static final byte[] tmpByteArray;
    public static final DataFlavor arrayListFlavor;
    public static final DataFlavor uriListFlavor;

    public static List<File> getFiles(Transferable info) {
        ArrayList<File> files = new ArrayList<File>();
        String inString = null;
        if (info != null) {
            try {
                if (info.isDataFlavorSupported(fileListFlavor)) {
                    List list = (List)info.getTransferData(fileListFlavor);
                    for (File f : list) {
                        if (!f.isAbsolute() || !f.exists()) continue;
                        files.add(f);
                    }
                } else if (uriListFlavor != null && info.isDataFlavorSupported(uriListFlavor)) {
                    inString = (String)info.getTransferData(uriListFlavor);
                    StringTokenizer izer = new StringTokenizer(inString, "\r\n");
                    while (izer.hasMoreTokens()) {
                        String token = izer.nextToken().trim();
                        try {
                            URI fi = new URI(token);
                            File f = new File(fi.getPath());
                            if (!f.isAbsolute() || !f.exists()) continue;
                            files.add(f);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Exception e) {
                LogV3.warning(inString);
                LogV3.warning(e.getMessage());
            }
        }
        return files;
    }

    public static List<File> getFiles(TransferHandler.TransferSupport info) {
        ArrayList<File> files = new ArrayList<File>();
        String inString = null;
        if (info != null) {
            try {
                if (info.isDataFlavorSupported(fileListFlavor)) {
                    List list = (List)info.getTransferable().getTransferData(fileListFlavor);
                    for (File f : list) {
                        if (!f.isAbsolute() || !f.exists()) continue;
                        files.add(f);
                    }
                } else if (uriListFlavor != null && info.isDataFlavorSupported(uriListFlavor)) {
                    inString = (String)info.getTransferable().getTransferData(uriListFlavor);
                    StringTokenizer izer = new StringTokenizer(inString, "\r\n");
                    while (izer.hasMoreTokens()) {
                        String token = izer.nextToken().trim();
                        try {
                            URI fi = new URI(token);
                            File f = new File(fi);
                            if (!f.isAbsolute() || !f.exists()) continue;
                            files.add(f);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Exception e) {
                LogV3.warning(inString);
                LogV3.warning(e.getMessage());
            }
        }
        return files;
    }

    public static List<String> getLinks(Transferable trans) {
        ArrayList<String> links = new ArrayList<String>();
        String content = null;
        DataFlavor htmlFlavor = null;
        try {
            for (DataFlavor flav : trans.getTransferDataFlavors()) {
                String charSet;
                if (!flav.getMimeType().contains("html") || !flav.getRepresentationClass().isInstance(tmpByteArray)) continue;
                if (htmlFlavor != null) {
                    htmlFlavor = flav;
                }
                if ((charSet = new Regex(flav.toString(), "charset=(.*?)]").getMatch(0)) == null || !charSet.equalsIgnoreCase("UTF-8")) continue;
                htmlFlavor = flav;
                break;
            }
            if (htmlFlavor != null) {
                String charSet = new Regex(htmlFlavor.toString(), "charset=(.*?)]").getMatch(0);
                byte[] html = (byte[])trans.getTransferData(htmlFlavor);
                if (CrossSystem.isUnix()) {
                    int htmlLength = html.length;
                    byte[] html2 = new byte[htmlLength];
                    int o = 0;
                    for (int i = 6; i < htmlLength - 1; ++i) {
                        if (html[i] == 0) continue;
                        html2[o++] = html[i];
                    }
                    html = html2;
                    content = new String(html, "UTF-8");
                } else {
                    content = charSet != null ? new String(html, charSet) : new String(html);
                }
            } else if (trans.isDataFlavorSupported(stringFlavor)) {
                content = (String)trans.getTransferData(stringFlavor);
            }
            if (content != null) {
                links.addAll(HTMLParser.findUrls(content));
            }
        }
        catch (Exception e) {
            LogV3.info(e.getMessage());
        }
        return links;
    }

    public static List<String> getLinks(TransferHandler.TransferSupport trans) {
        return ClipboardUtils.getLinks(trans.getTransferable());
    }

    public static boolean hasSupport(DataFlavor flavor) {
        if (flavor != null) {
            if (uriListFlavor != null && flavor.isMimeTypeEqual(uriListFlavor)) {
                return true;
            }
            if (fileListFlavor != null && flavor.isMimeTypeEqual(fileListFlavor)) {
                return true;
            }
            if (arrayListFlavor != null && flavor.isMimeTypeEqual(arrayListFlavor)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasSupport(TransferHandler.TransferSupport info) {
        if (info != null) {
            for (DataFlavor flavor : info.getDataFlavors()) {
                if (!ClipboardUtils.hasSupport(flavor)) continue;
                return true;
            }
        }
        return false;
    }

    private ClipboardUtils() {
    }

    public static void setTextContent(String text) {
        StringSelection selection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public static String getTextContent() {
        String data = null;
        try {
            data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    static {
        DataFlavor tmp;
        fileListFlavor = DataFlavor.javaFileListFlavor;
        stringFlavor = DataFlavor.stringFlavor;
        tmpByteArray = new byte[0];
        try {
            tmp = new DataFlavor("text/uri-list; class=java.lang.String");
        }
        catch (Throwable e) {
            tmp = null;
        }
        uriListFlavor = tmp;
        try {
            tmp = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.ArrayList");
        }
        catch (Throwable e) {
            tmp = null;
        }
        arrayListFlavor = tmp;
    }
}

