/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ConcatIterator<E>
implements Iterator<E>,
Iterable<E> {
    private final List<Iterator<? extends E>> iterators;
    private int iteratorIndex = 0;
    private E next = null;
    private boolean nextSet = false;

    public ConcatIterator(Iterator<? extends E> ... iterators) {
        this.iterators = Arrays.asList(iterators);
    }

    public ConcatIterator(Iterable<? extends E> ... iterables) {
        ArrayList<Iterator<Iterator<? extends E>>> ret = new ArrayList<Iterator<Iterator<? extends E>>>();
        for (Iterable<E> iterable : iterables) {
            if (iterable == null) continue;
            ret.add(iterable.iterator());
        }
        this.iterators = ret;
    }

    @Override
    public boolean hasNext() {
        if (this.nextSet) {
            return true;
        }
        while (this.iteratorIndex < this.iterators.size()) {
            if (this.iterators.get(this.iteratorIndex).hasNext()) {
                this.next = this.iterators.get(this.iteratorIndex).next();
                this.nextSet = true;
                return true;
            }
            ++this.iteratorIndex;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public E next() {
        if (this.nextSet) {
            E ret = this.next;
            this.next = null;
            this.nextSet = false;
            return ret;
        }
        if (this.hasNext()) {
            E ret = this.next;
            this.next = null;
            this.nextSet = false;
            return ret;
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

