/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.awfc;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.appwork.utils.awfc.AWFCEntry;
import org.appwork.utils.awfc.AWFCEntryOptions;
import org.appwork.utils.awfc.AWFCUtils;
import org.appwork.utils.net.CountingOutputStream;

public class AWFCOutputStream
extends OutputStream {
    private final OutputStream os;
    private AWFCEntryOptions currentEntry = null;
    private CountingOutputStream currentCountingOutputStream = null;
    private final MessageDigest md;
    protected boolean headerWritten = false;
    protected final AWFCUtils utils;
    private boolean closing = false;
    private int version = 1;

    public synchronized void setVersion(int version) throws IllegalArgumentException, IllegalStateException {
        if (this.headerWritten) {
            throw new IllegalStateException("header already written");
        }
        switch (version) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown AWFC Version " + version);
            }
        }
        this.version = version;
    }

    public AWFCOutputStream(OutputStream os, MessageDigest md) {
        this.os = os;
        this.md = md;
        this.utils = new AWFCUtils(){

            @Override
            public OutputStream getCurrentOutputStream() throws IOException {
                return AWFCOutputStream.this.getCurrentOutputStream();
            }
        };
    }

    @Override
    public synchronized void close() throws IOException {
        this.closing = true;
        if (!this.headerWritten) {
            this.writeAWFCHeader();
        }
        this.getCurrentOutputStream().close();
    }

    private synchronized void closeLastEntry() throws IOException {
        if (this.currentEntry != null) {
            long bytesWritten = this.currentCountingOutputStream.transferedBytes();
            AWFCEntry entry = this.currentEntry.getEntry();
            if (this.currentEntry.hasPayLoad()) {
                if (entry.getSize() != bytesWritten) {
                    throw new IOException("Wrong size for Entry: " + entry + " != " + bytesWritten);
                }
                if (entry.isFile() && this.md != null && !Arrays.equals(entry.getHash(), this.md.digest())) {
                    throw new IOException("Wrong hash for Entry: " + entry);
                }
            } else if (bytesWritten > 0L) {
                throw new IOException("Entry must not have payLoad: " + entry + " != " + bytesWritten);
            }
        } else {
            throw new IOException("No lastEntry to close!");
        }
        this.currentCountingOutputStream = null;
        this.currentEntry = null;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.getCurrentOutputStream().flush();
    }

    protected synchronized OutputStream getCurrentOutputStream() throws IOException {
        if (this.currentCountingOutputStream != null) {
            return this.currentCountingOutputStream;
        }
        if (this.currentEntry != null) {
            return this.os;
        }
        if (this.closing) {
            return this.os;
        }
        throw new IOException("No Entry added yet!");
    }

    public synchronized void putNextEntry(AWFCEntry e) throws IOException {
        this.putNextEntry(e, false);
    }

    public synchronized void putNextEntry(AWFCEntry entry, boolean noPayLoad) throws IOException {
        if (this.currentEntry != null) {
            this.closeLastEntry();
        }
        if (!entry.isFile()) {
            noPayLoad = true;
        }
        this.currentEntry = new AWFCEntryOptions(entry, noPayLoad);
        if (!this.headerWritten) {
            this.writeAWFCHeader();
        }
        this.writeAWFCEntry(this.currentEntry);
        if (this.md != null) {
            this.md.reset();
        }
        this.currentCountingOutputStream = new CountingOutputStream(this.os){

            @Override
            public void close() throws IOException {
                try {
                    AWFCOutputStream.this.closeLastEntry();
                }
                finally {
                    super.close();
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                super.write(b);
                if (AWFCOutputStream.this.md != null) {
                    AWFCOutputStream.this.md.update(b);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                if (AWFCOutputStream.this.md != null) {
                    AWFCOutputStream.this.md.update(b, off, len);
                }
            }

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                if (AWFCOutputStream.this.md != null) {
                    AWFCOutputStream.this.md.update((byte)b);
                }
            }
        };
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.getCurrentOutputStream().write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.getCurrentOutputStream().write(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.getCurrentOutputStream().write(b);
    }

    public int getVersion() {
        return this.version;
    }

    protected void writeAWFCEntry(AWFCEntryOptions awfcEntryOptions) throws IOException {
        AWFCEntry entry = awfcEntryOptions.getEntry();
        this.utils.writeString(entry.getPath());
        int entryOptions = 0;
        if (entry.isFile()) {
            entryOptions |= 1;
        }
        if (!awfcEntryOptions.hasPayLoad()) {
            entryOptions |= 2;
        }
        this.write(entryOptions);
        if (entry.isFile()) {
            this.utils.writeLongOptimized(entry.getSize());
            if (this.md != null && (entry.getSize() > 0L || this.getVersion() >= 2)) {
                if (entry.getHash() == null) {
                    throw new IOException("Hash is missing for Entry: " + entry);
                }
                if (entry.getHash().length != this.md.getDigestLength()) {
                    throw new IOException("Hashlength does not match for Entry: " + entry);
                }
                this.write(entry.getHash());
            }
        }
    }

    protected synchronized void writeAWFCHeader() throws IOException {
        this.headerWritten = true;
        this.version = this.getVersion();
        this.write(this.version);
        this.utils.writeBoolean(this.md != null);
        if (this.md != null) {
            this.utils.writeString(this.md.getAlgorithm());
            this.utils.writeShort(this.md.getDigestLength());
        }
    }
}

