/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.SVGLoader;
import com.github.weisj.jsvg.parser.impl.MutableLoaderContext;
import com.github.weisj.jsvg.view.FloatSize;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.swing.JComponent;
import org.appwork.utils.images.ScalableIcon;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.images.svg.SVGIcon;

public class WeisjJSVG {
    public WeisjJSVG(SVGFactory factory) {
    }

    protected LoaderContext createLoaderContext() {
        return MutableLoaderContext.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImageFromSVG(InputStream inputStream, URI base, int w, int h) throws IOException {
        try {
            SVGLoader loader = new SVGLoader();
            SVGDocument svgDocument = loader.load(inputStream, base, this.createLoaderContext());
            if (svgDocument != null) {
                double scaleWidth;
                FloatSize size = svgDocument.size();
                if (w <= 0) {
                    w = (int)size.getWidth();
                }
                if (h <= 0) {
                    h = (int)size.getHeight();
                }
                double scaleHeight = scaleWidth = 1.0 / Math.max(size.getWidth() / (double)w, size.getHeight() / (double)h);
                int width = Math.max((int)(size.getWidth() * scaleWidth), 1);
                int height = Math.max((int)(size.getHeight() * scaleHeight), 1);
                int x = 0;
                int y = 0;
                BufferedImage bi = new BufferedImage(width, height, 6);
                Graphics2D g = bi.createGraphics();
                if ((x += (w - width) / 2) != 0 || (y += (h - height) / 2) != 0) {
                    g.translate(x, y);
                }
                try {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    if (scaleWidth != 1.0 || scaleHeight != 1.0) {
                        g.scale(scaleWidth, scaleHeight);
                    }
                    svgDocument.render(null, g);
                }
                finally {
                    g.dispose();
                }
                return bi;
            }
            return null;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public ScalableIcon getIconFromSVG(InputStream stream, URI base, int width, int height) {
        SVGLoader loader = new SVGLoader();
        final SVGDocument svgDocument = loader.load(stream, base, this.createLoaderContext());
        if (svgDocument == null) {
            return null;
        }
        return new SVGIcon(width, height){

            @Override
            public int getIconHeight() {
                this.ensureDimensions();
                return super.getIconHeight();
            }

            private void ensureDimensions() {
                FloatSize size = svgDocument.size();
                if (super.getIconWidth() <= 0) {
                    this.setIconWidth((int)size.getWidth());
                }
                if (super.getIconHeight() <= 0) {
                    this.setIconHeight((int)size.getHeight());
                }
            }

            @Override
            public int getIconWidth() {
                this.ensureDimensions();
                return super.getIconWidth();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g1D, int x, int y, int width, int height) {
                double scaleWidth;
                FloatSize size = svgDocument.size();
                if (width <= 0) {
                    width = (int)size.getWidth();
                }
                if (height <= 0) {
                    height = (int)size.getHeight();
                }
                double scaleHeight = scaleWidth = 1.0 / Math.max(size.getWidth() / (double)width, size.getHeight() / (double)height);
                int orgWidth = width;
                int orgHeight = height;
                width = Math.max((int)Math.round(size.getWidth() * scaleWidth), 1);
                height = Math.max((int)Math.round(size.getHeight() * scaleHeight), 1);
                x += (orgWidth - width) / 2;
                y += (orgHeight - height) / 2;
                Graphics2D g = (Graphics2D)g1D.create();
                RenderingHints restoreHints = g.getRenderingHints();
                AffineTransform restoreTransform = g.getTransform();
                try {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.translate(x, y);
                    if (scaleWidth != 1.0 || scaleHeight != 1.0) {
                        g.scale(scaleWidth, scaleHeight);
                    }
                    svgDocument.render((JComponent)(c instanceof JComponent ? c : null), g);
                }
                finally {
                    g.setRenderingHints(restoreHints);
                    g.setTransform(restoreTransform);
                }
            }
        };
    }
}

