/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.utils.Application;
import org.appwork.utils.URLStream;
import org.appwork.utils.locale.Translate;

@Deprecated
public class Loc {
    public static final Storage CFG = JSonStorage.getStorage("Locale");
    private static HashMap<Integer, String> DATA = null;
    private static String DEFAULT_LOCALE_CACHE;
    private static final String FALLBACK_LOCALE = "en_GB";
    private static String locale;
    public static final String PROPERTY_LOCALE = "PROPERTY_LOCALE2";

    public static String T(Translate t) {
        return t.s();
    }

    public static String T(Translate t, Object ... parameter) {
        return t.s(parameter);
    }

    private static String getDefaultLocale() {
        if (DEFAULT_LOCALE_CACHE != null) {
            return DEFAULT_LOCALE_CACHE;
        }
        String sys = System.getProperty("user.language").toLowerCase();
        String cou = System.getProperty("user.country").toUpperCase();
        String[] locs = Loc.getLocales();
        if (locs.length == 0) {
            DEFAULT_LOCALE_CACHE = FALLBACK_LOCALE;
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String l : locs) {
                if (!l.equals(sys + "_" + cou)) continue;
                DEFAULT_LOCALE_CACHE = l;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String l : locs) {
                if (!l.equals(sys)) continue;
                DEFAULT_LOCALE_CACHE = l;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String l : locs) {
                if (!l.startsWith(sys + "_")) continue;
                DEFAULT_LOCALE_CACHE = l;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String l : locs) {
                if (!l.equals(FALLBACK_LOCALE)) continue;
                DEFAULT_LOCALE_CACHE = l;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            DEFAULT_LOCALE_CACHE = locs[0];
        }
        return DEFAULT_LOCALE_CACHE;
    }

    public static String getErrorRegex() {
        return Loc.L("system.error", ".*(error|failed).*");
    }

    public static String getLocale() {
        return locale;
    }

    public static String[] getLocales() {
        ArrayList<String> ret;
        block8: {
            ret = new ArrayList<String>();
            String[] files = Application.getResource("languages/").list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".loc");
                }
            });
            if (files != null) {
                for (String file : files) {
                    ret.add(file.substring(0, file.length() - 4));
                }
            }
            try {
                URL url = Application.getRessourceURL("languages/");
                if (url == null) break block8;
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("languages/");
                while (resources.hasMoreElements()) {
                    url = resources.nextElement();
                    if (url.getProtocol().equalsIgnoreCase("jar")) {
                        JarEntry e;
                        String path = url.getPath();
                        int index = path.lastIndexOf(33);
                        String jarPath = path.substring(0, index);
                        String internPath = path.substring(index + 2);
                        JarInputStream jarFile = new JarInputStream(new FileInputStream(new File(new URL(jarPath).toURI())));
                        while ((e = jarFile.getNextJarEntry()) != null) {
                            String jarName = e.getName();
                            if (!jarName.startsWith(internPath) || !jarName.endsWith(".loc")) continue;
                            String filename = new File(jarName).getName();
                            filename = filename.substring(0, filename.length() - 4);
                            ret.remove(filename);
                            ret.add(filename);
                        }
                        continue;
                    }
                    files = new File(url.toURI()).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".loc");
                        }
                    });
                    if (files == null) continue;
                    for (String file : files) {
                        ret.add(file.substring(0, file.length() - 4));
                    }
                }
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        return ret.toArray(new String[0]);
    }

    public static URL getResourceURL(String loc) throws MalformedURLException {
        File singleFile = Application.getResource("languages/" + loc + ".loc");
        URL file = Application.getRessourceURL("languages/" + loc + ".loc");
        if (singleFile.exists() && singleFile.length() > 0L || file == null) {
            file = singleFile.toURI().toURL();
        }
        return file;
    }

    public static String L(String key, String def) {
        String loc;
        if (key == null || (key = key.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        if (DATA == null) {
            LogV3.warning("No parsed localization found! Loading now from saved localization file!");
            try {
                Loc.setLocale(CFG.get(PROPERTY_LOCALE, FALLBACK_LOCALE));
            }
            catch (Exception e) {
                LogV3.severe("Error while loading the stored localization name!");
                Loc.setLocale(FALLBACK_LOCALE);
            }
            if (DATA == null) {
                return def == null ? "Error in Loc! No loaded data!" : def;
            }
        }
        if ((loc = DATA.get(key.toLowerCase().hashCode())) == null) {
            DATA.put(key.toLowerCase().hashCode(), def);
            return def;
        }
        return loc;
    }

    public static String LF(String key, String def, Object ... args) {
        try {
            return String.format(Loc.L(key, def), args);
        }
        catch (Exception e) {
            return "Error: " + key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseLocalization(URL file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (DATA != null) {
            LogV3.finer("Previous HashMap will be overwritten!");
        }
        DATA = new HashMap();
        BufferedReader reader = null;
        InputStreamReader isr = null;
        InputStream fis = null;
        try {
            String line;
            fis = URLStream.openStream(file);
            isr = new InputStreamReader(fis, "UTF8");
            reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                int split;
                if (line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split).toLowerCase().trim();
                String value = line.substring(split + 1).trim();
                value = value.replace("\\n", "\n").replace("\\r", "\r");
                DATA.put(key.hashCode(), value);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
            try {
                isr.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setLocale(String loc) {
        try {
            if (loc == null) {
                loc = CFG.get(PROPERTY_LOCALE, Loc.getDefaultLocale());
            }
            URL file = Loc.getResourceURL(loc);
            locale = loc;
            if (file != null) {
                CFG.put(PROPERTY_LOCALE, loc);
                Loc.parseLocalization(file);
            } else {
                LogV3.info("The language " + loc + " isn't available! Parsing default (" + FALLBACK_LOCALE + ".loc) one!");
                locale = Loc.getDefaultLocale();
                String[] locs = locale.split("_");
                Locale.setDefault(new Locale(locs[0], locs[1]));
                Loc.parseLocalization(Loc.getResourceURL(FALLBACK_LOCALE));
            }
        }
        catch (Exception e) {
            LogV3.log(e);
        }
    }
}

