/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringBuilderQueue;
import org.appwork.utils.os.CrossSystem;

public class LogFormatter
extends SimpleFormatter {
    private final Date date = new Date();
    private int lastThreadID;
    private final DateFormat longTimestamp = DateFormat.getDateTimeInstance(3, 2, Locale.ROOT);
    private final String NEWLINE = CrossSystem.getNewLine();
    private StringBuilder sb = new StringBuilder();

    @Override
    public synchronized String format(LogRecord record) {
        this.sb.setLength(0);
        StringBuilderQueue sbo = new StringBuilderQueue();
        this.date.setTime(record.getMillis());
        CharSequence message = this.getMessage(record);
        int th = record.getThreadID();
        if (th != this.lastThreadID) {
            sbo.append(this.NEWLINE);
            sbo.append("THREAD: ");
            sbo.append(th);
            sbo.append(this.NEWLINE);
        }
        this.lastThreadID = th;
        sbo.append(record.getThreadID());
        sbo.append(Character.valueOf('|'));
        sbo.append(record.getLoggerName());
        sbo.append(Character.valueOf(' '));
        sbo.append(this.longTimestamp.format(this.date));
        sbo.append(" - ");
        sbo.append(record.getLevel().getName());
        sbo.append(" [ ");
        if (record.getSourceClassName() != null) {
            sbo.append(record.getSourceClassName());
        } else {
            sbo.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sbo.append(Character.valueOf('('));
            sbo.append(record.getSourceMethodName());
            sbo.append(Character.valueOf(')'));
        }
        sbo.append(" ] -> ");
        sbo.append(message);
        sbo.append(this.NEWLINE);
        if (record.getThrown() != null) {
            sbo.append(Exceptions.getStackTrace(record.getThrown()));
            sbo.append(this.NEWLINE);
        }
        sbo.flushToStringBuilder(this.sb);
        String ret = this.sb.toString();
        if (this.sb.capacity() > Short.MAX_VALUE) {
            this.sb = new StringBuilder();
        }
        return ret;
    }

    protected CharSequence getMessage(LogRecord record) {
        return this.formatMessage(record);
    }
}

