/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HexInputStream
extends FilterInputStream {
    private static final int[] HEXMAP;

    public HexInputStream(InputStream in) {
        super(in);
    }

    private int convertRaw(int raw) throws IOException {
        int mapped = HEXMAP[raw];
        if (mapped < 0) {
            throw new IOException("unsupported hexchar" + raw);
        }
        return mapped;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int hexRawPart1 = super.read();
        if (hexRawPart1 == -1) {
            return -1;
        }
        int hexRawPart2 = super.read();
        if (hexRawPart2 == -1) {
            throw new EOFException("incomplete hex");
        }
        int hexPart1 = this.convertRaw(hexRawPart1);
        int hexPart2 = this.convertRaw(hexRawPart2);
        int ret = hexPart1 * 16 + hexPart2;
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        int index = 0;
        b[off + index++] = (byte)c;
        while (index < len && (c = this.read()) != -1) {
            b[off + index] = (byte)c;
            ++index;
        }
        return index;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    static {
        int index;
        HEXMAP = new int[256];
        for (index = 0; index < HEXMAP.length; ++index) {
            HexInputStream.HEXMAP[index] = -1;
        }
        for (index = 48; index <= 57; ++index) {
            HexInputStream.HEXMAP[index] = -48 + index;
        }
        for (index = 65; index <= 70; ++index) {
            HexInputStream.HEXMAP[index] = -55 + index;
        }
        for (index = 97; index <= 102; ++index) {
            HexInputStream.HEXMAP[index] = -87 + index;
        }
    }
}

