/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;

public class HTTPProxyUtils {
    public static List<InetAddress> getLocalIPs() {
        return HTTPProxyUtils.getLocalIPs(false);
    }

    public static List<InetAddress> getLocalIPs(boolean allowLoopback) {
        LinkedHashSet<InetAddress> ret = new LinkedHashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface == null || !networkInterface.isUp() || networkInterface.isLoopback() && !allowLoopback) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress == null) continue;
                    ret.add(inetAddress);
                }
                Enumeration<NetworkInterface> subNetworkInterfaces = networkInterface.getSubInterfaces();
                while (subNetworkInterfaces.hasMoreElements()) {
                    NetworkInterface subNetworkInterface = subNetworkInterfaces.nextElement();
                    if (subNetworkInterface == null) continue;
                    inetAddresses = subNetworkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (inetAddress == null) continue;
                        ret.add(inetAddress);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return Collections.unmodifiableList(new ArrayList(ret));
    }
}

