/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyConnectException;

public class NetworkInterfaceException
extends ProxyConnectException {
    protected final ERROR error;
    protected final String ifName;

    public ERROR getError() {
        return this.error;
    }

    public String getIfName() {
        return this.ifName;
    }

    public NetworkInterfaceException(ERROR error, String ifName, HTTPProxy proxy) {
        super(proxy);
        this.error = error;
        this.ifName = ifName;
    }

    public NetworkInterfaceException(ERROR error, String ifName, HTTPProxy proxy, Exception e) {
        super(e, proxy);
        this.error = error;
        this.ifName = ifName;
    }

    @Override
    public String getMessage() {
        return NetworkInterfaceException.getErrorMessage(this.getError(), this.getIfName());
    }

    protected static String getErrorMessage(ERROR error, String ifName) {
        switch (error) {
            case INTERFACE_BIND_ERROR: {
                return "network interface '" + ifName + "' bind error!";
            }
            case INTERFACE_NOT_CONNECTED: {
                return "network interface '" + ifName + "' not connected!";
            }
            case INTERFACE_NOT_FOUND: {
                return "network interface '" + ifName + "' not found!";
            }
            case INTERFACE_NOT_SUPPORTED: {
                return "network interface '" + ifName + "' not supported!";
            }
        }
        return "network interface '" + ifName + "':" + error.name();
    }

    public static enum ERROR {
        INTERFACE_BIND_ERROR,
        INTERFACE_NOT_FOUND,
        INTERFACE_NOT_CONNECTED,
        INTERFACE_NOT_SUPPORTED;

    }
}

