/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver;

import java.io.IOException;
import java.net.Socket;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.HttpServer;

public class HttpConnectionThread
extends Thread {
    private HttpConnection currentConnection = null;
    private Socket socket = null;
    private int serverThreadID = 0;

    public HttpConnectionThread(HttpServer server, Runnable r) {
        super(r);
        this.setDaemon(true);
    }

    protected void setName(HttpServer server, Socket socket) {
        if (socket != null) {
            this.setName("HttpConnectionThread:" + this.serverThreadID + ":" + socket.getLocalSocketAddress() + "<-" + socket.getRemoteSocketAddress());
        } else {
            this.setName("HttpConnectionThread:" + this.serverThreadID + ":" + server.getPort() + ":" + server.isLocalhostOnly());
        }
    }

    protected void setServerThreadID(int serverThreadID) {
        this.serverThreadID = serverThreadID;
    }

    public HttpConnection getCurrentConnection() {
        return this.currentConnection;
    }

    public Socket getCurrentSocket() {
        Socket socket = this.socket;
        if (socket != null) {
            return socket;
        }
        HttpConnection connection = this.currentConnection;
        if (connection != null) {
            return connection.getClientSocket();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        try {
            HttpConnection lcurrentConnection = this.getCurrentConnection();
            if (lcurrentConnection != null) {
                lcurrentConnection.closeConnection();
                lcurrentConnection.close();
            } else {
                Socket lSocket = this.getCurrentSocket();
                if (lSocket != null) {
                    try {
                        lSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            super.interrupt();
        }
    }

    public void setCurrentConnection(HttpConnection currentConnection, Socket socket) {
        this.currentConnection = currentConnection;
        this.socket = socket;
    }
}

