/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.requests;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.ChunkedInputStream;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.StreamValidEOF;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.JSonRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;

public class PostRequest
extends HttpRequest {
    protected InputStream inputStream = null;
    protected boolean postParameterParsed = false;
    protected List<KeyValuePair> postParameters = null;

    public PostRequest(RawHttpConnectionInterface connection) {
        super(connection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized InputStream getInputStream() throws IOException {
        InputStream inputStream;
        if (this.inputStream != null) return this.inputStream;
        HTTPHeader transferEncoding = this.getRequestHeaders().get("Transfer-Encoding");
        if (transferEncoding != null) {
            if (!"chunked".equalsIgnoreCase(transferEncoding.getValue())) throw new IOException("Unknown Transfer-Encoding " + transferEncoding.getValue());
            inputStream = new ChunkedInputStream(this.connection.getInputStream());
        } else {
            HTTPHeader contentLength = this.getRequestHeaders().get("Content-Length");
            inputStream = contentLength == null || !contentLength.matches("^\\d+$") ? this.connection.getInputStream() : new LimitedInputStream(this.connection.getInputStream(), Long.parseLong(contentLength.getValue()));
        }
        this.inputStream = new PostRequestInputStream(inputStream);
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public String getParameterbyKey(String key) throws IOException {
        List<KeyValuePair> params = this.getRequestedURLParameters();
        if (params != null) {
            for (KeyValuePair param : params) {
                if (!key.equalsIgnoreCase(param.key)) continue;
                return param.value;
            }
        }
        if ((params = this.getPostParameter()) != null) {
            for (KeyValuePair param : params) {
                if (!key.equalsIgnoreCase(param.key)) continue;
                return param.value;
            }
        }
        return null;
    }

    @Override
    public String[] getParametersbyKey(String key) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        List<KeyValuePair> params = this.getRequestedURLParameters();
        if (params != null) {
            for (KeyValuePair param : params) {
                if (!StringUtils.equalsIgnoreCase(key, param.key)) continue;
                ret.add(param.value);
            }
        }
        if ((params = this.getPostParameter()) != null) {
            for (KeyValuePair param : params) {
                if (!StringUtils.equalsIgnoreCase(key, param.key)) continue;
                ret.add(param.value);
            }
        }
        if (ret.size() > 0) {
            return ret.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<KeyValuePair> getPostParameter() throws IOException {
        if (!this.postParameterParsed) {
            try {
                CONTENT_TYPE content_type = CONTENT_TYPE.UNKNOWN;
                String charSet = null;
                String type = this.getRequestHeaders().getValue("Content-Type");
                if (type != null) {
                    content_type = new Regex(type, "(application/x-www-form-urlencoded)").patternFind() ? CONTENT_TYPE.X_WWW_FORM_URLENCODED : (new Regex(type, "(application/json)").patternFind() ? CONTENT_TYPE.JSON : CONTENT_TYPE.UNKNOWN);
                    charSet = new Regex(type, "charset=(.*?)($| )").getMatch(0);
                    if (charSet == null) {
                        charSet = "UTF-8";
                    }
                }
                this.postParameters = this.readPostParameters(content_type, charSet);
            }
            finally {
                this.postParameterParsed = true;
            }
        }
        return this.postParameters;
    }

    protected List<KeyValuePair> readPostParameters(CONTENT_TYPE content_type, String charSet) throws IOException, UnsupportedEncodingException {
        if (content_type != null) {
            switch (content_type) {
                case JSON: {
                    byte[] jsonBytes = IO.readStream(-1, this.getInputStream());
                    String jsonString = new String(jsonBytes, charSet);
                    jsonString = this.modifyByContentType(content_type, jsonString);
                    JSonRequest jsonRequest = JSonStorage.restoreFromString(jsonString, JSonRequest.TYPE_REF);
                    if (jsonRequest == null || jsonRequest.getParams() == null) {
                        Object rawJSON = JSonStorage.restoreFromString(jsonString, TypeRef.OBJECT);
                        if (rawJSON instanceof List) {
                            jsonRequest = new JSonRequest();
                            jsonRequest.setParams(((List)rawJSON).toArray(new Object[0]));
                        } else if (rawJSON != null) {
                            jsonRequest = new JSonRequest();
                            jsonRequest.setParams(new Object[]{rawJSON});
                        }
                    }
                    if (jsonRequest == null || jsonRequest.getParams() == null) break;
                    LinkedList<KeyValuePair> ret = new LinkedList<KeyValuePair>();
                    for (Object parameter : jsonRequest.getParams()) {
                        if (parameter instanceof JSonObject) {
                            ret.add(new KeyValuePair(null, parameter.toString()));
                            continue;
                        }
                        String jsonParameter = JSonStorage.serializeToJson(parameter);
                        ret.add(new KeyValuePair(null, jsonParameter));
                    }
                    return ret;
                }
                case X_WWW_FORM_URLENCODED: {
                    byte[] formBytes = IO.readStream(-1, this.getInputStream());
                    String formString = new String(formBytes, charSet);
                    formString = this.modifyByContentType(content_type, formString);
                    return HttpConnection.parseParameterList(formString);
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    protected String modifyByContentType(CONTENT_TYPE content_type, String json) throws IOException {
        return json;
    }

    public void setPostParameter(List<KeyValuePair> params) {
        this.postParameterParsed = true;
        this.postParameters = params;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\r\n----------------Request " + this.getId() + "-------------------------\r\n");
            sb.append((Object)((Object)this.getRequestMethod()) + " ").append(this.getRequestedURL()).append(" HTTP/1.1\r\n");
            for (HTTPHeader key : this.getRequestHeaders()) {
                sb.append(key.getKey());
                sb.append(": ");
                sb.append(key.getValue());
                sb.append("\r\n");
            }
            sb.append("\r\n");
            List<KeyValuePair> postParams = this.postParameters;
            if (!this.postParameterParsed) {
                sb.append("Post Parameters unparsed");
            } else if (postParams != null) {
                for (KeyValuePair s : postParams) {
                    sb.append(s.key);
                    sb.append(": ");
                    sb.append(s.value);
                    sb.append("\r\n");
                }
            }
            return sb.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    protected HTTPConnection.RequestMethod getRequestMethod() {
        return HTTPConnection.RequestMethod.POST;
    }

    @Override
    public HttpConnection.HttpConnectionType getHttpConnectionType() {
        return HttpConnection.HttpConnectionType.POST;
    }

    protected class PostRequestInputStream
    extends FilterInputStream
    implements StreamValidEOF {
        protected volatile boolean closed;

        protected PostRequestInputStream(InputStream in) {
            super(in);
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (PostRequest.this.connection.closableStreams()) {
                super.close();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                return -1;
            }
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.closed) {
                return -1;
            }
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                return -1;
            }
            return super.read(b, off, len);
        }

        @Override
        public boolean isValidEOF() {
            if (this.in instanceof StreamValidEOF) {
                return ((StreamValidEOF)((Object)this.in)).isValidEOF();
            }
            return false;
        }
    }

    public static enum CONTENT_TYPE {
        X_WWW_FORM_URLENCODED,
        JSON,
        UNKNOWN;

    }
}

