/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.responses;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.utils.Files;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.HttpRequestInterface;
import org.appwork.utils.net.httpserver.responses.HttpResponseInterface;

public class FileResponse {
    private final HttpRequestInterface request;
    private final HttpResponseInterface response;
    private File inputFile;
    private URL inputURL;
    private static HashMap<String, String> MIMES = new HashMap();

    public static String getMimeType(String name) {
        String extension = Files.getExtension(name);
        String mime = MIMES.get(extension.toLowerCase(Locale.ENGLISH));
        if (mime == null) {
            mime = "application/octet-stream";
        }
        return mime;
    }

    public FileResponse(HttpRequestInterface request, HttpResponseInterface response, File inputFile) {
        this.request = request;
        this.response = response;
        this.inputFile = inputFile;
    }

    public FileResponse(HttpRequestInterface request, HttpResponseInterface response, URL inputURL) {
        this.request = request;
        this.response = response;
        this.inputURL = inputURL;
    }

    protected boolean allowGZIP() {
        String value;
        HTTPHeader acceptEncoding = this.request.getRequestHeaders().get("Accept-Encoding");
        return acceptEncoding != null && (value = acceptEncoding.getValue()) != null && value.contains("gzip");
    }

    protected boolean allowRanges() {
        if (this.inputURL != null) {
            return false;
        }
        return false;
    }

    protected long getContentLength(long knownLength) {
        boolean allowRanges = this.allowRanges();
        if (this.inputURL != null) {
            if (knownLength >= 0L) {
                return knownLength;
            }
            return -1L;
        }
        if (!allowRanges) {
            return this.inputFile.length();
        }
        return -1L;
    }

    protected String getFileName() {
        String name = null;
        name = this.inputFile != null ? this.inputFile.getName() : this.inputURL.getFile();
        return name;
    }

    protected String getMimeType() {
        return FileResponse.getMimeType(this.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile() throws IOException {
        InputStream is = null;
        URLConnection con = null;
        GZIPOutputStream gos = null;
        OutputStream os = null;
        Object ros = null;
        boolean chunked = false;
        boolean gzip = false;
        long knownLength = -1L;
        try {
            long length;
            if (this.inputURL != null) {
                con = this.inputURL.openConnection();
                knownLength = con.getContentLengthLong();
                is = con.getInputStream();
            } else if (this.inputFile != null) {
                is = new FileInputStream(this.inputFile);
                knownLength = this.inputFile.length();
            }
            this.response.setResponseCode(HTTPConstants.ResponseCode.SUCCESS_OK);
            if (this.allowRanges()) {
                this.response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "bytes"));
            }
            if (this.allowGZIP() && !this.useContentDisposition()) {
                gzip = true;
                this.response.getResponseHeaders().add(new HTTPHeader("Content-Encoding", "gzip"));
            }
            if ((length = this.getContentLength(knownLength)) >= 0L && !gzip) {
                this.response.getResponseHeaders().add(new HTTPHeader("Content-Length", length + ""));
            } else {
                chunked = true;
                this.response.getResponseHeaders().add(new HTTPHeader("Transfer-Encoding", "chunked"));
            }
            this.response.getResponseHeaders().add(new HTTPHeader("Content-Type", this.getMimeType()));
            if (this.useContentDisposition()) {
                this.response.getResponseHeaders().add(new HTTPHeader("Content-Disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(this.getFileName(), "UTF-8")));
            }
            if (gzip) {
                if (chunked) {
                    gos = new GZIPOutputStream(new ChunkedOutputStream(this.response.getOutputStream(true)));
                    os = gos;
                } else {
                    gos = new GZIPOutputStream(this.response.getOutputStream(true));
                    os = gos;
                }
            } else {
                os = chunked ? new ChunkedOutputStream(this.response.getOutputStream(true)) : this.response.getOutputStream(true);
            }
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = is.read(buffer)) >= 0) {
                if (read > 0) {
                    os.write(buffer, 0, read);
                    continue;
                }
                Thread.yield();
            }
        }
        finally {
            try {
                gos.finish();
            }
            catch (Throwable throwable) {}
            try {
                gos.close();
            }
            catch (Throwable throwable) {}
            try {
                os.close();
            }
            catch (Throwable throwable) {}
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected boolean useContentDisposition() {
        return this.inputURL == null;
    }

    static {
        MIMES.put("html", "text/html");
        MIMES.put("htm", "text/html");
        MIMES.put("txt", "text/plain");
        MIMES.put("gif", "image/gif");
        MIMES.put("css", "text/css");
        MIMES.put("js", "text/javascript");
        MIMES.put("png", "image/png");
        MIMES.put("jpeg", "image/jpeg");
        MIMES.put("jpg", "image/jpeg");
        MIMES.put("jpe", "image/jpeg");
        MIMES.put("ico", "image/x-icon");
    }
}

