/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.meteredconnection;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredOutputStream
extends OutputStream
implements SpeedMeterInterface {
    private final OutputStream out;
    private final SpeedMeterInterface speedmeter;
    private volatile long transfered = 0L;
    public static final int LOWStep = 1024;
    private long transfered2 = 0L;
    private long time = 0L;
    private long speed = 0L;
    private int checkStep = 1024;

    @Deprecated
    public MeteredOutputStream(OutputStream out) {
        this(out, null);
    }

    public MeteredOutputStream(OutputStream out, SpeedMeterInterface speedmeter) {
        this.out = out;
        this.speedmeter = speedmeter;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public int getCheckStepSize() {
        return this.checkStep;
    }

    @Override
    public synchronized long getValue(SpeedMeterInterface.Resolution resolution) {
        long now = this.getTime();
        long trans = this.transfered;
        if (this.time == 0L) {
            this.time = now;
            this.transfered2 = trans;
            return 0L;
        }
        long last = now - this.time;
        if (last < resolution.factor) {
            if (this.speedmeter != null) {
                return this.speedmeter.getValue(resolution);
            }
            return this.speed;
        }
        this.time = now;
        long diff = trans - this.transfered2;
        this.transfered2 = trans;
        if (this.speedmeter != null) {
            this.speedmeter.putBytes(diff, last);
            this.speed = this.speedmeter.getValue(resolution);
            return this.speed;
        }
        SpeedMeterInterface.Resolution internal = this.getResolution();
        this.speed = diff / last * internal.factor;
        return this.speed;
    }

    @Override
    public void putBytes(long bytes, long time) {
    }

    @Override
    public synchronized void resetSpeedmeter() {
        if (this.speedmeter != null) {
            this.speedmeter.resetSpeedmeter();
        }
        this.speed = 0L;
        this.transfered2 = this.transfered;
        this.time = this.getTime();
    }

    public void setCheckStepSize(int step) {
        this.checkStep = Math.max(1024, step);
    }

    protected long getTime() {
        return this.getResolution().getTime();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int offset = off;
        int rest = len;
        SpeedMeterInterface.Resolution resolution = this.getResolution();
        long maxWriteTime = resolution.factor / 5L;
        int maxWrite = this.checkStep;
        while (rest != 0) {
            boolean limitedStep;
            int toWrite = rest;
            if (toWrite > maxWrite) {
                limitedStep = true;
                toWrite = maxWrite;
            } else {
                limitedStep = false;
            }
            long timeForCheckStep = this.getTime();
            this.out.write(b, offset, toWrite);
            long timeCheck = this.getTime() - timeForCheckStep;
            if (timeCheck == 0L) {
                if (limitedStep && toWrite == maxWrite) {
                    long nextWrite = maxWrite + 1024;
                    this.checkStep = maxWrite = Math.max(1024, (int)Math.min(Integer.MAX_VALUE, nextWrite));
                }
            } else if (timeCheck > maxWriteTime) {
                long nextCheckStep = (long)toWrite / timeCheck * maxWriteTime;
                this.checkStep = maxWrite = Math.max(1024, (int)nextCheckStep);
            }
            this.transfered += (long)toWrite;
            rest -= toWrite;
            offset += toWrite;
        }
    }

    @Override
    public SpeedMeterInterface.Resolution getResolution() {
        if (this.speedmeter != null) {
            return this.speedmeter.getResolution();
        }
        return SpeedMeterInterface.Resolution.MILLI_SECONDS;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.transfered;
    }
}

