/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.socketconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.ProxyEndpointConnectException;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.socketconnection.SocketConnection;

public class HTTPProxySocketConnection
extends SocketConnection {
    private static SSLSocketStreamFactory defaultSSLSocketStreamFactory = null;
    protected boolean sslTrustALL = true;

    public static void setDefaultSSLSocketStreamFactory(SSLSocketStreamFactory defaultSSLSocketStreamFactory) {
        HTTPProxySocketConnection.defaultSSLSocketStreamFactory = defaultSSLSocketStreamFactory;
    }

    public void setSSLTrustALL(boolean trustALL) {
        this.sslTrustALL = trustALL;
    }

    public boolean isSSLTrustALL() {
        return this.sslTrustALL;
    }

    public HTTPProxySocketConnection(HTTPProxy proxy) {
        super(proxy);
    }

    @Override
    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null) {
            switch (proxy.getType()) {
                case HTTP: 
                case HTTPS: {
                    return proxy;
                }
            }
            throw new IllegalArgumentException("proxy must be of type http(s):" + proxy);
        }
        throw new IllegalArgumentException("proxy must be of type http(s):" + proxy);
    }

    protected SSLSocketStreamFactory getSSLSocketStreamFactory() {
        SSLSocketStreamFactory sslSocketStreamFactory = defaultSSLSocketStreamFactory;
        if (sslSocketStreamFactory != null) {
            return sslSocketStreamFactory;
        }
        return JavaSSLSocketStreamFactory.getInstance();
    }

    protected String getConnectHostname(InetSocketAddress endPointAddress) {
        return SocketConnection.getHostName(endPointAddress);
    }

    @Override
    protected SocketStreamInterface connectProxySocket(SocketStreamInterface proxySocket, SocketAddress endPoint, StringBuffer logger) throws IOException {
        HTTPProxy proxy = this.getProxy();
        if (HTTPProxy.TYPE.HTTPS.equals(proxy.getType())) {
            try {
                SSLSocketStreamFactory factory = this.getSSLSocketStreamFactory();
                String id = proxy.getHost() + ":" + proxy.getPort() + ":" + this.isSSLTrustALL();
                proxySocket = factory.create(proxySocket, "", proxy.getPort(), true, new SSLSocketStreamOptions(id, this.isSSLTrustALL()));
            }
            catch (IOException e) {
                throw new ProxyConnectException(e, proxy);
            }
        }
        InetSocketAddress endPointAddress = (InetSocketAddress)endPoint;
        OutputStream os = proxySocket.getOutputStream();
        StringBuilder connectRequest = new StringBuilder();
        connectRequest.append("CONNECT ");
        connectRequest.append(this.getConnectHostname(endPointAddress) + ":" + endPointAddress.getPort());
        connectRequest.append(" HTTP/1.1\r\n");
        if (StringUtils.isNotEmpty(proxy.getUser()) || StringUtils.isNotEmpty(proxy.getPass())) {
            String user = StringUtils.valueOrEmpty(proxy.getUser());
            String pass = StringUtils.valueOrEmpty(proxy.getPass());
            String basicAuth = "Basic " + new String(Base64.encodeToByte((user + ":" + pass).getBytes(), false));
            connectRequest.append("Proxy-Authorization: " + basicAuth + "\r\n");
        }
        connectRequest.append("Proxy-Connection: close\r\n");
        connectRequest.append("\r\n");
        os.write(connectRequest.toString().getBytes("ISO-8859-1"));
        os.flush();
        InputStream is = proxySocket.getInputStream();
        ByteBuffer headerByteBuffer = HTTPConnectionUtils.readheader(is, true);
        byte[] headerBytes = new byte[headerByteBuffer.limit()];
        headerByteBuffer.get(headerBytes);
        String proxyResponseStatus = new String(headerBytes, "ISO-8859-1").trim();
        String responseCodeString = new Regex(proxyResponseStatus, "HTTP.*? (\\d+)").getMatch(0);
        int responseCode = responseCodeString != null ? Integer.parseInt(responseCodeString) : -1;
        switch (responseCode) {
            case 200: {
                break;
            }
            case 403: {
                throw new ProxyEndpointConnectException("403 Connection refused", proxy, endPoint);
            }
            case 407: {
                throw new ProxyAuthException(proxy);
            }
            case 504: {
                throw new ProxyEndpointConnectException("504 Gateway timeout", proxy, endPoint);
            }
            default: {
                throw new ProxyConnectException("Invalid responseCode " + responseCode, proxy);
            }
        }
        while (HTTPConnectionUtils.readheader(is, true).limit() > 2) {
        }
        return proxySocket;
    }
}

