/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.appwork.utils.Exceptions;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;

public class ThrottledInputStream
extends InputStream
implements ThrottledConnection {
    private ThrottledConnectionHandler handler;
    private InputStream in;
    protected volatile long transferedCounter = 0L;
    protected volatile long transferedCounter2 = 0L;
    private volatile int limitCurrent = 0;
    private int limitCounter = 0;
    private int lastRead2;
    private long slotTimeLeft = 0L;
    private long lastTimeReset = 0L;
    private final long onems = 1000000L;
    private final long onesec = 1000000000L;

    public ThrottledInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            this.handler.removeThrottledConnection(this);
            this.handler = null;
        }
        ThrottledInputStream throttledInputStream = this;
        synchronized (throttledInputStream) {
            this.notify();
        }
        this.in.close();
    }

    @Override
    public ThrottledConnectionHandler getHandler() {
        return this.handler;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public int getLimit() {
        return this.limitCurrent;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.lastRead2 = this.in.read();
        if (this.lastRead2 == -1) {
            return -1;
        }
        ++this.transferedCounter;
        if (this.limitCurrent != 0) {
            --this.limitCounter;
            this.readWait(1);
        }
        return this.lastRead2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limitCurrent == 0) {
            this.lastRead2 = this.in.read(b, off, len);
            if (this.lastRead2 == -1) {
                return -1;
            }
            this.transferedCounter += (long)this.lastRead2;
        } else {
            this.readWait(len);
            this.lastRead2 = this.in.read(b, off, Math.min(this.limitCounter, len));
            if (this.lastRead2 == -1) {
                return -1;
            }
            this.transferedCounter += (long)this.lastRead2;
            this.limitCounter -= this.lastRead2;
        }
        return this.lastRead2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readWait(int len) throws IOException {
        long current = System.nanoTime();
        this.slotTimeLeft = Math.max(0L, current - this.lastTimeReset);
        if (this.limitCounter <= 0 && this.slotTimeLeft < this.onesec) {
            ThrottledInputStream throttledInputStream = this;
            synchronized (throttledInputStream) {
                try {
                    long wait = this.onesec - this.slotTimeLeft;
                    this.lastTimeReset = current + wait;
                    long ns = wait % this.onems;
                    this.wait(wait /= this.onems, (int)ns);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Exceptions.initCause(new InterruptedIOException("throttle interrupted"), e);
                }
            }
            this.limitCounter = this.limitCurrent;
            if (this.limitCounter <= 0) {
                this.limitCounter = len;
            }
        } else if (this.slotTimeLeft >= this.onesec) {
            this.limitCounter = this.limitCurrent;
            this.lastTimeReset = current;
            if (this.limitCounter <= 0) {
                this.limitCounter = len;
            }
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public void setHandler(ThrottledConnectionHandler manager) {
        if (this.handler != null && this.handler != manager) {
            this.handler.removeThrottledConnection(this);
        }
        this.handler = manager;
        if (this.handler != null) {
            this.handler.addThrottledConnection(this);
        }
    }

    public void setInputStream(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        if (is == this) {
            throw new IllegalArgumentException("InputStream loop!");
        }
        this.in = is;
    }

    @Override
    public void setLimit(int kpsLimit) {
        if (kpsLimit == this.limitCurrent) {
            return;
        }
        this.limitCurrent = Math.max(0, kpsLimit);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public long transfered() {
        return this.transferedCounter;
    }
}

