/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.usenet;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.net.usenet.AuthRequiredException;
import org.appwork.utils.net.usenet.BodyInputStream;
import org.appwork.utils.net.usenet.InvalidAuthException;
import org.appwork.utils.net.usenet.MessageBodyNotFoundException;
import org.appwork.utils.net.usenet.ServerErrorResponseException;
import org.appwork.utils.net.usenet.UUInputStream;
import org.appwork.utils.net.usenet.UnexpectedResponseException;
import org.appwork.utils.net.usenet.UnknownResponseException;
import org.appwork.utils.net.usenet.UnrecognizedCommandException;
import org.appwork.utils.net.usenet.YEncInputStream;

public abstract class SimpleUseNet {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private volatile Socket socket = null;
    private volatile OutputStream outputStream = null;
    private volatile InputStream inputStream = null;
    private final byte[] CRLF = "\r\n".getBytes();
    private final LogInterface logger;
    private final HTTPProxy proxy;
    private final ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(){

        @Override
        public synchronized byte[] toByteArray() {
            return this.buf;
        }
    };

    public Socket getSocket() {
        return this.socket;
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public SimpleUseNet(HTTPProxy proxy, LogInterface logger) {
        this.proxy = proxy;
        this.logger = logger != null ? logger : LogV3.I().getDefaultLogger();
    }

    protected abstract Socket createSocket();

    public synchronized void connect(String server, int port, boolean ssl, String username, String password) throws IOException {
        this.connect(new InetSocketAddress(server, port), ssl, username, password);
    }

    protected SSLSocketFactory getSSLSocketFactory(String sniHostName) throws IOException {
        return JavaSSLSocketStreamFactory.getInstance().getSSLSocketFactory(null, sniHostName);
    }

    protected boolean useSNIWorkaround() {
        return false;
    }

    public Charset getCharSet() {
        return UTF8;
    }

    public synchronized void connect(SocketAddress socketAddress, boolean ssl, String username, String password) throws IOException {
        try {
            if (!ssl) {
                this.socket = this.createSocket();
                this.socket.setSoTimeout(this.getReadTimeout());
                this.socket.connect(socketAddress, this.getConnectTimeout());
            } else {
                boolean useSNIWorkaround = this.useSNIWorkaround();
                while (true) {
                    this.socket = this.createSocket();
                    this.socket.setSoTimeout(this.getReadTimeout());
                    this.socket.connect(socketAddress, this.getConnectTimeout());
                    try {
                        SSLSocket sslSocket;
                        if (useSNIWorkaround) {
                            SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory(null);
                            sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, "", this.socket.getPort(), true);
                        } else {
                            String hostName = SocketConnection.getHostName(socketAddress);
                            if (hostName != null) {
                                SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory(hostName);
                                sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, hostName, this.socket.getPort(), true);
                            } else {
                                throw new IOException("no hostname for ssl available");
                            }
                        }
                        sslSocket.startHandshake();
                        this.socket = sslSocket;
                    }
                    catch (IOException e) {
                        this.silentDisconnect(e);
                        if (!useSNIWorkaround && e.getMessage().contains("unrecognized_name")) {
                            useSNIWorkaround = true;
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
            CommandResponse response = this.readCommandResponse(null);
            switch (response.getResponseCode()) {
                case 200: 
                case 201: {
                    break;
                }
                case 400: {
                    throw new ServerErrorResponseException(response);
                }
                case 500: {
                    throw new ServerErrorResponseException(response);
                }
                default: {
                    throw new UnknownResponseException(response);
                }
            }
            if (username != null || password != null) {
                this.authenticate(username, password);
            }
        }
        catch (IOException e) {
            this.silentDisconnect(e);
            throw e;
        }
    }

    private void checkInvalidAuth(CommandResponse response) throws InvalidAuthException {
        String message = response.getMessage();
        int code = response.getResponseCode();
        switch (code) {
            case 481: {
                throw new InvalidAuthException(code + "|" + message);
            }
            case 482: {
                if (StringUtils.containsIgnoreCase(message, "incorrect")) {
                    throw new InvalidAuthException(code + "|" + message);
                }
                if (StringUtils.containsIgnoreCase(message, "expired")) {
                    throw new InvalidAuthException(code + "|" + message);
                }
                if (!StringUtils.containsIgnoreCase(message, "suspended")) break;
                throw new InvalidAuthException(code + "|" + message);
            }
            case 502: {
                if (!StringUtils.containsIgnoreCase(message, "Authentication Failed") && !StringUtils.containsIgnoreCase(message, "Authentication details unknown") && !StringUtils.containsIgnoreCase(message, "Please check your login") && !StringUtils.contains(message, "Access Denied")) break;
                throw new InvalidAuthException(code + "|" + message);
            }
        }
    }

    private void authenticate(String username, String password) throws IOException {
        String user = username != null ? username : "";
        CommandResponse response = this.sendCmd(COMMAND.AUTHINFO_USER, user);
        switch (response.getResponseCode()) {
            case 281: {
                return;
            }
            case 381: {
                String pass = password != null ? password : "";
                response = this.sendCmd(COMMAND.AUTHINFO_PASS, pass);
                switch (response.getResponseCode()) {
                    case 281: {
                        return;
                    }
                }
                this.checkInvalidAuth(response);
                break;
            }
            default: {
                this.checkInvalidAuth(response);
            }
        }
        throw new UnknownResponseException(response);
    }

    protected synchronized String readLine() throws IOException {
        return this.readLine(this.lineBuffer);
    }

    protected synchronized String readLine(ByteArrayOutputStream buffer) throws IOException {
        try {
            buffer.reset();
            int length = this.readLine(this.getInputStream(), buffer);
            if (length == -1) {
                throw new EOFException();
            }
            String ret = new String(buffer.toByteArray(), 0, length, this.getCharSet());
            this.logger.info("Read Response:" + ret);
            return ret;
        }
        catch (IOException e) {
            this.silentDisconnect(e);
            throw e;
        }
    }

    protected int readLine(InputStream inputStream, OutputStream buffer) throws IOException {
        try {
            int c = 0;
            int length = 0;
            boolean CR = false;
            while (true) {
                if ((c = inputStream.read()) == -1) {
                    if (length > 0) {
                        return length;
                    }
                    return -1;
                }
                if (c == 13) {
                    if (CR) {
                        throw new IOException("CRCR!?");
                    }
                    CR = true;
                    continue;
                }
                if (c == 10) {
                    if (CR) break;
                    throw new IOException("LF!?");
                }
                if (CR) {
                    throw new IOException("CRXX!?");
                }
                buffer.write(c);
                ++length;
            }
            return length;
        }
        catch (IOException e) {
            this.silentDisconnect(e);
            throw e;
        }
    }

    private synchronized CommandResponse readCommandResponse(COMMAND command) throws IOException {
        String line = this.readLine();
        int code = Integer.parseInt(line.substring(0, 3));
        if (command != null && command.isMultiLineResponse(code)) {
            StringBuilder sb = new StringBuilder();
            sb.append(line);
            while (!".".equals(line = this.readLine())) {
                sb.append("\r\n");
                sb.append(line);
            }
            return new CommandResponse(code, sb.toString());
        }
        return new CommandResponse(code, line.substring(3));
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected String wrapMessageID(String messageID) {
        String ret = messageID.trim();
        if (!ret.startsWith("<")) {
            ret = "<".concat(ret);
        }
        if (!ret.endsWith(">")) {
            ret = ret.concat(">");
        }
        return ret;
    }

    public synchronized boolean isMessageExisting(String messageID) throws IOException {
        CommandResponse response = this.sendCmd(COMMAND.STAT, this.wrapMessageID(messageID));
        switch (response.getResponseCode()) {
            case 223: {
                return true;
            }
            case 430: {
                return false;
            }
        }
        throw new UnknownResponseException(response);
    }

    public synchronized InputStream requestMessageBodyAsInputStream(String messageID) throws IOException {
        return this.requestMessageBodyAsInputStream(messageID, true);
    }

    public synchronized InputStream requestMessageBodyAsInputStream(String messageID, boolean autoDecode) throws IOException {
        CommandResponse response = this.sendCmd(COMMAND.BODY, this.wrapMessageID(messageID));
        switch (response.getResponseCode()) {
            case 220: {
                break;
            }
            case 222: {
                break;
            }
            case 430: {
                throw new MessageBodyNotFoundException(messageID);
            }
            default: {
                throw new UnknownResponseException(response);
            }
        }
        if (!autoDecode) {
            return new BodyInputStream(this);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(0x100000){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        while (true) {
            buffer.reset();
            int lineLength = this.readLine(this.getInputStream(), buffer);
            if (lineLength > 0) {
                String line = new String(buffer.toByteArray(), 0, lineLength, this.getCharSet());
                this.logger.info("Read Response:" + line);
                if (line.startsWith("=ybegin")) {
                    this.logger.info("yEnc Body detected");
                    return this.newYEncInputStream(this, messageID, buffer);
                }
                if (!line.matches("^begin \\d{3} .+")) continue;
                this.logger.info("uuEncode Body detected");
                return new UUInputStream(this, buffer);
            }
            if (lineLength == -1) break;
        }
        throw new IOException("Unknown Body Format");
    }

    protected YEncInputStream newYEncInputStream(SimpleUseNet simpleUseNet, String messageID, ByteArrayOutputStream buffer) throws IOException {
        return new YEncInputStream(simpleUseNet, messageID, buffer);
    }

    private synchronized void sendCommand(String request) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("not connected");
        }
        try {
            this.logger.info("Send Command:" + request);
            this.outputStream.write(request.getBytes(this.getCharSet()));
            this.outputStream.write(this.CRLF);
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.silentDisconnect(e);
            throw e;
        }
    }

    public int getReadTimeout() {
        return 30000;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    public CommandResponse sendCmd(COMMAND command) throws IOException {
        return this.sendCmd(command, null);
    }

    public synchronized CommandResponse sendCmd(COMMAND command, String parameter) throws IOException {
        if (parameter != null) {
            this.sendCommand(command.getCommand() + " " + parameter);
        } else {
            this.sendCommand(command.getCommand());
        }
        CommandResponse response = this.readCommandResponse(command);
        switch (response.getResponseCode()) {
            case 400: {
                throw new UnrecognizedCommandException(command, parameter);
            }
            case 480: {
                throw new AuthRequiredException();
            }
        }
        return response;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void quit() throws IOException {
        try {
            CommandResponse response = this.sendCmd(COMMAND.QUIT, null);
            if (response.getResponseCode() != 205) {
                throw new UnexpectedResponseException(response);
            }
        }
        finally {
            this.disconnect();
        }
    }

    public void disconnect() throws IOException {
        Socket socket = this.socket;
        this.socket = null;
        if (socket != null) {
            socket.close();
        }
    }

    private void silentDisconnect(Exception e) {
        block2: {
            try {
                this.disconnect();
            }
            catch (IOException ignore) {
                if (e == null) break block2;
                e.addSuppressed(ignore);
            }
        }
    }

    public static class CommandResponse {
        private final int responseCode;
        private final String message;

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getMessage() {
            return this.message;
        }

        private CommandResponse(int responseCode, String message) {
            this.responseCode = responseCode;
            this.message = message;
        }

        public String toString() {
            return this.getResponseCode() + ":" + this.getMessage();
        }
    }

    public static enum COMMAND {
        HEAD{

            @Override
            public boolean isMultiLineResponse(int code) {
                return code == 221;
            }
        }
        ,
        AUTHINFO_USER{

            @Override
            public String getCommand() {
                return "AUTHINFO USER";
            }
        }
        ,
        AUTHINFO_PASS{

            @Override
            public String getCommand() {
                return "AUTHINFO PASS";
            }
        }
        ,
        DATE,
        BODY,
        HELP{

            @Override
            public boolean isMultiLineResponse(int code) {
                return code == 100;
            }
        }
        ,
        STAT,
        QUIT;


        public boolean isMultiLineResponse(int code) {
            return false;
        }

        public String getCommand() {
            return this.name();
        }
    }
}

