/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import org.appwork.JNAHelper;
import org.appwork.builddecision.BuildDecisions;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem17;
import org.appwork.utils.os.DesktopSupport;
import org.appwork.utils.os.DesktopSupportJavaDesktop;
import org.appwork.utils.os.DesktopSupportLinux;
import org.appwork.utils.os.DesktopSupportMac;
import org.appwork.utils.os.DesktopSupportWindows;
import org.appwork.utils.os.DesktopSupportWindowsViaJNA;
import org.appwork.utils.os.Flatpak;
import org.appwork.utils.os.mime.Mime;
import org.appwork.utils.os.mime.MimeFactory;
import org.appwork.utils.processes.ProcessBuilderFactory;

public class CrossSystem {
    private static final EnumSet<OperatingSystem> OperatingSystems = EnumSet.allOf(OperatingSystem.class);
    private static volatile String[] BROWSER_COMMANDLINE = null;
    private static final AtomicReference<DesktopSupport> DESKTOP_SUPPORT = new AtomicReference();
    private static String[] FILE_COMMANDLINE = null;
    private static String JAVAINT = null;
    private static final AtomicReference<Mime> MIME = new AtomicReference();
    public static final OperatingSystem OS;
    public static final ARCHFamily ARCH;
    private static final String OS_STRING;
    private static final String ARCH_STRING;
    private static Boolean OS64BIT;
    public static String NEWLINE;

    public static boolean isUnix() {
        return CrossSystem.isBSD() || CrossSystem.isLinux();
    }

    public static void setDesktopSupportInstance(DesktopSupport desktopSupport) {
        if (desktopSupport == null) {
            throw new IllegalArgumentException();
        }
        DESKTOP_SUPPORT.set(desktopSupport);
    }

    public static String getDefaultDownloadDirectory() {
        try {
            String defaultDownloadDirectory = CrossSystem.getDesktopSupport().getDefaultDownloadDirectory();
            if (StringUtils.isNotEmpty(defaultDownloadDirectory)) {
                return defaultDownloadDirectory;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String userHome = System.getProperty("user.home");
        if (userHome != null && new File(userHome).isDirectory()) {
            return new File(userHome, "Downloads").getAbsolutePath();
        }
        return Application.getResource("Downloads").getAbsolutePath();
    }

    private static void _openFILE(File file) throws IOException {
        try {
            if (CrossSystem.openCustom(FILE_COMMANDLINE, file.getAbsolutePath())) {
                return;
            }
            if (CrossSystem.isOpenFileSupported()) {
                CrossSystem.getDesktopSupport().openFile(file);
            }
        }
        catch (IOException e) {
            if (CrossSystem.isOpenFileSupported()) {
                CrossSystem.getDesktopSupport().openFile(file);
            }
            throw e;
        }
    }

    public static void openUrlOrThrowException(String _url) throws IOException, URISyntaxException {
        try {
            if (CrossSystem.openCustom(BROWSER_COMMANDLINE, _url)) {
                return;
            }
            if (!CrossSystem.isOpenBrowserSupported()) {
                throw new IOException("Unsupported OpenBrowser:" + _url);
            }
            CrossSystem.getDesktopSupport().browseURL(new URL(_url));
        }
        catch (IOException e) {
            if (CrossSystem.isOpenBrowserSupported()) {
                CrossSystem.getDesktopSupport().browseURL(new URL(_url));
            }
            throw e;
        }
    }

    public static String alleviatePathParts(String pathPart) {
        return CrossSystem.alleviatePathParts(pathPart, true);
    }

    public static String alleviatePathParts(String pathPart, boolean removeLeadingHidingDot) {
        if (StringUtils.isEmpty(pathPart)) {
            if (pathPart != null) {
                return pathPart;
            }
            return null;
        }
        pathPart = pathPart.trim();
        pathPart = pathPart.replaceAll("([\\\\|<|>|\\||\r|\n|\t|\"|:|\\*|\\?|/|\\x00-\\x1f])+", "_");
        if ((CrossSystem.isWindows() || CrossSystem.isOS2()) && CrossSystem.isForbiddenFilename(pathPart)) {
            pathPart = "_" + pathPart;
        }
        pathPart = removeLeadingHidingDot ? pathPart.replaceFirst("^\\.+", "") : pathPart.replaceFirst("^\\.+", ".");
        pathPart = pathPart.replaceFirst("\\.+$", "");
        if (StringUtils.isEmpty(pathPart = pathPart.trim())) {
            return "_";
        }
        return pathPart;
    }

    public static boolean isForbiddenFilename(String name) {
        if (CrossSystem.isWindows() || CrossSystem.isOS2()) {
            return new Regex(name, "^(CON|PRN|AUX|NUL|COM\\d+|LPT\\d+|CLOCK)\\s*?(\\.|$)").matches();
        }
        return false;
    }

    public static String fixPathSeparators(String path) {
        if (StringUtils.isEmpty(path)) {
            if (path != null) {
                return path;
            }
            return null;
        }
        if (CrossSystem.isWindows()) {
            boolean network = path.startsWith("\\\\");
            path = path.replaceAll("(/+)", "\\\\");
            path = path.replaceAll("(\\\\+)", "\\\\");
            if (network) {
                path = "\\" + path;
            }
        } else {
            path = path.replaceAll("(\\\\+)", "/");
            path = path.replaceAll("(/+)", "/");
        }
        return path;
    }

    public static String[] getBrowserCommandLine() {
        return BROWSER_COMMANDLINE;
    }

    public static KeyStroke getDeleteShortcut() {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        if (CrossSystem.isMac()) {
            return KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        return KeyStroke.getKeyStroke(127, 0);
    }

    public static String[] getFileCommandLine() {
        return FILE_COMMANDLINE;
    }

    public static String getJavaBinary() {
        String javaHome;
        if (JAVAINT != null) {
            return JAVAINT;
        }
        String javaBinary = "java";
        if (CrossSystem.isWindows() || CrossSystem.isOS2()) {
            javaBinary = "javaw.exe";
        }
        if ((javaHome = System.getProperty("java.home")) != null) {
            File java = new File(new File(javaHome), "/bin/" + javaBinary);
            if (java.exists() && java.isFile()) {
                JAVAINT = java.getAbsolutePath();
            }
        } else {
            JAVAINT = javaBinary;
        }
        return JAVAINT;
    }

    private static long parseMacOSVersion(String osVersionProperty) {
        if (osVersionProperty != null) {
            try {
                long ret = 0L;
                long faktor = 1000000L;
                for (String s : osVersionProperty.trim().split("\\.")) {
                    ret += (long)Integer.parseInt(s) * faktor;
                    faktor /= 1000L;
                }
                return ret;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Deprecated
    public static boolean caseSensitiveFileExists(File file) {
        if (file != null) {
            if (JVMVersion.isMinimum(JVMVersion.JAVA_1_7)) {
                try {
                    return CrossSystem17.caseSensitiveFileExists(file);
                }
                catch (Throwable e) {
                    LogV3.defaultLogger().log(e);
                }
            }
            if (file.exists()) {
                File current = file;
                String currentName = current.getName();
                block2: while ((current = current.getParentFile()) != null) {
                    String[] list = current.list();
                    if (list != null) {
                        for (String listItem : list) {
                            if (!currentName.equals(listItem)) continue;
                            currentName = current.getName();
                            continue block2;
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mime getMime() {
        Mime ret = MIME.get();
        if (ret != null) {
            return ret;
        }
        AtomicReference<Mime> atomicReference = MIME;
        synchronized (atomicReference) {
            ret = MIME.get();
            if (ret == null) {
                ret = MimeFactory.getInstance();
                CrossSystem.setMime(ret);
            }
        }
        return ret;
    }

    public static Mime setMime(Mime mime) {
        if (mime == null) {
            throw new IllegalArgumentException();
        }
        return MIME.getAndSet(mime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DesktopSupport getDesktopSupport() {
        DesktopSupport ret = DESKTOP_SUPPORT.get();
        if (ret != null) {
            return ret;
        }
        AtomicReference<DesktopSupport> atomicReference = DESKTOP_SUPPORT;
        synchronized (atomicReference) {
            ret = DESKTOP_SUPPORT.get();
            if (ret == null) {
                switch (CrossSystem.getOSFamily()) {
                    case WINDOWS: {
                        try {
                            if (JNAHelper.isJNAAvailable() && !BuildDecisions.contains("DesktopSupportWindowsViaJNA.no")) {
                                ret = new DesktopSupportWindowsViaJNA();
                                break;
                            }
                            ret = new DesktopSupportWindows();
                        }
                        catch (Exception e) {
                            DebugMode.debugger(e);
                            ret = new DesktopSupportWindows();
                        }
                        break;
                    }
                    case LINUX: {
                        ret = new DesktopSupportLinux();
                        break;
                    }
                    case MAC: {
                        ret = new DesktopSupportMac();
                        break;
                    }
                    default: {
                        ret = new DesktopSupportJavaDesktop();
                    }
                }
                CrossSystem.setDesktopSupportInstance(ret);
            }
        }
        return ret;
    }

    public static OperatingSystem getOS() {
        return OS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OperatingSystem getWindowsReleaseCMD(final String osName) {
        final Object initialValue = new Object();
        final AtomicReference<Object> reference = new AtomicReference<Object>(initialValue);
        Thread thread = new Thread("getWindowsReleaseCMD: cmd -c ver"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void set(OperatingSystem operatingSystem) {
                AtomicReference atomicReference = reference;
                synchronized (atomicReference) {
                    reference.compareAndSet(initialValue, operatingSystem);
                    reference.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Process process = null;
                try {
                    boolean isServer;
                    process = new ProcessBuilder("cmd", "/c", "ver").start();
                    String buildNumberString = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        do {
                            String line;
                            if ((line = reader.readLine()) == null) {
                                break;
                            }
                            buildNumberString = new Regex(line, "Microsoft\\s*Windows\\s*\\[Versi(?:\u00f3|o)n\\s*\\d+\\.\\d+\\.(\\d+)").getMatch(0);
                            if (buildNumberString != null) continue;
                            buildNumberString = new Regex(line, "\\d+\\.\\d+\\.(\\d+)").getMatch(0);
                        } while (buildNumberString == null);
                    }
                    finally {
                        process.destroy();
                        process = null;
                    }
                    int buildNumber = Integer.parseInt(buildNumberString);
                    boolean bl = isServer = osName != null && osName.toLowerCase(Locale.ENGLISH).contains("server");
                    if (isServer) {
                        if (buildNumber >= 26040 || buildNumber >= 26100) {
                            this.set(OperatingSystem.WINDOWS_SERVER_2025);
                        } else if (buildNumber >= 20348) {
                            this.set(OperatingSystem.WINDOWS_SERVER_2022);
                        } else if (buildNumber >= 17763) {
                            this.set(OperatingSystem.WINDOWS_SERVER_2019);
                        } else if (buildNumber >= 14393) {
                            this.set(OperatingSystem.WINDOWS_SERVER_2016);
                        }
                        return;
                    }
                    if (buildNumber >= 26200) {
                        this.set(OperatingSystem.WINDOWS_11_25H2);
                    } else if (buildNumber >= 26052 || buildNumber >= 26080 || buildNumber >= 26100) {
                        this.set(OperatingSystem.WINDOWS_11_24H2);
                    } else if (buildNumber >= 22631) {
                        this.set(OperatingSystem.WINDOWS_11_23H2);
                    } else if (buildNumber >= 22621) {
                        this.set(OperatingSystem.WINDOWS_11_22H2);
                    } else if (buildNumber >= 22000) {
                        this.set(OperatingSystem.WINDOWS_11);
                    } else if (buildNumber >= 19045) {
                        this.set(OperatingSystem.WINDOWS_10_22H2);
                    } else if (buildNumber >= 19044) {
                        this.set(OperatingSystem.WINDOWS_10_21H2);
                    } else if (buildNumber >= 19043) {
                        this.set(OperatingSystem.WINDOWS_10_21H1);
                    } else if (buildNumber >= 19042) {
                        this.set(OperatingSystem.WINDOWS_10_20H2);
                    } else if (buildNumber >= 10240) {
                        this.set(OperatingSystem.WINDOWS_10);
                    } else if (buildNumber >= 9600) {
                        this.set(OperatingSystem.WINDOWS_8_1);
                    } else if (buildNumber >= 9200) {
                        this.set(OperatingSystem.WINDOWS_8);
                    } else if (buildNumber >= 7601) {
                        this.set(OperatingSystem.WINDOWS_7);
                    } else if (buildNumber >= 6002) {
                        this.set(OperatingSystem.WINDOWS_VISTA);
                    } else if (buildNumber >= 2600) {
                        this.set(OperatingSystem.WINDOWS_XP);
                    }
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
                finally {
                    this.set(null);
                    if (process != null) {
                        try {
                            process.destroy();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        try {
            AtomicReference<Object> atomicReference = reference;
            synchronized (atomicReference) {
                if (reference.get() == initialValue && thread.isAlive()) {
                    reference.wait(1000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object resultValue = reference.get();
        if (resultValue instanceof OperatingSystem) {
            return (OperatingSystem)((Object)resultValue);
        }
        return null;
    }

    public static OperatingSystem getWindowsRelease(String osName) {
        if (osName != null) {
            boolean forceProbeCMD = true;
            String os = osName.toLowerCase(Locale.ENGLISH);
            if (os.contains("windows 11")) {
                OperatingSystem ret = CrossSystem.getWindowsReleaseCMD(os);
                if (ret != null) {
                    return ret;
                }
                return OperatingSystem.WINDOWS_11;
            }
            if (os.contains("windows 10")) {
                try {
                    OperatingSystem ret;
                    long jvmVersion = JVMVersion.get();
                    boolean trustFlag = false;
                    if (!trustFlag && (ret = CrossSystem.getWindowsReleaseCMD(os)) != null) {
                        return ret;
                    }
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
                return OperatingSystem.WINDOWS_10;
            }
            if (os.contains("windows 8")) {
                OperatingSystem ret = CrossSystem.getWindowsReleaseCMD(os);
                if (ret != null) {
                    return ret;
                }
                if (os.contains("8.1")) {
                    return OperatingSystem.WINDOWS_8_1;
                }
                return OperatingSystem.WINDOWS_8;
            }
            if (os.contains("windows 7")) {
                return OperatingSystem.WINDOWS_7;
            }
            if (os.contains("windows xp")) {
                return OperatingSystem.WINDOWS_XP;
            }
            if (os.contains("windows vista")) {
                return OperatingSystem.WINDOWS_VISTA;
            }
            if (os.contains("windows 2000")) {
                return OperatingSystem.WINDOWS_2000;
            }
            if (os.contains("windows 2003")) {
                return OperatingSystem.WINDOWS_2003;
            }
            if (os.contains("windows server 2003")) {
                return OperatingSystem.WINDOWS_SERVER_2003;
            }
            if (os.contains("windows server 2008")) {
                if (os.contains("r2")) {
                    return OperatingSystem.WINDOWS_SERVER_2008_R2;
                }
                return OperatingSystem.WINDOWS_SERVER_2008;
            }
            if (os.contains("windows server 2012")) {
                if (os.contains("r2")) {
                    return OperatingSystem.WINDOWS_SERVER_2012_R2;
                }
                return OperatingSystem.WINDOWS_SERVER_2012;
            }
            if (os.contains("windows server 2016")) {
                return OperatingSystem.WINDOWS_SERVER_2016;
            }
            if (os.contains("windows server 2019")) {
                return OperatingSystem.WINDOWS_SERVER_2019;
            }
            if (os.contains("windows server 2020")) {
                return OperatingSystem.WINDOWS_SERVER_2020;
            }
            if (os.contains("windows server 2022")) {
                return OperatingSystem.WINDOWS_SERVER_2022;
            }
            if (os.contains("windows server 2025")) {
                return OperatingSystem.WINDOWS_SERVER_2025;
            }
            if (os.contains("nt")) {
                return OperatingSystem.WINDOWS_NT;
            }
            if (os.contains("windows")) {
                return OperatingSystem.WINDOWS_OTHERS;
            }
        }
        return null;
    }

    public static OperatingSystem getMacOSRelease(String osName, String osVersion) {
        String os;
        if (osName != null && ((os = osName.toLowerCase(Locale.ENGLISH)).contains("mac") || os.contains("darwin"))) {
            final AtomicReference sw_ver = new AtomicReference();
            Thread thread = new Thread("getMacOSRelease:sw_ver"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File binary = new File("/usr/bin/sw_vers");
                    if (binary.exists()) {
                        Process p = null;
                        try {
                            String line;
                            Runtime r = Runtime.getRuntime();
                            p = r.exec(new String[]{binary.getAbsolutePath(), "-productVersion"});
                            p.waitFor();
                            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
                            while ((line = b.readLine()) != null) {
                                if (!line.trim().matches("^[0-9\\.]+$")) continue;
                                System.out.println("MacOS: detected sw_vers:" + line);
                                sw_ver.set(line.trim());
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            try {
                                if (p != null) {
                                    p.destroy();
                                }
                            }
                            catch (Throwable r) {}
                        }
                    }
                }
            };
            thread.start();
            try {
                thread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long version = Math.max(CrossSystem.parseMacOSVersion(osVersion), CrossSystem.parseMacOSVersion((String)sw_ver.get()));
            if (version >= 26000000L) {
                return OperatingSystem.MAC_TAHOE;
            }
            if (version >= 15000000L) {
                return OperatingSystem.MAC_SEQUOIA;
            }
            if (version >= 14000000L) {
                return OperatingSystem.MAC_SONOMA;
            }
            if (version >= 13000000L) {
                return OperatingSystem.MAC_VENTURA;
            }
            if (version >= 12000000L) {
                return OperatingSystem.MAC_MONTEREY;
            }
            if (version >= 11000000L) {
                return OperatingSystem.MAC_BIG_SUR;
            }
            if (version >= 0x98E888L || version >= 10026000L) {
                return OperatingSystem.MAC_TAHOE;
            }
            if (version >= 10020000L) {
                return OperatingSystem.MAC_SEQUOIA;
            }
            if (version >= 10019000L) {
                return OperatingSystem.MAC_SONOMA;
            }
            if (version >= 10018000L) {
                return OperatingSystem.MAC_VENTURA;
            }
            if (version >= 10017000L) {
                return OperatingSystem.MAC_MONTEREY;
            }
            if (version >= 10016000L) {
                return OperatingSystem.MAC_BIG_SUR;
            }
            if (version >= 10015000L) {
                return OperatingSystem.MAC_CATALINA;
            }
            if (version >= 10014000L) {
                return OperatingSystem.MAC_MOJAVE;
            }
            if (version >= 10013000L) {
                return OperatingSystem.MAC_HIGH_SIERRA;
            }
            if (version >= 10012000L) {
                return OperatingSystem.MAC_SIERRA;
            }
            if (version >= 10011000L) {
                return OperatingSystem.MAC_EL_CAPITAN;
            }
            if (version >= 10010000L) {
                return OperatingSystem.MAC_YOSEMITE;
            }
            if (version >= 10009000L) {
                return OperatingSystem.MAC_MAVERICKS;
            }
            if (version >= 10008000L) {
                return OperatingSystem.MAC_MOUNTAIN_LION;
            }
            if (version >= 10007000L) {
                return OperatingSystem.MAC_LION;
            }
            if (version >= 10006000L) {
                return OperatingSystem.MAC_SNOW_LEOPOARD;
            }
            if (version >= 10005000L) {
                return OperatingSystem.MAC_LEOPOARD;
            }
            if (version >= 10004000L) {
                return OperatingSystem.MAC_TIGER;
            }
            if (version >= 10003000L) {
                return OperatingSystem.MAC_PANTHER;
            }
            if (version >= 10002000L) {
                return OperatingSystem.MAC_JAGUAR;
            }
            if (version >= 10001000L) {
                return OperatingSystem.MAC_PUMA;
            }
            if (version >= 10000000L) {
                return OperatingSystem.MAC_CHEETAH;
            }
            return OperatingSystem.MAC;
        }
        return null;
    }

    public static OperatingSystem getBSDRelease(String osName) {
        String os;
        if (osName != null && (os = osName.toLowerCase(Locale.ENGLISH)).contains("bsd")) {
            if (os.contains("kfreebsd")) {
                return OperatingSystem.KFREEBSD;
            }
            if (os.contains("freebsd")) {
                return OperatingSystem.FREEBSD;
            }
            if (os.contains("netbsd")) {
                return OperatingSystem.NETBSD;
            }
            if (os.contains("openbsd")) {
                return OperatingSystem.OPENBSD;
            }
            if (os.contains("dragonflybsd")) {
                return OperatingSystem.DRAGONFLYBSD;
            }
            return OperatingSystem.BSD;
        }
        return null;
    }

    private static OperatingSystem getLinuxRelease(OperatingSystem base, String release) {
        OperatingSystem best = null;
        for (OperatingSystem os : OperatingSystems) {
            if (!base.sameOSFamily(os) || !os.isRelease(release)) continue;
            best = os;
        }
        return best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OperatingSystem getLinuxRelease(String osName) {
        OperatingSystem ret = null;
        if (osName == null) return ret;
        if (!osName.toLowerCase(Locale.ENGLISH).contains("linux")) return ret;
        ArrayList<String> sources = new ArrayList<String>(Arrays.asList("/etc/os-release", "/etc/issue", "/usr/lib/os-release"));
        if (Flatpak.isInsideFlatpak()) {
            sources.add(0, "/run/host/os-release");
        }
        Iterator iterator = sources.iterator();
        block49: while (iterator.hasNext()) {
            String source = (String)iterator.next();
            File issue = new File(source);
            if (!issue.isFile()) continue;
            try {
                FileInputStream fis = new FileInputStream(issue);
                try {
                    BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                    try {
                        OperatingSystem operatingSystem;
                        String line = null;
                        while (true) {
                            OperatingSystem release;
                            if ((line = is.readLine()) == null) continue block49;
                            if ((line = line.toLowerCase(Locale.ENGLISH)).contains("debian") || OperatingSystem.DEBIAN.equals((Object)ret)) {
                                ret = OperatingSystem.DEBIAN;
                                release = CrossSystem.getLinuxRelease(ret, line);
                                if (release == null) continue;
                                OperatingSystem operatingSystem2 = release;
                                return operatingSystem2;
                            }
                            if (line.contains("raspbian") || OperatingSystem.RASPBIAN.equals((Object)ret)) {
                                ret = OperatingSystem.RASPBIAN;
                                release = CrossSystem.getLinuxRelease(ret, line);
                                if (release == null) continue;
                                OperatingSystem operatingSystem3 = release;
                                return operatingSystem3;
                            }
                            if (line.contains("ubuntu") || OperatingSystem.UBUNTU.equals((Object)ret)) {
                                ret = OperatingSystem.UBUNTU;
                                release = CrossSystem.getLinuxRelease(ret, line);
                                if (release == null) continue;
                                OperatingSystem operatingSystem4 = release;
                                return operatingSystem4;
                            }
                            if (line.contains("kali") || line.contains("kali gnu/linux") || OperatingSystem.KALILINUX.equals((Object)ret)) {
                                ret = OperatingSystem.KALILINUX;
                                release = CrossSystem.getLinuxRelease(ret, line);
                                if (release == null) continue;
                                OperatingSystem operatingSystem5 = release;
                                return operatingSystem5;
                            }
                            if (ret != null) continue;
                            if (line.contains("rocky linux") || line.contains("rocky-linux")) {
                                release = OperatingSystem.ROCKYLINUX;
                                return release;
                            }
                            if (line.contains("almalinux")) {
                                release = OperatingSystem.ALMALINUX;
                                return release;
                            }
                            if (line.contains("mageia")) {
                                release = OperatingSystem.MAGEIA;
                                return release;
                            }
                            if (line.contains("nixos")) {
                                release = OperatingSystem.NIXOS;
                                return release;
                            }
                            if (line.contains("elementary")) {
                                release = OperatingSystem.ELEMENTARYOS;
                                return release;
                            }
                            if (line.contains("endeavour")) {
                                release = OperatingSystem.ENDEAVOUROS;
                                return release;
                            }
                            if (line.contains("manjaro")) {
                                release = OperatingSystem.MANJARO;
                                return release;
                            }
                            if (line.contains("alpine")) {
                                release = OperatingSystem.ALPINE;
                                return release;
                            }
                            if (line.contains("sles")) {
                                release = OperatingSystem.SLES;
                                return release;
                            }
                            if (line.contains("red hat") || line.contains("rhel")) {
                                release = OperatingSystem.REDHAT;
                                return release;
                            }
                            if (line.contains("gentoo")) {
                                release = OperatingSystem.GENTOO;
                                return release;
                            }
                            if (line.contains("arch linux")) {
                                release = OperatingSystem.ARCH;
                                return release;
                            }
                            if (line.contains("slackware")) {
                                release = OperatingSystem.SLACKWARE;
                                return release;
                            }
                            if (line.contains("opensuse")) {
                                ret = OperatingSystem.OPENSUSE;
                                release = CrossSystem.getLinuxRelease(ret, line);
                                if (release == null) continue;
                                OperatingSystem operatingSystem6 = release;
                                return operatingSystem6;
                            }
                            if (line.contains("centos")) {
                                if (line.contains("centos stream")) {
                                    operatingSystem = OperatingSystem.CENTOS_STREAM;
                                    return operatingSystem;
                                }
                                operatingSystem = OperatingSystem.CENTOS;
                                return operatingSystem;
                            }
                            if (line.contains("fedora")) break;
                        }
                        operatingSystem = OperatingSystem.FEDORA;
                        return operatingSystem;
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    fis.close();
                }
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
        return ret;
    }

    public static OperatingSystem getOSByString(String osString) {
        if (osString != null) {
            String os = osString.toLowerCase(Locale.ENGLISH);
            OperatingSystem ret = null;
            if (ret == null && (os.contains("windows") || os.contains("nt"))) {
                ret = CrossSystem.getWindowsRelease(os);
            }
            if (ret == null && (os.contains("mac") || os.contains("darwin"))) {
                ret = CrossSystem.getMacOSRelease(os, System.getProperty("os.version"));
            }
            if (ret == null && os.contains("bsd")) {
                ret = CrossSystem.getBSDRelease(os);
            }
            if (ret == null && os.contains("os/2")) {
                ret = OperatingSystem.OS2;
            }
            if (ret == null) {
                ret = CrossSystem.getLinuxRelease(os);
            }
            if (ret != null) {
                return ret;
            }
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.WINDOWS_8;
    }

    private static ARCHFamily getARCHByString(String archString) {
        if (archString != null) {
            String arch = archString.toLowerCase(Locale.ENGLISH);
            if (arch.contains("i386") || arch.contains("i486") || arch.contains("i586") || arch.contains("i686") || arch.contains("x86") || arch.contains("amd64")) {
                return ARCHFamily.X86;
            }
            if (arch.contains("ppc") || arch.contains("powerpc")) {
                return ARCHFamily.PPC;
            }
            if (arch.contains("mips")) {
                return ARCHFamily.MIPS;
            }
            if (arch.contains("sparc")) {
                return ARCHFamily.SPARC;
            }
            if (arch.contains("arm") || arch.contains("aarch")) {
                return ARCHFamily.ARM;
            }
            if (arch.contains("ia64")) {
                return ARCHFamily.IA64;
            }
            if (arch.contains("riscv")) {
                return ARCHFamily.RISCV;
            }
            if (arch.contains("loongarch") || arch.contains("loong")) {
                return ARCHFamily.LOONGARCH;
            }
        }
        return ARCHFamily.NA;
    }

    public static OSFamily getOSFamily() {
        return OS.getFamily();
    }

    public static ARCHFamily getARCHFamily() {
        return ARCH;
    }

    public static String getARCHString() {
        return ARCH_STRING;
    }

    public static String getOSString() {
        return OS_STRING;
    }

    public static String[] getPathComponents(File path) throws IOException {
        LinkedList<String> ret = new LinkedList<String>();
        if (path != null) {
            try {
                if (!CrossSystem.isForbiddenFilename(path.getName())) {
                    path = path.getCanonicalFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String separator = File.separatorChar + "";
            while (path != null) {
                if (path.getPath().endsWith(separator)) {
                    ret.add(0, path.getPath());
                    break;
                }
                ret.add(0, path.getName());
                path = path.getParentFile();
            }
        }
        return ret.toArray(new String[0]);
    }

    public static double getSystemCPUUsage() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            double sysload = operatingSystemMXBean.getSystemLoadAverage();
            if (sysload < 0.0) {
                Method method = operatingSystemMXBean.getClass().getDeclaredMethod("getSystemCpuLoad", new Class[0]);
                method.setAccessible(true);
                sysload = (Double)method.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            return sysload;
        }
        catch (Throwable e) {
            return -1.0;
        }
    }

    public static long getPID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        try {
            String jvmName = runtimeMXBean.getName();
            int index = jvmName.indexOf(64);
            if (index >= 1) {
                return Long.parseLong(jvmName.substring(0, index), 10);
            }
        }
        catch (Throwable jvmName) {
            // empty catch block
        }
        try {
            Field jvmField = runtimeMXBean.getClass().getDeclaredField("jvm");
            jvmField.setAccessible(true);
            Object vmManagement = jvmField.get(runtimeMXBean);
            Method getProcessIdMethod = vmManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            getProcessIdMethod.setAccessible(true);
            return ((Number)getProcessIdMethod.invoke(vmManagement, new Object[0])).longValue();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public static String getNewLine() {
        if (NEWLINE == null) {
            String newLine = null;
            try {
                if (JVMVersion.isMinimum(JVMVersion.JAVA_1_7)) {
                    newLine = System.lineSeparator();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isEmpty(newLine)) {
                newLine = System.getProperty("line.separator");
            }
            if (StringUtils.isEmpty(newLine)) {
                switch (CrossSystem.getOSFamily()) {
                    case WINDOWS: {
                        newLine = "\r\n";
                        break;
                    }
                    default: {
                        newLine = "\n";
                    }
                }
            }
            NEWLINE = newLine;
            return newLine;
        }
        return NEWLINE;
    }

    @Deprecated
    public static boolean is64BitArch() {
        String osArch;
        if (CrossSystem.isWindows()) {
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            if (wow64Arch != null) {
                return wow64Arch.trim().endsWith("64");
            }
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            if (arch != null) {
                return arch.trim().endsWith("64");
            }
        }
        if ((osArch = System.getProperty("os.arch")) != null) {
            Boolean result = CrossSystem.is64BitARCH(osArch, false);
            if (result != null) {
                return result;
            }
            return false;
        }
        return false;
    }

    public static Boolean is64BitARCH(String arch, boolean relaxed) {
        if (arch != null) {
            arch = arch.toLowerCase(Locale.ENGLISH);
            if (relaxed && (arch.contains("amd64") || arch.contains("amd_64") || arch.contains("x86_64")) || arch.equals("amd64") || arch.equals("amd_64") || arch.equals("x86_64")) {
                return true;
            }
            if (relaxed && (arch.contains("aarch64") || arch.contains("arm64")) || arch.equals("aarch64") || arch.equals("arm64")) {
                return true;
            }
            if (relaxed && arch.contains("riscv64") || arch.equals("riscv64")) {
                return true;
            }
            if (relaxed && arch.contains("sparcv9") || arch.equals("sparcv9")) {
                return true;
            }
            if (relaxed && arch.contains("mipsel") || arch.equals("mipsel")) {
                return true;
            }
            if (relaxed && arch.contains("ppc64") || arch.equals("ppc64")) {
                return true;
            }
            if (relaxed && arch.contains("ia64") || arch.equals("ia64")) {
                return true;
            }
            if (relaxed && (arch.contains("loongarch64") || arch.contains("loong64")) || arch.equals("loongarch64") || arch.equals("loong64")) {
                return true;
            }
            if (relaxed && arch.contains("riscv32") || arch.equals("riscv32")) {
                return false;
            }
            if (!relaxed && ("i386".equals(arch) || arch.equals("i486") || arch.equals("i586") || arch.equals("i686") || arch.equals("x86"))) {
                return false;
            }
            if (!relaxed && "sparc".equals(arch)) {
                return false;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean is64BitOperatingSystem() {
        if (CrossSystem.OS64BIT != null) {
            return CrossSystem.OS64BIT;
        }
        if (Application.is64BitJvm()) {
            CrossSystem.OS64BIT = true;
            return true;
        }
        switch (4.$SwitchMap$org$appwork$utils$os$CrossSystem$OSFamily[CrossSystem.getOSFamily().ordinal()]) {
            case 2: 
            case 4: {
                if (CrossSystem.is64BitArch()) {
                    CrossSystem.OS64BIT = true;
                    return true;
                }
                hostType = System.getenv("HOSTTYPE");
                if (hostType != null && Boolean.TRUE.equals(CrossSystem.is64BitARCH(hostType, false))) {
                    CrossSystem.OS64BIT = true;
                    return true;
                }
                p = null;
                r = Runtime.getRuntime();
                p = r.exec("uname -m");
                p.waitFor();
                b = new BufferedReader(new InputStreamReader(p.getInputStream()));
                line = b.readLine();
                if (line == null || !Boolean.TRUE.equals(CrossSystem.is64BitARCH(line, false))) ** GOTO lbl33
                CrossSystem.OS64BIT = true;
                var5_8 = true;
                try {
                    if (p != null) {
                        p.destroy();
                    }
                }
                catch (Throwable var6_9) {
                    // empty catch block
                }
                return var5_8;
lbl33:
                // 1 sources

                try {
                    if (p == null) break;
                    p.destroy();
                }
                catch (Throwable var2_3) {}
                break;
                catch (Throwable var2_4) {
                    try {
                        if (p == null) break;
                        p.destroy();
                    }
                    catch (Throwable var2_5) {}
                    break;
                }
                catch (Throwable var7_10) {
                    try {
                        if (p != null) {
                            p.destroy();
                        }
                    }
                    catch (Throwable var8_11) {
                        // empty catch block
                    }
                    throw var7_10;
                }
            }
            case 1: {
                if (System.getenv("ProgramFiles(x86)") == null && System.getenv("ProgramW6432") == null || !CrossSystem.is64BitArch()) break;
                CrossSystem.OS64BIT = true;
                return true;
            }
            default: {
                if (!CrossSystem.is64BitArch()) break;
                CrossSystem.OS64BIT = true;
                return true;
            }
        }
        CrossSystem.OS64BIT = false;
        return false;
    }

    public static boolean isAbsolutePath(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        if ((CrossSystem.isWindows() || CrossSystem.isOS2()) && path.matches("\\\\\\\\.+\\\\.+")) {
            return true;
        }
        if ((CrossSystem.isWindows() || CrossSystem.isOS2()) && path.matches("[a-zA-Z]:/.*")) {
            return true;
        }
        if ((CrossSystem.isWindows() || CrossSystem.isOS2()) && path.matches("[a-zA-Z]:\\\\.*")) {
            return true;
        }
        return !CrossSystem.isWindows() && !CrossSystem.isOS2() && path.startsWith("/");
    }

    public static boolean isClearSelectionTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(27, 0);
    }

    public static boolean isContextMenuTrigger(MouseEvent e) {
        if (CrossSystem.isMac() && e.getButton() == 1 && e.isControlDown()) {
            return true;
        }
        return e.isPopupTrigger() || e.getButton() == 3;
    }

    public static boolean isDeleteFinalSelectionTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if (CrossSystem.isMac() && ks == KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1)) {
            return true;
        }
        return ks == KeyStroke.getKeyStroke(127, 1);
    }

    public static boolean isDeleteSelectionTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if (CrossSystem.isMac() && ks == KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            return true;
        }
        return ks == KeyStroke.getKeyStroke(127, 0);
    }

    public static boolean isDeleteSelectionTrigger(KeyEvent e) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return CrossSystem.isDeleteSelectionTrigger(KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()));
    }

    public static boolean isOpenBrowserSupported() {
        return CrossSystem.getDesktopSupport().isBrowseURLSupported() || CrossSystem.getBrowserCommandLine() != null && CrossSystem.getBrowserCommandLine().length > 0;
    }

    public static boolean isOpenFileSupported() {
        return CrossSystem.getDesktopSupport().isOpenFileSupported();
    }

    public static boolean isCopySelectionTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static boolean isCutSelectionTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static boolean isPasteSelectionTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static boolean isSearchTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static boolean isSelectionAllTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static boolean isSelectionDownTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(40, 0);
    }

    public static boolean isSelectionUpTrigger(KeyStroke ks) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        return ks == KeyStroke.getKeyStroke(38, 0);
    }

    public static boolean isLinux() {
        OperatingSystem os = OS;
        if (os != null) {
            return OSFamily.LINUX.equals((Object)os.getFamily());
        }
        return OS_STRING != null && OS_STRING.toLowerCase(Locale.ROOT).contains("linux");
    }

    public static boolean isBSD() {
        OperatingSystem os = OS;
        if (os != null) {
            return OSFamily.BSD.equals((Object)os.getFamily());
        }
        return OS_STRING != null && OS_STRING.toLowerCase(Locale.ROOT).contains("bsd");
    }

    public static boolean isMac() {
        OperatingSystem os = OS;
        if (os != null) {
            return OSFamily.MAC.equals((Object)os.getFamily());
        }
        return OS_STRING != null && (OS_STRING.toLowerCase(Locale.ROOT).contains("mac") || OS_STRING.toLowerCase(Locale.ROOT).contains("darwin"));
    }

    public static boolean isOS2() {
        OperatingSystem os = OS;
        if (os != null) {
            return OSFamily.OS2.equals((Object)os.getFamily());
        }
        return OS_STRING != null && OS_STRING.toLowerCase(Locale.ROOT).contains("os/2");
    }

    public static boolean isWindows() {
        OperatingSystem os = OS;
        if (os != null) {
            return OSFamily.WINDOWS.equals((Object)os.getFamily());
        }
        return OS_STRING != null && (OS_STRING.toLowerCase(Locale.ROOT).contains("windows") || OS_STRING.toLowerCase(Locale.ROOT).contains("nt"));
    }

    protected static boolean openCustom(String[] commandLine, String url) throws IOException {
        if ((commandLine = CrossSystem.buildBrowserCommandline(commandLine, url)) != null && commandLine.length > 0) {
            Runtime.getRuntime().exec(commandLine);
            return true;
        }
        return false;
    }

    public static String[] buildBrowserCommandline(String[] commandLine, String url) {
        if (commandLine == null || commandLine.length == 0 || url == null || url.trim().length() == 0) {
            return null;
        }
        boolean urlParam = false;
        ArrayList<String> ret = new ArrayList<String>();
        for (String arg : commandLine) {
            if (arg == null) continue;
            if (arg.contains("%s")) {
                urlParam = true;
                ret.add(arg.replace("%s", url));
                continue;
            }
            ret.add(arg);
        }
        if (ret.size() > 0) {
            if (!urlParam) {
                ret.add(url);
            }
            return ret.toArray(new String[0]);
        }
        return null;
    }

    public static void openFile(final File file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    CrossSystem._openFILE(file);
                }
                catch (IOException e) {
                    LogV3.log(e);
                }
            }
        };
        if (CrossSystem.isWindows()) {
            new Thread(runnable, "Open Folder").start();
        } else {
            runnable.run();
        }
    }

    public static Throwable openURL(String url) {
        try {
            CrossSystem.openUrlOrThrowException(url);
            return null;
        }
        catch (Throwable e) {
            LogV3.log(e);
            return e;
        }
    }

    public static void openURL(URL url) {
        CrossSystem.openURL(url.toString());
    }

    public static void setBrowserCommandLine(String[] commands) {
        BROWSER_COMMANDLINE = commands;
    }

    public static void setFileCommandLine(String[] fILE_COMMANDLINE) {
        FILE_COMMANDLINE = fILE_COMMANDLINE;
    }

    public static void showInExplorer(File saveTo) {
        if (saveTo.exists()) {
            if (CrossSystem.isWindows()) {
                try {
                    new ProcessBuilder("cmd", "/c", "explorer /select,\"" + saveTo.getAbsolutePath() + "\"").start();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (CrossSystem.isMac()) {
                try {
                    ProcessBuilderFactory.create("open", "-R", saveTo.getAbsolutePath()).start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (saveTo.isDirectory()) {
            CrossSystem.openFile(saveTo);
        } else {
            CrossSystem.openFile(saveTo.getParentFile());
        }
    }

    public static String[] splitFileName(String filename) {
        String extension = new Regex(filename, "\\.+([^\\.]*$)").getMatch(0);
        String name = new Regex(filename, "(.*?)(\\.+[^\\.]*$|$)").getMatch(0);
        return new String[]{name, extension};
    }

    public static void standbySystem() throws InterruptedException {
        CrossSystem.getDesktopSupport().standby();
    }

    public static void hibernateSystem() throws InterruptedException {
        CrossSystem.getDesktopSupport().hibernate();
    }

    public static void shutdownSystem(boolean force) throws InterruptedException {
        CrossSystem.getDesktopSupport().shutdown(force);
    }

    public static void playErrorSound() {
        Object runnable;
        if (CrossSystem.getOSFamily() == OSFamily.WINDOWS && (runnable = Toolkit.getDefaultToolkit().getDesktopProperty("win.sound.exclamation")) != null && runnable instanceof Runnable) {
            ((Runnable)runnable).run();
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    static {
        OS64BIT = null;
        OS_STRING = System.getProperty("os.name");
        ARCH_STRING = System.getProperty("os.arch");
        OS = CrossSystem.getOSByString(OS_STRING);
        ARCH = CrossSystem.getARCHByString(ARCH_STRING);
        NEWLINE = null;
    }

    public static enum ARCHFamily {
        NA,
        X86,
        ARM,
        PPC,
        MIPS,
        SPARC,
        IA64,
        RISCV,
        LOONGARCH;

    }

    public static enum OSFamily {
        BSD,
        LINUX,
        MAC,
        OS2,
        OTHERS,
        WINDOWS;


        public static OSFamily get(OperatingSystem os) {
            return os != null ? os.getFamily() : null;
        }

        public static OSFamily get(String os) {
            if (os != null && os.length() > 2) {
                try {
                    return OperatingSystem.valueOf(os).getFamily();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        return OSFamily.valueOf(os.replaceFirst("(_.+)", ""));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    public static enum OperatingSystem {
        NETBSD(OSFamily.BSD),
        OPENBSD(OSFamily.BSD),
        KFREEBSD(OSFamily.BSD),
        FREEBSD(OSFamily.BSD),
        DRAGONFLYBSD(OSFamily.BSD),
        BSD(OSFamily.BSD),
        LINUX(OSFamily.LINUX),
        FEDORA(OSFamily.LINUX),
        CENTOS(OSFamily.LINUX),
        CENTOS_STREAM(OSFamily.LINUX),
        OPENSUSE(OSFamily.LINUX),
        OPENSUSE_LEAP(OSFamily.LINUX, "opensuse-leap"),
        OPENSUSE_TUMBLEWEED(OSFamily.LINUX, "opensuse-tumbleweed"),
        SLACKWARE(OSFamily.LINUX),
        ARCH(OSFamily.LINUX),
        GENTOO(OSFamily.LINUX),
        REDHAT(OSFamily.LINUX),
        SLES(OSFamily.LINUX),
        ALPINE(OSFamily.LINUX),
        MANJARO(OSFamily.LINUX),
        ENDEAVOUROS(OSFamily.LINUX),
        ELEMENTARYOS(OSFamily.LINUX),
        NIXOS(OSFamily.LINUX),
        MAGEIA(OSFamily.LINUX),
        ALMALINUX(OSFamily.LINUX),
        ROCKYLINUX(OSFamily.LINUX),
        KALILINUX(OSFamily.LINUX),
        KALILINUX_2022_1(OSFamily.LINUX, "2022\\.1"),
        KALILINUX_2022_2(OSFamily.LINUX, "2022\\.2"),
        KALILINUX_2022_3(OSFamily.LINUX, "2022\\.3"),
        KALILINUX_2022_4(OSFamily.LINUX, "2022\\.4"),
        KALILINUX_2023_1(OSFamily.LINUX, "2023\\.1"),
        KALILINUX_2023_2(OSFamily.LINUX, "2023\\.2"),
        KALILINUX_2023_3(OSFamily.LINUX, "2023\\.3"),
        KALILINUX_2023_4(OSFamily.LINUX, "2023\\.4"),
        KALILINUX_2024_1(OSFamily.LINUX, "2024\\.1"),
        KALILINUX_2024_2(OSFamily.LINUX, "2024\\.2"),
        KALILINUX_2024_3(OSFamily.LINUX, "2024\\.3"),
        KALILINUX_2024_4(OSFamily.LINUX, "2024\\.4"),
        KALILINUX_2025_1(OSFamily.LINUX, "2025\\.1"),
        KALILINUX_2025_2(OSFamily.LINUX, "2025\\.2"),
        KALILINUX_2025_3(OSFamily.LINUX, "2025\\.3"),
        KALILINUX_2025_4(OSFamily.LINUX, "2025\\.4"),
        DEBIAN(OSFamily.LINUX),
        DEBIAN_LENNY(OSFamily.LINUX, "lenny"),
        DEBIAN_SQUEEZE(OSFamily.LINUX, "squeeze"),
        DEBIAN_WHEEZY(OSFamily.LINUX, "wheezy"),
        DEBIAN_JESSIE(OSFamily.LINUX, "jessie"),
        DEBIAN_STRETCH(OSFamily.LINUX, "stretch"),
        DEBIAN_BUSTER(OSFamily.LINUX, "buster"),
        DEBIAN_BULLSEYE(OSFamily.LINUX, "bull"),
        DEBIAN_BOOKWORM(OSFamily.LINUX, "bookworm"),
        DEBIAN_TRIXIE(OSFamily.LINUX, "trixie"),
        DEBIAN_FORKY(OSFamily.LINUX, "forky"),
        DEBIAN_SID(OSFamily.LINUX, "sid"),
        RASPBIAN(OSFamily.LINUX),
        RASPBIAN_WHEEZY(OSFamily.LINUX, "wheezy"),
        RASPBIAN_JESSIE(OSFamily.LINUX, "jessie"),
        RASPBIAN_STRETCH(OSFamily.LINUX, "stretch"),
        RASPBIAN_BUSTER(OSFamily.LINUX, "buster"),
        RASPBIAN_BULLSEYE(OSFamily.LINUX, "bull"),
        RASPBIAN_BOOKWORM(OSFamily.LINUX, "bookworm"),
        RASPBIAN_TRIXIE(OSFamily.LINUX, "trixie"),
        UBUNTU(OSFamily.LINUX),
        UBUNTU_PRECISE(OSFamily.LINUX, "12\\.04"),
        UBUNTU_QUANTAL(OSFamily.LINUX, "12\\.10"),
        UBUNTU_RARING(OSFamily.LINUX, "13\\.04"),
        UBUNTU_SAUCY(OSFamily.LINUX, "13\\.10"),
        UBUNTU_TRUSTY(OSFamily.LINUX, "14\\.04"),
        UBUNTU_UTOPIC(OSFamily.LINUX, "14\\.10"),
        UBUNTU_VIVID(OSFamily.LINUX, "15\\.04"),
        UBUNTU_WILY(OSFamily.LINUX, "15\\.10"),
        UBUNTU_XENIAL(OSFamily.LINUX, "16\\.04"),
        UBUNTU_YAKKETY(OSFamily.LINUX, "16\\.10"),
        UBUNTU_ZESTY(OSFamily.LINUX, "17\\.04"),
        UBUNTU_ARTFUL(OSFamily.LINUX, "17\\.10"),
        UBUNTU_BIONIC(OSFamily.LINUX, "18\\.04"),
        UBUNTU_COSMIC(OSFamily.LINUX, "18\\.10"),
        UBUNTU_DISCO(OSFamily.LINUX, "19\\.04"),
        UBUNTU_EOAN(OSFamily.LINUX, "19\\.10"),
        UBUNTU_FOCAL(OSFamily.LINUX, "20\\.04"),
        UBUNTU_GROOVY(OSFamily.LINUX, "20\\.10"),
        UBUNTU_HIRSUTE(OSFamily.LINUX, "21\\.04"),
        UBUNTU_IMPISH(OSFamily.LINUX, "21\\.10"),
        UBUNTU_JAMMY(OSFamily.LINUX, "22\\.04"),
        UBUNTU_KINETIC(OSFamily.LINUX, "22\\.10"),
        UBUNTU_LUNAR(OSFamily.LINUX, "23\\.04"),
        UBUNTU_MANTIC(OSFamily.LINUX, "23\\.10"),
        UBUNTU_NOBLE(OSFamily.LINUX, "24\\.04"),
        UBUNTU_ORACULAR(OSFamily.LINUX, "24\\.10"),
        UBUNTU_PLUCKY(OSFamily.LINUX, "25\\.04"),
        UBUNTU_QUOKKA(OSFamily.LINUX, "25\\.10"),
        UBUNTU_RESOLUTE(OSFamily.LINUX, "26\\.04"),
        MAC(OSFamily.MAC),
        MAC_CHEETAH(OSFamily.MAC),
        MAC_PUMA(OSFamily.MAC),
        MAC_JAGUAR(OSFamily.MAC),
        MAC_PANTHER(OSFamily.MAC),
        MAC_TIGER(OSFamily.MAC),
        MAC_LEOPOARD(OSFamily.MAC),
        MAC_SNOW_LEOPOARD(OSFamily.MAC),
        MAC_LION(OSFamily.MAC),
        MAC_MOUNTAIN_LION(OSFamily.MAC),
        MAC_MAVERICKS(OSFamily.MAC),
        MAC_YOSEMITE(OSFamily.MAC),
        MAC_EL_CAPITAN(OSFamily.MAC),
        MAC_SIERRA(OSFamily.MAC),
        MAC_HIGH_SIERRA(OSFamily.MAC),
        MAC_MOJAVE(OSFamily.MAC),
        MAC_CATALINA(OSFamily.MAC),
        MAC_BIG_SUR(OSFamily.MAC),
        MAC_MONTEREY(OSFamily.MAC),
        MAC_VENTURA(OSFamily.MAC),
        MAC_SONOMA(OSFamily.MAC),
        MAC_SEQUOIA(OSFamily.MAC),
        MAC_TAHOE(OSFamily.MAC),
        OS2(OSFamily.OS2),
        WINDOWS_OTHERS(OSFamily.WINDOWS),
        WINDOWS_NT(OSFamily.WINDOWS),
        WINDOWS_2000(OSFamily.WINDOWS),
        WINDOWS_XP(OSFamily.WINDOWS),
        WINDOWS_2003(OSFamily.WINDOWS),
        WINDOWS_SERVER_2003(OSFamily.WINDOWS),
        WINDOWS_VISTA(OSFamily.WINDOWS),
        WINDOWS_SERVER_2008(OSFamily.WINDOWS),
        WINDOWS_7(OSFamily.WINDOWS),
        WINDOWS_SERVER_2008_R2(OSFamily.WINDOWS),
        WINDOWS_8(OSFamily.WINDOWS),
        WINDOWS_SERVER_2012(OSFamily.WINDOWS),
        WINDOWS_8_1(OSFamily.WINDOWS),
        WINDOWS_SERVER_2012_R2(OSFamily.WINDOWS),
        WINDOWS_10(OSFamily.WINDOWS),
        WINDOWS_10_20H2(OSFamily.WINDOWS),
        WINDOWS_10_21H1(OSFamily.WINDOWS),
        WINDOWS_10_21H2(OSFamily.WINDOWS),
        WINDOWS_10_22H2(OSFamily.WINDOWS),
        WINDOWS_SERVER_2016(OSFamily.WINDOWS),
        WINDOWS_SERVER_2019(OSFamily.WINDOWS),
        WINDOWS_SERVER_2020(OSFamily.WINDOWS),
        WINDOWS_SERVER_2022(OSFamily.WINDOWS),
        WINDOWS_SERVER_2025(OSFamily.WINDOWS),
        WINDOWS_11(OSFamily.WINDOWS),
        WINDOWS_11_21H2(OSFamily.WINDOWS),
        WINDOWS_11_22H2(OSFamily.WINDOWS),
        WINDOWS_11_23H2(OSFamily.WINDOWS),
        WINDOWS_11_24H2(OSFamily.WINDOWS),
        WINDOWS_11_25H2(OSFamily.WINDOWS);

        private final OSFamily family;
        private final Pattern releasePattern;

        private OperatingSystem(OSFamily family) {
            this(family, (Pattern)null);
        }

        private OperatingSystem(OSFamily family, Pattern releasePattern) {
            this.family = family;
            this.releasePattern = releasePattern;
        }

        private OperatingSystem(OSFamily family, String releasePattern) {
            this(family, releasePattern != null ? Pattern.compile(releasePattern) : null);
        }

        public final OSFamily getFamily() {
            return this.family;
        }

        private boolean isRelease(String line) {
            return this.releasePattern != null && this.releasePattern.matcher(line).find();
        }

        public static boolean sameOSFamily(OperatingSystem x, OperatingSystem y) {
            if (x.getFamily().equals((Object)y.getFamily())) {
                String prefixX = x.name().replaceFirst("(_.+)", "");
                String prefixY = y.name().replaceFirst("(_.+)", "");
                return prefixX.equals(prefixY);
            }
            return false;
        }

        public boolean sameOSFamily(OperatingSystem x) {
            return OperatingSystem.sameOSFamily(x, this);
        }

        public final boolean isMaximum(OperatingSystem os) {
            if (this.sameOSFamily(os)) {
                int maximum = os.ordinal();
                return this.ordinal() <= maximum;
            }
            return false;
        }

        public final boolean isMinimum(OperatingSystem os) {
            if (this.sameOSFamily(os)) {
                int minimum = os.ordinal();
                return this.ordinal() >= minimum;
            }
            return false;
        }
    }
}

