/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.mime;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.appwork.loggingv3.LogV3;
import org.appwork.sunwrapper.WrapperNotAvailableException;
import org.appwork.sunwrapper.sun.awt.shell.ShellFolderWrapper;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.os.mime.MimeDefault;

public class MimeWindows
extends MimeDefault {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getFileIcon(String extension, int width, int height) throws IOException {
        Icon ret;
        String iconKey;
        block29: {
            iconKey = "osFileIcon_" + super.getIconKey(extension, width, height);
            ret = super.getCacheIcon(iconKey);
            if (ret != null) {
                return ret;
            }
            Boolean registryContainsFileIcon = this.registryContainsFileIcon(extension);
            if (Boolean.FALSE.equals(registryContainsFileIcon)) {
                ret = super.getFileIcon(extension, width, height);
            } else {
                File path = Application.getTempResource("images/" + extension + ".png");
                if (path.getParentFile().isDirectory()) {
                    path.getParentFile().delete();
                }
                if (!path.getParentFile().exists()) {
                    path.getParentFile().mkdirs();
                }
                try {
                    if (path.isFile()) {
                        try {
                            BufferedImage image = ImageProvider.read(path);
                            ret = image != null ? new ImageIcon(image) : null;
                        }
                        catch (IOException e) {
                            LogV3.I().getDefaultLogger().exception("Image:" + path, e);
                        }
                    }
                    if (ret != null) break block29;
                    File tempFile = null;
                    try {
                        Icon icon;
                        block30: {
                            tempFile = Application.getTempResource("icon" + System.nanoTime() + "." + extension);
                            if (!tempFile.exists()) {
                                IO.writeToFile(tempFile, new byte[0], IO.SYNC.NONE);
                            }
                            if (JVMVersion.isMinimum(JVMVersion.JAVA_17)) {
                                try {
                                    icon = ReflectionUtils.invoke(FileSystemView.class, "getSystemIcon", (Object)FileSystemView.getFileSystemView(), Icon.class, tempFile, 32, 32);
                                    ret = icon != null ? ImageProvider.toImageIcon(icon) : null;
                                }
                                catch (InvocationTargetException e) {
                                    LogV3.log(e);
                                }
                            }
                            if (ret == null) {
                                try {
                                    try {
                                        Image image = ShellFolderWrapper.getIcon(tempFile);
                                        if (image == null) break block30;
                                        ret = new ImageIcon(image);
                                        if (!Boolean.TRUE.equals(registryContainsFileIcon)) break block30;
                                        FileOutputStream fos = new FileOutputStream(path);
                                        try {
                                            ImageProvider.writeImage((RenderedImage)IconIO.toBufferedImage(image), "png", fos);
                                        }
                                        finally {
                                            fos.close();
                                        }
                                    }
                                    catch (WrapperNotAvailableException e) {
                                        LogV3.log(e);
                                    }
                                }
                                catch (Throwable e) {
                                    LogV3.I().getDefaultLogger().exception("TempFile:" + tempFile, e);
                                }
                            }
                        }
                        if (ret == null) {
                            icon = FileSystemView.getFileSystemView().getSystemIcon(tempFile);
                            ret = icon != null ? ImageProvider.toImageIcon(icon) : null;
                        }
                    }
                    finally {
                        if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                            tempFile.deleteOnExit();
                        }
                    }
                }
                catch (Throwable e) {
                    LogV3.log(e);
                }
            }
        }
        if (ret == null) {
            ret = super.getFileIcon(extension, width, height);
        }
        if (ret != null && (ret.getIconWidth() != width || ret.getIconHeight() != height)) {
            ret = IconIO.getScaledInstance(ret, width, height);
        }
        super.saveIconCache(iconKey, ret);
        return ret;
    }

    protected Boolean registryContainsFileIcon(String extension) {
        return null;
    }
}

