/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.HeadlessException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.reflection.CompiledType;

public abstract class EDT<T, ExceptionType extends Throwable>
implements Runnable {
    private static final boolean HEADLESS = Application.isHeadless();
    private volatile boolean done = false;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile AtomicReference<Object> runMode = new AtomicReference<Object>(null);
    private volatile T returnValue;
    private volatile Throwable exception;
    private volatile Exception caller;

    public T waitForAndSwallowInterrupt() throws ExceptionType {
        try {
            return this.waitFor();
        }
        catch (InterruptedException e) {
            Exceptions.resetInterruptFlag(e);
            return null;
        }
    }

    protected abstract T runInEDT() throws ExceptionType;

    @Override
    public void run() {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.runMode.compareAndSet(null, this);
                this.returnValue = this.runInEDT();
            }
            catch (Throwable e) {
                this.exception = e;
                if (this.caller != null && e instanceof HeadlessException) {
                    LogV3.exception(this, this.caller, "Unhandled Headless Exception in EDT", new Object[0]);
                }
            }
            finally {
                this.done = true;
            }
        }
    }

    public EDT<T, ExceptionType> start() {
        return this.start(false);
    }

    public EDT<T, ExceptionType> invokeLater() {
        return this.start(true);
    }

    protected EDT<T, ExceptionType> start(boolean invokeLater) {
        if (this.caller == null && HEADLESS) {
            this.caller = new Exception("EventDispatchThread in headless mode!?");
        }
        if (!invokeLater && SwingUtilities.isEventDispatchThread()) {
            if (this.runMode.compareAndSet(null, Boolean.FALSE) || this.runMode.compareAndSet(Boolean.TRUE, Boolean.FALSE)) {
                this.run();
            }
        } else if (this.runMode.compareAndSet(null, Boolean.TRUE)) {
            SwingUtilities.invokeLater(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T waitFor() throws InterruptedException, ExceptionType {
        T t;
        block28: {
            InterruptedException interrupted;
            block26: {
                T t2;
                block27: {
                    block24: {
                        T t3;
                        block25: {
                            interrupted = null;
                            if (!this.done) break block24;
                            t3 = this.returnValue;
                            if (interrupted == null) break block25;
                            throw interrupted;
                        }
                        if (this.exception != null) {
                            Exceptions.addSuppressed(this.exception, new Exception("caused here").fillInStackTrace());
                            if (this.exception instanceof Error) {
                                throw (Error)this.exception;
                            }
                            if (this.exception instanceof RuntimeException) {
                                throw (RuntimeException)this.exception;
                            }
                            CompiledType ct = CompiledType.create(this.getClass());
                            CompiledType actualExceptionType = ct.getComponentTypes(EDT.class)[1];
                            if (actualExceptionType.isInstanceOf(this.exception.getClass())) {
                                throw this.exception;
                            }
                            throw new WTFException(this.exception);
                        }
                        return t3;
                    }
                    this.start(false);
                    if (!this.done) break block26;
                    t2 = this.returnValue;
                    if (interrupted == null) break block27;
                    throw interrupted;
                }
                if (this.exception != null) {
                    Exceptions.addSuppressed(this.exception, new Exception("caused here").fillInStackTrace());
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    CompiledType ct = CompiledType.create(this.getClass());
                    CompiledType actualExceptionType = ct.getComponentTypes(EDT.class)[1];
                    if (actualExceptionType.isInstanceOf(this.exception.getClass())) {
                        throw this.exception;
                    }
                    throw new WTFException(this.exception);
                }
                return t2;
            }
            try {
                try {
                    while (!this.done) {
                        Thread.sleep(1L);
                    }
                }
                catch (InterruptedException e) {
                    interrupted = e;
                }
                t = this.returnValue;
                if (interrupted == null) break block28;
            }
            catch (Throwable throwable) {
                if (interrupted != null) {
                    throw interrupted;
                }
                if (this.exception != null) {
                    Exceptions.addSuppressed(this.exception, new Exception("caused here").fillInStackTrace());
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    CompiledType ct = CompiledType.create(this.getClass());
                    CompiledType actualExceptionType = ct.getComponentTypes(EDT.class)[1];
                    if (actualExceptionType.isInstanceOf(this.exception.getClass())) {
                        throw this.exception;
                    }
                    throw new WTFException(this.exception);
                }
                throw throwable;
            }
            throw interrupted;
        }
        if (this.exception != null) {
            Exceptions.addSuppressed(this.exception, new Exception("caused here").fillInStackTrace());
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            CompiledType ct = CompiledType.create(this.getClass());
            CompiledType actualExceptionType = ct.getComponentTypes(EDT.class)[1];
            if (actualExceptionType.isInstanceOf(this.exception.getClass())) {
                throw this.exception;
            }
            throw new WTFException(this.exception);
        }
        return t;
    }

    public static EDT<Object, RuntimeException> run(final Runnable runnable) {
        return new EDT<Object, RuntimeException>(){

            @Override
            protected Object runInEDT() throws RuntimeException {
                runnable.run();
                return null;
            }
        }.start();
    }

    public static EDT<Object, RuntimeException> invokeLater(final Runnable runnable) {
        return new EDT<Object, RuntimeException>(){

            @Override
            protected Object runInEDT() throws RuntimeException {
                runnable.run();
                return null;
            }
        }.invokeLater();
    }
}

