/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.HeadlessException;
import javax.swing.SwingUtilities;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;

@Deprecated
public abstract class EDTHelper<T>
implements Runnable {
    private volatile boolean done = false;
    private volatile boolean started = false;
    private volatile T returnValue;
    private volatile RuntimeException exception;
    private volatile InterruptedException interruptException;
    private volatile Error error;
    private volatile Exception caller;

    public abstract T edtRun();

    public InterruptedException getInterruptException() {
        return this.interruptException;
    }

    public T getReturnValue() {
        this.waitForEDT();
        return this.returnValue;
    }

    public boolean isInterrupted() {
        return this.interruptException != null;
    }

    @Override
    public void run() {
        this.started = true;
        try {
            if (Application.isHeadless() && this.caller != null) {
                LogV3.log(this.caller);
            }
            this.returnValue = this.edtRun();
        }
        catch (HeadlessException e) {
            this.exception = e;
            LogV3.log(e);
            LogV3.severe("Unhandled Headless Exception in EDT");
            if (this.caller != null) {
                LogV3.log(this.caller);
            }
        }
        catch (RuntimeException e) {
            this.exception = e;
            LogV3.log(e);
        }
        catch (Error e) {
            this.error = e;
            LogV3.log(e);
        }
        finally {
            this.done = true;
        }
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean invokeLater) {
        if (this.started) {
            return;
        }
        if (Application.isHeadless()) {
            this.caller = new Exception("EventDispatchThread in headless mode!?");
        }
        this.started = true;
        if (!invokeLater && SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void waitForEDT() {
        try {
            if (this.done) {
                return;
            }
            this.start(false);
            if (this.done) {
                return;
            }
            try {
                while (!this.done) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                this.interruptException = e;
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.error != null) {
                    throw this.error;
                }
                return;
            }
        }
        finally {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

