/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Image;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.appwork.loggingv3.LogV3;
import org.appwork.resources.AWUTheme;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.appwork.utils.interfaces.ValueConverter;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDT;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ComboBoxDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogHandler;
import org.appwork.utils.swing.dialog.DialogIcon;
import org.appwork.utils.swing.dialog.DisposeCallBack;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.appwork.utils.swing.dialog.InputDialog;
import org.appwork.utils.swing.dialog.LAFManagerInterface;
import org.appwork.utils.swing.dialog.PasswordDialog;
import org.appwork.utils.swing.dialog.TextAreaDialog;
import org.appwork.utils.swing.dialog.ValueDialog;

public class Dialog {
    public static final String LASTSELECTION = "LASTSELECTION_";
    public static final String FILECHOOSER = "FILECHOOSER";
    public static final String ICON_ERROR = DialogIcon.DIALOG_ERROR.path();
    public static final String ICON_INFO = DialogIcon.DIALOG_INFO.path();
    public static final String ICON_QUESTION = DialogIcon.DIALOG_HELP.path();
    public static final String ICON_WARNING = DialogIcon.DIALOG_WARNING.path();
    private static final Dialog INSTANCE = new Dialog();
    @Deprecated
    public static final int LOGIC_DONOTSHOW_BASED_ON_TITLE_ONLY = 4096;
    public static final int RETURN_CANCEL = 4;
    public static final int RETURN_CLOSED = 64;
    public static final int RETURN_INTERRUPT = 256;
    public static final int RETURN_EXCEPTION = 512;
    public static final int RETURN_DONT_SHOW_AGAIN = 8;
    public static final int RETURN_OK = 2;
    public static final int RETURN_SKIPPED_BY_DONT_SHOW = 16;
    public static final int RETURN_TIMEOUT = 32;
    public static final int RETURN_ESC = 128;
    private List<? extends Image> iconList = null;
    public static final int STYLE_HIDE_ICON = 256;
    public static final int STYLE_HTML = 128;
    public static final int STYLE_LARGE = 64;
    public static final int STYLE_SHOW_DO_NOT_DISPLAY_AGAIN = 32;
    public static final int STYLE_PASSWORD = 512;
    private int defaultTimeout = 20000;
    private LAFManagerInterface lafManager;
    private DialogHandler handler = null;
    private DialogHandler defaultHandler = new DialogHandler(){

        @Override
        public <T> T showDialog(AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
            return Dialog.this.showDialogRaw(dialog);
        }
    };

    public static Dialog I() {
        return INSTANCE;
    }

    public static boolean isClosed(Object value) {
        if (!(value instanceof Number)) {
            return false;
        }
        return BinaryLogic.containsSome(((Number)value).intValue(), 64);
    }

    public static boolean isOK(Object value) {
        if (!(value instanceof Number)) {
            return false;
        }
        return BinaryLogic.containsSome(((Number)value).intValue(), 2);
    }

    public static Icon getIconByText(String text) {
        try {
            if (text != null && text.contains("?")) {
                return AWUTheme.I().getIcon(ICON_QUESTION, 32);
            }
            if (text != null && (text.contains("error") || text.contains("exception"))) {
                return AWUTheme.I().getIcon(ICON_ERROR, 32);
            }
            if (text != null && text.contains("!")) {
                return AWUTheme.I().getIcon(ICON_WARNING, 32);
            }
            return AWUTheme.I().getIcon(ICON_INFO, 32);
        }
        catch (Throwable e) {
            LogV3.log(e);
            return null;
        }
    }

    public static Dialog getInstance() {
        return INSTANCE;
    }

    private Dialog() {
    }

    public DialogHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    protected int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public DialogHandler getHandler() {
        return this.handler;
    }

    public List<? extends Image> getIconList() {
        return this.iconList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LAFManagerInterface getLafManager() {
        Dialog dialog = this;
        synchronized (dialog) {
            return this.lafManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLaf() {
        Dialog dialog = this;
        synchronized (dialog) {
            if (this.lafManager != null) {
                this.lafManager.init();
                this.setLafManager(null);
            }
        }
    }

    public void setDefaultTimeout(int countdownTime) {
        this.defaultTimeout = countdownTime;
    }

    public void setHandler(DialogHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        this.handler = handler;
    }

    @Deprecated
    public void setIconList(List<? extends Image> iconList) {
        this.iconList = iconList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLafManager(LAFManagerInterface lafManager) {
        Dialog dialog = this;
        synchronized (dialog) {
            this.lafManager = lafManager;
        }
    }

    public int showComboDialog(int flag, String title, String question, Object[] options, int defaultSelectedIndex, Icon icon, String okOption, String cancelOption, ListCellRenderer renderer) throws DialogClosedException, DialogCanceledException {
        return this.showDialog(new ComboBoxDialog(flag, title, question, options, defaultSelectedIndex, icon, okOption, cancelOption, renderer));
    }

    public Object showComboDialog(int flag, String title, String question, Object[] options, Object defaultSelectedItem, Icon icon, String okOption, String cancelOption, ListCellRenderer renderer) throws DialogClosedException, DialogCanceledException {
        int def = 0;
        for (int i = 0; i < options.length; ++i) {
            if (options[i] != defaultSelectedItem) continue;
            def = i;
            break;
        }
        Integer returnIndex = this.showDialog(new ComboBoxDialog(flag, title, question, options, def, icon, okOption, cancelOption, renderer));
        return options[returnIndex];
    }

    public int showConfirmDialog(int flag, String question) throws DialogClosedException, DialogCanceledException {
        return this.showConfirmDialog(flag, _AWU.T.DIALOG_CONFIRMDIALOG_TITLE(), question, Dialog.getIconByText(question), null, null);
    }

    public int showConfirmDialog(int flag, String title, String question) throws DialogClosedException, DialogCanceledException {
        return this.showConfirmDialog(flag, title, question, Dialog.getIconByText(title + question), null, null);
    }

    public int showConfirmDialog(int flag, String title, String message, ImageIcon tmpicon, String okOption, String cancelOption) throws DialogClosedException, DialogCanceledException {
        return this.showConfirmDialog(flag, title, message, (Icon)tmpicon, okOption, cancelOption);
    }

    public int showConfirmDialog(int flag, String title, String message, Icon tmpicon, String okOption, String cancelOption) throws DialogClosedException, DialogCanceledException {
        return this.showConfirmDialog(flag, title, message, tmpicon, okOption, cancelOption, null);
    }

    public int showConfirmDialog(int flag, String title, String message, Icon tmpicon, String okOption, String cancelOption, final String dontShowAgainKey) throws DialogClosedException, DialogCanceledException {
        Icon icon = tmpicon == null ? Dialog.getIconByText(title + message) : tmpicon;
        ConfirmDialog dialog = StringUtils.isEmpty(dontShowAgainKey) ? new ConfirmDialog(flag, title, message, icon, okOption, cancelOption) : new ConfirmDialog(flag, title, message, icon, okOption, cancelOption){

            @Override
            public String getDontShowAgainKey() {
                return dontShowAgainKey;
            }
        };
        return this.showDialog(dialog);
    }

    public <T> T showDialog(AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
        DialogHandler lhandler = this.handler;
        if (lhandler != null) {
            return lhandler.showDialog(dialog);
        }
        return this.showDialogRaw(dialog);
    }

    public <T> T showDialogRaw(AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
        if (dialog == null) {
            return null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return this.showDialogRawInEDT(dialog);
        }
        return this.showDialogRawOutsideEDT(dialog);
    }

    protected <T> T showDialogRawInEDT(AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
        if (Application.isHeadless()) {
            throw new HeadlessException("No Dialogs in Headless Mode!");
        }
        dialog.setCallerIsEDT(true);
        try {
            dialog.displayDialog();
            T ret = dialog.getReturnValue();
            int mask = dialog.getReturnmask();
            if (BinaryLogic.containsSome(mask, 64)) {
                throw new DialogClosedException(mask);
            }
            if (BinaryLogic.containsSome(mask, 4)) {
                throw new DialogCanceledException(mask);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new DialogClosedException(dialog.getReturnmask() | 0x200, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T showDialogRawOutsideEDT(final AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
        dialog.setCallerIsEDT(false);
        if (Thread.currentThread().isInterrupted()) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    try {
                        dialog.interrupt();
                    }
                    catch (Exception e) {
                        dialog.getLogger().log(e);
                    }
                }
            };
            throw new DialogClosedException(256, (Throwable)new InterruptedException());
        }
        if (Application.isHeadless()) {
            throw new HeadlessException("No Dialogs in Headless Mode!");
        }
        final AtomicBoolean waitingLock = new AtomicBoolean(false);
        final AtomicReference exception = new AtomicReference();
        EDT<Void, RuntimeException> edt = new EDT<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void runInEDT() throws RuntimeException {
                try {
                    dialog.setDisposedCallback(new DisposeCallBack(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void dialogDisposed(AbstractDialog<?> dialog) {
                            exception.set(dialog.getLayoutException());
                            AtomicBoolean atomicBoolean = waitingLock;
                            synchronized (atomicBoolean) {
                                waitingLock.set(true);
                                waitingLock.notifyAll();
                            }
                        }
                    });
                    dialog.displayDialog();
                }
                catch (Throwable e) {
                    exception.set(e);
                    AtomicBoolean atomicBoolean = waitingLock;
                    synchronized (atomicBoolean) {
                        waitingLock.set(true);
                        waitingLock.notifyAll();
                    }
                }
                return null;
            }
        };
        edt.start();
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            AtomicBoolean atomicBoolean = waitingLock;
            synchronized (atomicBoolean) {
                if (!waitingLock.get()) {
                    waitingLock.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            dialog.getLogger().log(ie);
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    try {
                        dialog.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            try {
                Thread.currentThread().interrupt();
                throw new DialogClosedException(dialog.getReturnmask() | 0x100, (Throwable)ie);
            }
            catch (IllegalStateException ise) {
                dialog.getLogger().log(ise);
                throw new DialogClosedException(256, (Throwable)ie);
            }
        }
        T ret = dialog.getReturnValue();
        int mask = dialog.getReturnmask();
        if (exception.get() != null) {
            dialog.onInitException((Throwable)exception.get());
            LogV3.log((Throwable)exception.get());
            throw new DialogClosedException(mask | 0x200, (Throwable)exception.get());
        }
        if (BinaryLogic.containsSome(mask, 64)) {
            throw new DialogClosedException(mask);
        }
        if (BinaryLogic.containsSome(mask, 4)) {
            throw new DialogCanceledException(mask);
        }
        DebugMode.breakIf(mask == 0, "Bad Dialog? Mask should never be 0");
        return ret;
    }

    public int showErrorDialog(int flags, String title, String message) {
        try {
            return this.showConfirmDialog(flags, title, message, AWUTheme.I().getIcon(ICON_ERROR, 32), null, null);
        }
        catch (DialogClosedException e) {
            return 64;
        }
        catch (DialogCanceledException e) {
            return 4;
        }
    }

    public int showErrorDialog(String s) {
        try {
            return this.showConfirmDialog(48, _AWU.T.DIALOG_ERROR_TITLE(), s, AWUTheme.I().getIcon(ICON_ERROR, 32), null, null);
        }
        catch (DialogClosedException e) {
            return 64;
        }
        catch (DialogCanceledException e) {
            return 4;
        }
    }

    public int showExceptionDialog(String title, String message, Throwable e) {
        try {
            ExceptionDialog dialog = new ExceptionDialog(2064, title, message, e, null, null);
            this.showDialog(dialog);
        }
        catch (DialogClosedException e1) {
            return 64;
        }
        catch (DialogCanceledException e1) {
            return 4;
        }
        return 0;
    }

    public String showInputDialog(int flag, String question, String defaultvalue) throws DialogClosedException, DialogCanceledException {
        return this.showInputDialog(flag, _AWU.T.DIALOG_INPUT_TITLE(), question, defaultvalue, Dialog.getIconByText(question), null, null);
    }

    public String showInputDialog(int flag, String title, String message, String defaultMessage, Icon icon, String okOption, String cancelOption) throws DialogClosedException, DialogCanceledException {
        return this.showDialog(new InputDialog(flag, title, message, defaultMessage, icon, okOption, cancelOption));
    }

    public String showInputDialog(String message) throws DialogClosedException, DialogCanceledException {
        return this.showInputDialog(0, message, null);
    }

    public void showMessageDialog(int flag, String message) {
        this.showMessageDialog(flag, _AWU.T.DIALOG_MESSAGE_TITLE(), message);
    }

    public void showMessageDialog(int flag, String title, String message) {
        try {
            this.showConfirmDialog(0x10 | flag, title, message, Dialog.getIconByText(title + message), null, null);
        }
        catch (DialogClosedException dialogClosedException) {
        }
        catch (DialogCanceledException dialogCanceledException) {
            // empty catch block
        }
    }

    public void showMessageDialog(String message) {
        this.showMessageDialog(0, _AWU.T.DIALOG_MESSAGE_TITLE(), message);
    }

    public void showMessageDialog(String title, String message) {
        this.showMessageDialog(0, title, message);
    }

    public String showPasswordDialog(int flag, String question, String defaultvalue) throws DialogClosedException, DialogCanceledException {
        return this.showPasswordDialog(flag, _AWU.T.DIALOG_PASSWORD_TITLE(), question, defaultvalue, Dialog.getIconByText(question), null, null);
    }

    protected String showPasswordDialog(int flag, String title, String message, String defaultMessage, Icon icon, String okOption, String cancelOption) throws DialogClosedException, DialogCanceledException {
        return this.showDialog(new PasswordDialog(flag, title, message, icon, okOption, cancelOption));
    }

    public String showPasswordDialog(String message) throws DialogClosedException, DialogCanceledException {
        return this.showPasswordDialog(0, message, null);
    }

    public String showTextAreaDialog(String title, String message, String def) throws DialogClosedException, DialogCanceledException {
        return this.showDialog(new TextAreaDialog(title, message, def));
    }

    public long showValueDialog(int flag, String question, long defaultvalue, long min, long max, long step, ValueConverter valueConverter) throws DialogClosedException, DialogCanceledException {
        return this.showValueDialog(flag, _AWU.T.DIALOG_SLIDER_TITLE(), question, defaultvalue, Dialog.getIconByText(question), null, null, min, max, step, valueConverter);
    }

    protected long showValueDialog(int flag, String title, String message, long defaultMessage, Icon icon, String okOption, String cancelOption, long min, long max, long step, ValueConverter valueConverter) throws DialogClosedException, DialogCanceledException {
        return this.showDialog(new ValueDialog(flag, title, message, icon, okOption, cancelOption, defaultMessage, min, max, step, valueConverter));
    }

    public void showImage(Image image) {
        final ConfirmDialog d = new ConfirmDialog(16, "Image", "" + image.getWidth(null) + "x" + image.getHeight(null), new ImageIcon(image), null, null){

            @Override
            public Dialog.ModalityType getModalityType() {
                return Dialog.ModalityType.MODELESS;
            }
        };
        new Thread("Image Dialog"){

            @Override
            public void run() {
                UIOManager.I().show(null, d);
            }
        }.start();
    }
}

