/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.interfaces.ValueConverter;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ValueDialog
extends AbstractDialog<Long>
implements KeyListener,
MouseListener {
    private JTextArea converted;
    private final long defaultValue;
    private JTextField editable;
    private int faktor = 1;
    private final long max;
    private final String message;
    private JTextPane messageArea;
    private final long min;
    private JSlider slider;
    private final long step;
    private final ValueConverter valueconverter;

    public ValueDialog(int flag, String title, String message, Icon icon, String okOption, String cancelOption, long defaultValue, long min, long max, long step, ValueConverter valueConverter) {
        super(flag, title, icon, okOption, cancelOption);
        this.getLogger().fine("Dialog    [" + okOption + "][" + cancelOption + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + message + " \r\n" + min + "<=" + defaultValue + "<=" + max + " [" + step + "]");
        this.message = message;
        while (max > Integer.MAX_VALUE) {
            max /= 2L;
            defaultValue /= 2L;
            min /= 2L;
            step = Math.max(step / 2L, 1L);
            this.faktor *= 2;
        }
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.step = step;
        if (valueConverter == null) {
            valueConverter = new ValueConverter(){

                @Override
                public String toString(long value) {
                    return value * (long)ValueDialog.this.faktor + "";
                }
            };
        }
        this.valueconverter = valueConverter;
    }

    @Override
    protected Long createReturnValue() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return 0L;
        }
        this.updateSlider();
        return (long)this.slider.getValue() * (long)this.faktor;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.cancel();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel contentpane = new JPanel(new MigLayout("ins 0,wrap 1", "[fill,grow]"));
        this.messageArea = new JTextPane();
        this.messageArea.setBorder(null);
        this.messageArea.setBackground(null);
        this.messageArea.setOpaque(false);
        this.messageArea.setText(this.message);
        this.messageArea.setEditable(false);
        this.messageArea.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        contentpane.add(this.messageArea);
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            this.converted = new JTextArea(this.valueconverter.toString(this.defaultValue));
            this.converted.setEditable(false);
            this.converted.setBackground(null);
            this.slider = new JSlider(0, (int)this.min, (int)this.max, (int)this.defaultValue);
            this.slider.setMajorTickSpacing((int)this.step);
            this.slider.setSnapToTicks(true);
            this.slider.addKeyListener(this);
            this.slider.addMouseListener(this);
            this.editable = new JTextField();
            this.editable.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ValueDialog.this.updateSlider();
                }
            });
            this.editable.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ValueDialog.this.updateSlider();
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    ValueDialog.this.converted.setText(ValueDialog.this.valueconverter.toString(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor));
                    ValueDialog.this.editable.setText(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor + "");
                }
            });
            this.editable.setText(this.defaultValue + "");
            contentpane.add((Component)this.slider, "split 2,pushy,growy,w 250");
            contentpane.add((Component)this.editable, "growx,pushx,width 80:n:n");
            contentpane.add((Component)this.converted, "pushy,growy,w 250");
        } else {
            this.converted = new JTextArea(this.valueconverter.toString(this.defaultValue));
            this.slider = new JSlider(0, (int)this.min, (int)this.max, (int)this.defaultValue);
            this.slider.setMajorTickSpacing((int)this.step);
            this.slider.setSnapToTicks(true);
            this.slider.setBorder(BorderFactory.createEtchedBorder());
            this.slider.addKeyListener(this);
            this.slider.addMouseListener(this);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    ValueDialog.this.converted.setText(ValueDialog.this.valueconverter.toString(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor));
                    ValueDialog.this.editable.setText(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor + "");
                }
            });
            contentpane.add((Component)this.slider, "pushy,growy,w 250");
            contentpane.add((Component)this.converted, "pushy,growy,w 250");
        }
        return contentpane;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void initFocus(JComponent focus) {
        this.slider.requestFocusInWindow();
    }

    private void updateSlider() {
        block2: {
            try {
                long value = Long.parseLong(this.editable.getText());
                this.slider.setValue((int)(value / (long)this.faktor));
            }
            catch (Exception e) {
                if (this.editable == null) break block2;
                this.editable.setText(this.slider.getValue() * this.faktor + "");
            }
        }
    }
}

