/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.appwork.utils.Hash;
import org.appwork.utils.zip.ZipIOException;

public class ZipIOWriter {
    protected ZipOutputStream zipStream = null;
    protected OutputStream fileStream = null;
    protected File zipFile = null;
    protected final byte[] buf = new byte[16384];
    private HashSet<String> dupes = new HashSet();

    public ZipIOWriter(ByteArrayOutputStream stream) throws FileNotFoundException, ZipIOException {
        this.fileStream = stream;
        this.zipStream = new ZipOutputStream(this.fileStream);
    }

    public ZipIOWriter(File zipFile) throws FileNotFoundException, ZipIOException {
        this.zipFile = zipFile;
        this.openZip(false);
    }

    public ZipIOWriter(File zipFile, boolean overwrite) throws FileNotFoundException, ZipIOException {
        this.zipFile = zipFile;
        this.openZip(overwrite);
    }

    public ZipIOWriter(OutputStream stream) throws FileNotFoundException, ZipIOException {
        this.fileStream = stream;
        this.zipStream = new ZipOutputStream(this.fileStream);
    }

    public synchronized void add(File add, boolean compress, String path) throws ZipIOException, IOException {
        if (add == null || !add.exists()) {
            throw new ZipIOException("add " + add.getAbsolutePath() + " invalid");
        }
        if (add.isFile()) {
            this.addFileInternal(add, compress, path);
        } else if (add.isDirectory()) {
            this.addDirectoryInternal(add, compress, path);
        } else {
            throw new ZipIOException("add " + add.getAbsolutePath() + " invalid");
        }
    }

    public synchronized void addByteArry(byte[] data, boolean compress, String path, String name) throws IOException, ZipIOException {
        boolean zipEntryAdded = false;
        try {
            if (data == null) {
                throw new ZipIOException("data array is invalid");
            }
            String fullPath = (path != null && path.trim().length() > 0 ? path + "/" : "") + name;
            if (!this.dupes.add(fullPath)) {
                throw new IOException("Cannot add the same path multiple times...");
            }
            ZipEntry zipAdd = new ZipEntry(fullPath);
            zipAdd.setSize(data.length);
            if (compress) {
                zipAdd.setMethod(8);
            } else {
                zipAdd.setMethod(0);
                zipAdd.setCompressedSize(data.length);
                zipAdd.setCrc(Hash.getCRC32(data));
            }
            this.zipStream.putNextEntry(zipAdd);
            zipEntryAdded = true;
            this.zipStream.write(data, 0, data.length);
            this.notify(zipAdd, data.length, data.length);
        }
        catch (IOException e) {
            throw new IOException("Path:" + path + "|Name:" + name, e);
        }
        finally {
            if (zipEntryAdded) {
                this.zipStream.closeEntry();
            }
        }
    }

    public ZipOutputStream getZipStream() {
        return this.zipStream;
    }

    public synchronized void addDirectory(File addDirectory, boolean compress, String path) throws ZipIOException, IOException {
        this.addDirectoryInternal(addDirectory, compress, path);
    }

    protected void addDirectoryInternal(File addDirectory, boolean compress, String path) throws ZipIOException, IOException {
        if (addDirectory == null) {
            throw new ZipIOException("addDirectory invalid: null");
        }
        if (!addDirectory.exists() && this.throwExceptionOnFileGone(addDirectory)) {
            throw new ZipIOException("addDirectory " + addDirectory.getAbsolutePath() + " invalid: does not exist");
        }
        File[] list = addDirectory.listFiles();
        if (list != null) {
            for (File add : list) {
                if (add.isFile()) {
                    this.addFileInternal(add, compress, (path != null && path.trim().length() > 0 ? path + "/" : "") + addDirectory.getName());
                    continue;
                }
                if (add.isDirectory()) {
                    this.addDirectoryInternal(add, compress, (path != null && path.trim().length() > 0 ? path + "/" : "") + addDirectory.getName());
                    continue;
                }
                if (add.exists() || !this.throwExceptionOnFileGone(add)) continue;
                throw new ZipIOException("addDirectory: " + add.getAbsolutePath() + "(File:" + add.isFile() + "|Directory:" + add.isDirectory() + ")");
            }
        }
    }

    protected boolean throwExceptionOnFileGone(File file) {
        return true;
    }

    protected void notify(ZipEntry entry, long bytesWrite, long bytesProcessed) {
    }

    public synchronized void addFile(File addFile, boolean compress, String fullPath) throws ZipIOException, IOException, FileNotFoundException {
        FileInputStream fin = null;
        boolean zipEntryAdded = false;
        try {
            int len;
            if (addFile == null) {
                throw new ZipIOException("addFile invalid:null");
            }
            if (!this.dupes.add(fullPath)) {
                throw new IOException("Cannot add the same path multiple times...");
            }
            fin = new FileInputStream(addFile);
            ZipEntry zipAdd = new ZipEntry(fullPath);
            long size = addFile.length();
            zipAdd.setSize(size);
            if (compress) {
                zipAdd.setMethod(8);
            } else {
                zipAdd.setMethod(0);
                zipAdd.setCompressedSize(addFile.length());
                zipAdd.setCrc(Hash.getCRC32(addFile));
            }
            long total = 0L;
            this.zipStream.putNextEntry(zipAdd);
            while ((len = fin.read(this.buf)) > 0) {
                this.zipStream.write(this.buf, 0, len);
                this.notify(zipAdd, len, total += (long)len);
            }
            zipEntryAdded = true;
        }
        catch (FileNotFoundException e) {
            if (!addFile.exists()) {
                if (this.throwExceptionOnFileGone(addFile)) {
                    throw e;
                }
                return;
            }
            throw e;
        }
        catch (IOException e) {
            throw new IOException("File:" + addFile + "|Path:" + fullPath, e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Throwable throwable) {}
            if (zipEntryAdded) {
                this.zipStream.closeEntry();
            }
        }
    }

    private void addFileInternal(File addFile, boolean compress, String path) throws ZipIOException, IOException {
        String fullPath = (path != null && path.trim().length() > 0 ? path + "/" : "") + addFile.getName();
        this.addFile(addFile, compress, fullPath);
    }

    public synchronized void addFileToPath(File addFile, boolean compress, String path) throws ZipIOException, IOException {
        this.addFileInternal(addFile, compress, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFolder(String fullPath) throws IOException {
        if (!fullPath.endsWith("/")) {
            fullPath = fullPath + "/";
        }
        if (!this.dupes.add(fullPath)) {
            return;
        }
        boolean zipEntryAdded = false;
        try {
            ZipEntry zipAdd = new ZipEntry(fullPath);
            this.zipStream.putNextEntry(zipAdd);
            this.notify(zipAdd, -1L, -1L);
            zipEntryAdded = true;
        }
        finally {
            if (zipEntryAdded) {
                this.zipStream.closeEntry();
            }
        }
    }

    public synchronized void close() throws IOException {
        try {
            try {
                this.zipStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.fileStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.zipStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.fileStream instanceof FileOutputStream) {
                    ((FileOutputStream)this.fileStream).getChannel().force(true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.fileStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.zipStream = null;
            this.fileStream = null;
        }
    }

    private void openZip(boolean overwrite) throws ZipIOException, FileNotFoundException {
        if (this.fileStream != null && this.zipStream != null) {
            return;
        }
        if (this.zipFile == null || this.zipFile.isDirectory()) {
            throw new ZipIOException("invalid zipFile");
        }
        if (this.zipFile.exists() && !overwrite) {
            throw new ZipIOException("zipFile already exists");
        }
        this.fileStream = new FileOutputStream(this.zipFile);
        this.zipStream = new ZipOutputStream(this.fileStream);
    }
}

