/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import org.appwork.swing.action.BasicAction;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.update.UIInterface;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.gui.PollCallback;
import org.jdownloader.update.gui.UpdateGui;
import org.jdownloader.update.locale.T;
import org.jdownloader.updatev2.UpdateCallbackInterface;

public class UpdateGuiWrapper
implements UIInterface {
    private final UpdateManager manager;
    private volatile Timer pollTimer;
    private volatile double progress;
    private volatile String text;
    private volatile ImageIcon icon;
    private boolean init = false;
    private UpdateGui gui;
    private String cancelText;
    protected long visibleTime;

    public UpdateGuiWrapper(UpdateManager updateManager) {
        this.manager = updateManager;
    }

    @Override
    public void startPoll(final PollCallback pollCallback) {
        Timer pollTimer;
        this.pollTimer = pollTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                pollCallback.run();
            }
        });
        pollTimer.setRepeats(true);
        pollTimer.start();
    }

    @Override
    public void stopPoll() {
        Timer timer = this.pollTimer;
        if (timer != null) {
            this.pollTimer = null;
            timer.stop();
        }
    }

    @Override
    public void setIcon(final ImageIcon icon) {
        UpdateCallbackInterface handler = this.manager.getHandler();
        if (handler != null) {
            handler.updateGuiIcon(icon);
        }
        this.icon = icon;
        final UpdateGui gui = this.getCurrentGUI();
        if (gui != null) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    gui.setIcon(icon);
                }
            };
        }
    }

    @Override
    public void setText(final String text) {
        UpdateCallbackInterface handler = this.manager.getHandler();
        if (handler != null) {
            handler.updateGuiText(text);
        }
        this.text = text;
        final UpdateGui gui = this.getCurrentGUI();
        if (gui != null) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    gui.setText(text);
                }
            };
        }
    }

    @Override
    public void setProgress(final double d) {
        UpdateCallbackInterface handler = this.manager.getHandler();
        if (handler != null) {
            handler.updateGuiProgress(d);
        }
        this.progress = d;
        final UpdateGui gui = this.getCurrentGUI();
        if (gui != null) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    gui.setProgress(d);
                }
            };
        }
    }

    @Override
    public void onHead() {
        this.setCancelText(T.T.literally_close());
        this.setProgress(100.0);
    }

    @Override
    public boolean isVisible() {
        return Boolean.TRUE.equals(new EDTHelper<Boolean>(){

            @Override
            public Boolean edtRun() {
                UpdateGui gui = UpdateGuiWrapper.this.getCurrentGUI();
                if (gui == null) {
                    return false;
                }
                return gui.isVisible();
            }
        }.getReturnValue());
    }

    @Override
    public void setVisible(final boolean b) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (!b && UpdateGuiWrapper.this.getCurrentGUI() == null) {
                    return;
                }
                UpdateGui gui = UpdateGuiWrapper.this.getOrCreateGui();
                if (b && !gui.isVisible()) {
                    UpdateGuiWrapper.this.visibleTime = System.currentTimeMillis();
                }
                if (!b) {
                    UpdateGuiWrapper.this.setProgress(0.0);
                }
                if (AbstractDialog.getDefaultRoot() == null) {
                    AbstractDialog.setDefaultRoot(gui);
                }
                gui.setAlwaysOnTop(UpdateGuiWrapper.this.manager.getSettings().isUpdateGuiAlwaysOnTop() || UpdateGuiWrapper.this.manager.isAlwaysOnTopExternal());
                WindowManager.getInstance().setVisible(gui, b, WindowManager.FrameState.TO_FRONT_FOCUSED);
                if (!b) {
                    if (AbstractDialog.getDefaultRoot() == gui) {
                        AbstractDialog.setDefaultRoot(null);
                    }
                    gui.dispose();
                    UpdateGuiWrapper.this.setCurrentGui(null);
                }
            }
        }.getReturnValue();
    }

    private UpdateGui getOrCreateGui() {
        UpdateGui gui = this.getCurrentGUI();
        if (gui != null) {
            return gui;
        }
        EDTHelper<UpdateGui> helper = new EDTHelper<UpdateGui>(){

            @Override
            public UpdateGui edtRun() {
                UpdateGui gui = UpdateGuiWrapper.this.getCurrentGUI();
                if (gui != null) {
                    return gui;
                }
                if (!UpdateGuiWrapper.this.init) {
                    try {
                        Dialog.getInstance().initLaf();
                    }
                    catch (Throwable e) {
                        UpdateGuiWrapper.this.manager.getLogger().log(e);
                    }
                    finally {
                        UpdateGuiWrapper.this.init = true;
                    }
                }
                gui = new UpdateGui(UpdateGuiWrapper.this.manager, new BasicAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UpdateGuiWrapper.this.manager.onCanceledByUser();
                    }
                });
                gui.setAlwaysOnTop(UpdateGuiWrapper.this.manager.getSettings().isUpdateGuiAlwaysOnTop() || UpdateGuiWrapper.this.manager.isAlwaysOnTopExternal());
                gui.setProgress(UpdateGuiWrapper.this.progress);
                gui.setText(UpdateGuiWrapper.this.text);
                gui.setCancelText(UpdateGuiWrapper.this.cancelText);
                gui.setIcon(UpdateGuiWrapper.this.icon);
                UpdateGuiWrapper.this.setCurrentGui(gui);
                return gui;
            }
        };
        return (UpdateGui)helper.getReturnValue();
    }

    private void setCurrentGui(UpdateGui gui) {
        this.gui = gui;
    }

    @Override
    public void setCancelText(final String label) {
        this.cancelText = label;
        final UpdateGui gui = this.getCurrentGUI();
        if (gui != null) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    gui.setCancelText(label);
                }
            };
        }
    }

    @Override
    public void toFront() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateGui gui = UpdateGuiWrapper.this.getCurrentGUI();
                if (gui != null) {
                    WindowManager.getInstance().setZState(gui, WindowManager.FrameState.TO_FRONT);
                }
            }
        };
    }

    @Override
    public void setExtendedState(final int state) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateGui gui = UpdateGuiWrapper.this.getCurrentGUI();
                if (gui != null) {
                    WindowManager.getInstance().setExtendedState(gui, WindowManager.WindowExtendedState.get(state));
                }
            }
        };
    }

    @Override
    public Window getWindow() {
        return this.getCurrentGUI();
    }

    private UpdateGui getCurrentGUI() {
        UpdateGui gui = this.gui;
        if (gui == null) {
            return null;
        }
        return gui;
    }

    @Override
    public void setAlwaysOnTop(final boolean top) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateGui gui = UpdateGuiWrapper.this.getCurrentGUI();
                if (gui != null) {
                    gui.setAlwaysOnTop(top);
                }
            }
        };
    }
}

