/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.launcher;

import java.awt.Window;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.sql.Date;
import java.util.Arrays;
import java.util.jar.JarFile;
import org.appwork.app.launcher.parameterparser.CommandSwitch;
import org.appwork.app.launcher.parameterparser.ParameterParser;
import org.appwork.console.ConsoleDialog;
import org.appwork.loggingv3.LogV3;
import org.appwork.resources.AWUTheme;
import org.appwork.shutdown.ShutdownController;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.jardelta.JarDeltaMerge;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.LogSourceRedirector;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.singleapp.AnotherInstanceRunningException;
import org.appwork.utils.singleapp.Response;
import org.appwork.utils.singleapp.ResponseAdapter;
import org.appwork.utils.singleapp.SingleAppInstance;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.jdownloader.launcher.StandaloneLauncher;
import org.jdownloader.logging.LogController;
import org.jdownloader.update.DialogHook;
import org.jdownloader.update.LaunchState;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.gui.LAFManager;
import org.jdownloader.update.gui.UpdateGui;
import org.jdownloader.update.lastchance.LastChanceManager;
import org.jdownloader.update.launcher.ByPassEntropyBlock;
import org.jdownloader.update.launcher.JDLauncherFailedException;
import org.jdownloader.update.launcher.SelfTest;
import org.jdownloader.update.launcher.singleinstance.SingleInstanceController;
import org.jdownloader.updatev2.ForcedRestartRequest;
import org.jdownloader.updatev2.ForcedShutdown;
import org.jdownloader.updatev2.InstallLog;
import org.jdownloader.updatev2.LastChanceSettings;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.SmartRlyExitRequest;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.UpdateSettings;

public class SecondLevelLauncher {
    private static final String SELFTEST_POLL_RELPATH_REGEX = "tmp[/\\\\]selftest_(\\d+)";
    private static final String UPDATE_ON_EXIT = "updateonexit";
    private static LogSource LOGGER;
    public static UpdateManager UPDATE_MANAGER;

    public static void checkLanguageSwitch(String[] args) {
        try {
            File language = Application.getResource("cfg/language.json");
            String lng = null;
            if (language.isFile()) {
                lng = JSonStorage.restoreFrom(language, true, JSonStorage.KEY, TypeRef.STRING, TranslationFactory.getDesiredLanguage());
            }
            if (StringUtils.isEmpty(lng)) {
                lng = TranslationFactory.getDesiredLanguage();
            }
            TranslationFactory.setDesiredLanguage(lng);
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase("-translatortest")) continue;
                TranslationFactory.setDesiredLanguage(args[i + 1]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void runMain(final String[] args) {
        try {
            System.setProperty("k", "0dd0ecf7f742873d745106adea00b64a");
            try {
                LastChanceManager.getInstance().setLogger(LogController.getInstance().getLogger("LastChanceManager"));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            new Thread("Last Chance"){

                @Override
                public void run() {
                    try {
                        boolean selfTest = Arrays.asList(args).contains("-selftest");
                        LastChanceManager.getInstance().setSelfTest(selfTest);
                        if (selfTest) {
                            Thread.sleep(15000L);
                        } else {
                            Thread.sleep(60000L);
                        }
                        if (!selfTest) {
                            try {
                                if (!JsonConfig.create(UpdateSettings.class).isAutoUpdateCheckEnabled() && !JsonConfig.create(LastChanceSettings.class).isBackgroundLastChanceEnabled()) {
                                    LoggerFactory.getDefaultLogger().info("AutoUpdateCheck and BackgroundLastChance are both disabled!");
                                    return;
                                }
                            }
                            catch (Throwable e) {
                                LoggerFactory.getDefaultLogger().log(e);
                            }
                        }
                        LastChanceManager.getInstance().run();
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
            }.start();
            System.setProperty("classloader_00000000", "org.jdownloader.update.launcher.ClassLoaderExtensionImpl");
            if (Application.isJared(SecondLevelLauncher.class)) {
                String jarname = Application.getJarName(SecondLevelLauncher.class);
                if ("JDownloader.jar".equalsIgnoreCase(jarname)) {
                    new Thread(){

                        @Override
                        public void run() {
                            this.replace("Updater.jar");
                            this.replace("jdupdate.jar");
                            if (!CrossSystem.isWindows()) {
                                this.replace("JDUpdate.jar");
                                this.replace("jdUpdate.jar");
                            }
                        }

                        protected void replace(String file) {
                            try {
                                File res = Application.getResource(file);
                                if (res.exists() && res.delete()) {
                                    IO.copyFile(Application.getResource("JDownloader.jar"), res);
                                }
                            }
                            catch (Throwable e) {
                                if (LOGGER != null) {
                                    LOGGER.log(e);
                                }
                                e.printStackTrace();
                            }
                        }
                    }.start();
                } else {
                    ProcessBuilderFactory.create(CrossSystem.getJavaBinary(), "-jar", "JDownloader.jar", "-forceupdate").start();
                    System.exit(0);
                }
            }
            SecondLevelLauncher.init(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                LoggerFactory.getDefaultLogger().log(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                DialogHook.showExceptionDialog(2320, "Exception occured", "An unexpected error occured.\r\nJDownloader will try to fix this. If this happens again, please contact our support.", e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LastChanceManager.getInstance().run();
            ShutdownController.getInstance().requestShutdown();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String[] args) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, InterruptedException {
        Thread timeout = null;
        Dialog.getInstance().setLafManager(LAFManager.getInstance());
        SecondLevelLauncher.checkLanguageSwitch(args);
        try {
            String d3d;
            if (CrossSystem.isWindows() && ((d3d = System.getProperty("sun.java2d.d3d")) == null || StringUtils.equalsIgnoreCase(d3d, "false"))) {
                System.setProperty("sun.java2d.d3d", "false");
                System.setProperty("sun.awt.nopixfmt", "true");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        LOGGER = LogController.getInstance().getLogger(SecondLevelLauncher.class.getName());
        try {
            Application.printSystemProperties(LOGGER, Arrays.asList("env_MYJD_USER", "env_MYJD_PASSWORD", "env_JD_PASSWORD", "env_JD_EMAIL"));
        }
        catch (Throwable e) {
            Application.printSystemProperties(LOGGER);
        }
        LOGGER.info("Args: " + Arrays.toString(args));
        long t = System.currentTimeMillis();
        ParameterParser pp = RestartController.getInstance().getParameterParser(args);
        LOGGER.info("Restart Controller init done in " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        LOGGER.info("Parse Arguments");
        pp.parse((File)null);
        File appRoot = new File(Application.getHome());
        if (!pp.hasCommandSwitch("selftest") && appRoot.getPath().matches(".+[/\\\\]tmp[/\\\\]update[/\\\\]self[/\\\\]JDU$")) {
            pp.getMap().put("selftest", new CommandSwitch("selftest", new String[0]));
        }
        LOGGER.info("Parameter Parse done in " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        LOGGER.info("Single Instance Controller");
        UpdateClient.PROCESS_IS_SELFTEST = pp.hasCommandSwitch("selftest");
        SingleInstanceController singleInstance = null;
        if (!pp.hasCommandSwitch("n") && !pp.hasCommandSwitch("selftest")) {
            singleInstance = new SingleInstanceController();
            try {
                String[] stringArray;
                singleInstance.setForwardMessageDirectIfNoOtherInstanceIsFound(false);
                ResponseAdapter responseAdapter = new ResponseAdapter(){

                    @Override
                    public void onReceivedResponse(Response r) {
                        LOGGER.info("Received Response from existing instance: " + r);
                    }

                    @Override
                    public void onConnected(String[] message) {
                        LOGGER.info("existing jD instance found!");
                        LOGGER.info("Send parameters to existing jD instance and exit: " + Arrays.toString(message));
                    }
                };
                if (args.length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "--focus";
                } else {
                    stringArray = args;
                }
                singleInstance.start(responseAdapter, stringArray);
            }
            catch (AnotherInstanceRunningException e) {
                LOGGER.log(e);
                System.exit(1);
            }
            catch (SingleAppInstance.ErrorReadingResponseException e) {
                LOGGER.log(e);
            }
            catch (Exception e) {
                LOGGER.log(e);
                LOGGER.info("Instance Handling not possible!");
            }
        }
        LOGGER.info("Single Instance init done in " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        if (!pp.hasCommandSwitch("selftest")) {
            SecondLevelLauncher.checkHSErrFiles();
            String name = "JDownloader.jar";
            if (Application.isJared(null)) {
                name = Application.getJarName(SecondLevelLauncher.class);
            }
            if (!"JDownloader.jar".equals(name)) {
                if (Application.isHeadless()) {
                    ConsoleDialog cd = new ConsoleDialog("Error");
                    cd.start();
                    cd.printLines("Please make sure that JDownloader.jar is written correctly. Bad Name: " + name);
                    try {
                        cd.waitYesOrNo(16, "ok", "cancel");
                    }
                    catch (DialogCanceledException e) {
                        e.printStackTrace();
                    }
                    catch (DialogClosedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        cd.end();
                    }
                    System.exit(1);
                } else {
                    try {
                        Dialog.getInstance().showConfirmDialog(16, _AWU.T.DIALOG_ERROR_TITLE(), "Please make sure that JDownloader.jar is written correctly. Bad Name: " + name, AWUTheme.I().getIcon(Dialog.ICON_ERROR, 32), null, null);
                    }
                    catch (DialogClosedException e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                    catch (DialogCanceledException e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                    System.exit(1);
                }
            }
        }
        LOGGER.info("Init UpdateManager");
        t = System.currentTimeMillis();
        final UpdateSettings setup = JsonConfig.create(UpdateSettings.class);
        UPDATE_MANAGER = new UpdateManager(setup, !pp.hasCommandSwitch("selftest") && pp.hasCommandSwitch(UPDATE_ON_EXIT));
        LOGGER.info("Update Manager init done in " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        UPDATE_MANAGER.setRestartEnabled(!pp.hasCommandSwitch("norestart"));
        boolean runUpdate = false;
        if (pp.hasCommandSwitch("forceupdate")) {
            runUpdate = true;
            UPDATE_MANAGER.setForceUpdateFlag(true);
        }
        if (Application.isHeadless() && Application.isJared(null)) {
            runUpdate = true;
        }
        if (pp.hasCommandSwitch("selftest")) {
            new Thread("LastChanceSelfTest"){

                @Override
                public void run() {
                    LastChanceManager.getInstance().run();
                }
            }.start();
            SecondLevelLauncher.startSelfTestKiller();
        }
        if (pp.hasCommandSwitch("selfupdateerror")) {
            DialogHook.showErrorDialog(0, "Selfupdate Error", pp.getCommandSwitch("selfupdateerror").getParameters().length > 0 ? pp.getCommandSwitch("selfupdateerror").getParameters()[0] : "");
        }
        if (pp.hasCommandSwitch("afterupdate")) {
            try {
                UPDATE_MANAGER.onSelfUpdateSuccessful();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        final long startTime = System.currentTimeMillis();
        if (!pp.hasCommandSwitch("selftest") && !runUpdate) {
            UPDATE_MANAGER.finish(pp.hasCommandSwitch("update") || pp.hasCommandSwitch("afterupdate") || UPDATE_MANAGER.isUpdateOnExitFlag());
            LOGGER.info("Finished Installation");
        }
        if (UPDATE_MANAGER.isUpdateOnExitFlag()) {
            ShutdownController.getInstance().requestShutdown(new ForcedShutdown());
        }
        UPDATE_MANAGER.setUpdateOnExitFlag(false);
        if (pp.hasCommandSwitch("selftest")) {
            LOGGER.info("Run Selftest");
            String relPath = pp.getCommandSwitch("selftest").getParameters()[0];
            File root = new File(pp.getCommandSwitch("selftest").getParameters()[1]);
            new SelfTest(UPDATE_MANAGER, root, relPath).run();
            ShutdownController.getInstance().requestShutdown(new SmartRlyExitRequest());
            System.exit(1);
        }
        if (pp.hasCommandSwitch("install")) {
            runUpdate = true;
            UPDATE_MANAGER.installExtension(pp.getCommandSwitch("install").getParameters());
        }
        if (pp.hasCommandSwitch("remove")) {
            runUpdate = true;
            UPDATE_MANAGER.uninstallExtension(pp.getCommandSwitch("remove").getParameters());
        }
        if (runUpdate) {
            if (!UPDATE_MANAGER.isForceUpdateFlag()) {
                UPDATE_MANAGER.setGuiVisible(true, true);
            }
            UPDATE_MANAGER.runUpdateCheck(true);
            UPDATE_MANAGER.waitForUpdate();
            if (pp.hasCommandSwitch("exitafterupdate") || UPDATE_MANAGER.isUpdateOnExitFlag()) {
                ShutdownController.getInstance().requestShutdown(new ForcedShutdown());
            }
        }
        if (!Application.isHeadless()) {
            for (InstallLog l : UPDATE_MANAGER.getInstallLogs()) {
                if (l == null) continue;
                for (String s : l.getModifiedRestartRequiredFiles()) {
                    if (!s.startsWith("JD: libs/laf/") && !s.startsWith("libs/laf/")) continue;
                    RestartController.getInstance().directRestart(new ForcedRestartRequest(new String[0]));
                }
            }
        }
        try {
            timeout = new Thread("Timeouter"){

                @Override
                public void run() {
                    try {
                        if (setup.isAutoUpdateCheckEnabled()) {
                            long timeToWait = 90000L;
                            Thread.sleep(timeToWait);
                            if (UPDATE_MANAGER.getLatestUpdateCheck() < startTime) {
                                LOGGER.info("RUN Startupcheck");
                                UPDATE_MANAGER.runUpdateCheck(false);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
            };
            if (Application.isJared(null)) {
                timeout.start();
            }
            UPDATE_MANAGER.setLaunchState(LaunchState.LAUNCHING_JD);
            if (pp.hasCommandSwitch("debug_launchfail")) {
                throw new Exception("Debug");
            }
            SecondLevelLauncher.launchJDownloader(setup, args, singleInstance);
            UPDATE_MANAGER.setLaunchState(LaunchState.JD_RUNNING);
            UPDATE_MANAGER.setHandler(UpdateController.getInstance());
            UpdateController.getInstance().setHandler(UPDATE_MANAGER, UPDATE_MANAGER.getSettings(), UPDATE_MANAGER.getClientSetup().getApplicationIdentifier(), "JDU");
            SecondLevelLauncher.updateUninstallerCode();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                if (timeout != null) {
                    timeout.interrupt();
                }
            }
            catch (Throwable ie) {
                ie.printStackTrace();
            }
            try {
                if (UPDATE_MANAGER != null) {
                    LoggerFactory.getDefaultLogger().log(e);
                    UPDATE_MANAGER.setGuiVisible(true, true);
                    UPDATE_MANAGER.runUpdateCheck(true);
                    UPDATE_MANAGER.waitForUpdate();
                }
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            try {
                ExceptionDialog dialog = new ExceptionDialog(2320, "Exception occured", "An unexpected error occured during JDownloader Startup.\r\nPlease contact our Support for more information.", e, null, null);
                Dialog.getInstance().showDialog(dialog);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LastChanceManager.getInstance().run();
            ShutdownController.getInstance().requestShutdown();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUninstallerCode() throws InterruptedException {
        block15: {
            File file = Application.getResource(".install4j/user.jar");
            try {
                if (!file.isFile() || Application.getResource(".install4j/user/JDownloader.jar").exists()) break block15;
                boolean isNew = false;
                boolean isOldUserJar = false;
                JarFile f = new JarFile(file);
                try {
                    isNew = f.getEntry("version29122020.txt") != null;
                    isOldUserJar = f.getEntry("org/appwork/install4j/WebLogger.class") != null;
                }
                finally {
                    f.close();
                }
                if (isNew || !isOldUserJar) break block15;
                LoggerFactory.getDefaultLogger().info("Fix Uninstaller");
                String path = "resources/install4j/user-install4j-before29122020.jar";
                URL url = Application.getRessourceURL("resources/install4j/user-install4j-before29122020.jar", true);
                if (url == null) {
                    throw new FileNotFoundException("resources/install4j/user-install4j-before29122020.jar missing");
                }
                File tmp = null;
                while ((tmp = new File(file.getAbsoluteFile() + ".tmp." + System.currentTimeMillis())) == null || tmp.isFile()) {
                }
                File result = null;
                while ((result = new File(file.getAbsoluteFile() + ".result." + System.currentTimeMillis())) == null || result.isFile()) {
                }
                try {
                    FileOutputStream fos = new FileOutputStream(tmp);
                    try {
                        IO.readStreamToOutputStream(-1, url.openStream(), fos, true);
                    }
                    finally {
                        fos.close();
                    }
                    JarDeltaMerge merge = new JarDeltaMerge(tmp, file, result);
                    merge.mergeJarDelta(UPDATE_MANAGER.getClient());
                    UPDATE_MANAGER.getClient().getFileSystem().moveFile(result, file, true);
                }
                finally {
                    tmp.delete();
                    result.delete();
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private static void checkHSErrFiles() {
        try {
            File root = Application.getTemp().getParentFile();
            File[] errFiles = root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("hs_err_pid") && pathname.getName().endsWith(".log");
                }
            });
            if (errFiles != null && errFiles.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (File f : errFiles) {
                    try {
                        long now = System.currentTimeMillis();
                        long age = System.currentTimeMillis() - f.lastModified();
                        if (age > 2592000000L && errFiles.length > 3) {
                            f.renameTo(Application.getResource("logs/" + f.getName() + "." + now));
                            continue;
                        }
                        String str = IO.readFileToString(f);
                        LOGGER.severe(str);
                        if (StringUtils.isNotEmpty(str) && !Application.isHeadless()) {
                            sb.append(str);
                        }
                        f.renameTo(Application.getResource("logs/" + f.getName() + "." + now));
                    }
                    catch (IOException e) {
                        LOGGER.log(e);
                    }
                }
                if (sb.length() > 0) {
                    try {
                        ExceptionDialog dialog = new ExceptionDialog(2064, "JDownloader crashed", "It seems that JDownloader crashed and did not terminate correctly.\r\nPlease contact our Support and forward the following details", new Exception(""), null, null){

                            @Override
                            protected Window getDesiredRootFrame() {
                                for (Window w : Window.getWindows()) {
                                    if (!(w instanceof UpdateGui) || !w.isVisible()) continue;
                                    return w;
                                }
                                return null;
                            }
                        };
                        dialog.setExpanded(true);
                        dialog.setMore(sb.toString());
                        sb = null;
                        Dialog.getInstance().showDialog(dialog);
                    }
                    catch (DialogNoAnswerException e) {
                        LOGGER.log(e);
                    }
                }
            }
        }
        catch (Exception ignore) {
            LOGGER.log(ignore);
        }
    }

    private static void startSelfTestKiller() {
        Thread observer = new Thread("SelfTestKiller"){

            @Override
            public void run() {
                try {
                    Thread.sleep(300000L);
                    System.out.println("Leave after 5 minutes. Test Failed");
                    ShutdownController.getInstance().requestShutdown(true);
                    System.exit(1);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        observer.setDaemon(true);
        observer.start();
    }

    private static void launchJDownloader(UpdateSettings setup, String[] args, SingleInstanceController singleInstance) throws JDLauncherFailedException {
        try {
            try {
                String uid = null;
                File uidFile = Application.getResource("cfg/uid");
                if (uidFile.exists()) {
                    uid = IO.readFileToTrimmedString(uidFile);
                }
                if (uid == null || StringUtils.isEmpty(uid)) {
                    uid = "fb_" + System.currentTimeMillis() + "_" + Math.random() * (double)System.currentTimeMillis();
                    uid = null;
                    IO.writeStringToFile(uidFile, uid);
                }
                System.setProperty(new String(new byte[]{117, 105, 100}, new String(new byte[]{85, 84, 70, 45, 56}, "UTF-8")), uid);
            }
            catch (Throwable uid) {
                // empty catch block
            }
            StandaloneLauncher.launchJDownloader(args, singleInstance);
        }
        catch (IncompatibleClassChangeError e) {
            LOGGER.log(e);
            try {
                LOGGER.info("Delete versioninfo");
                Files.deleteRecursiv(Application.getResource("update/versioninfo/"));
            }
            catch (IOException uidFile) {
                // empty catch block
            }
            throw new JDLauncherFailedException(e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                SecondLevelLauncher.checkJar("Core.jar");
                SecondLevelLauncher.checkJar("extensions/Extraction.jar");
                SecondLevelLauncher.checkJar("JDownloader.jar");
                SecondLevelLauncher.checkJar("libs/bcprov-jdk15on.jar");
                SecondLevelLauncher.checkJar("libs/cons.jar");
                SecondLevelLauncher.checkJar("libs/Dynamics.jar");
                SecondLevelLauncher.checkJar("libs/Filters.jar");
                SecondLevelLauncher.checkJar("libs/image4j.jar");
                SecondLevelLauncher.checkJar("libs/JAntiCaptcha.jar");
                SecondLevelLauncher.checkJar("libs/JDGUI.jar");
                SecondLevelLauncher.checkJar("libs/JDHttp.jar");
                SecondLevelLauncher.checkJar("libs/JDUtils.jar");
                SecondLevelLauncher.checkJar("libs/jna.jar");
                SecondLevelLauncher.checkJar("libs/js.jar");
                SecondLevelLauncher.checkJar("libs/laf/synthetica.jar");
                SecondLevelLauncher.checkJar("libs/laf/syntheticaSimple2D.jar");
                SecondLevelLauncher.checkJar("libs/sevenzipjbinding.jar");
            }
            catch (Exception e2) {
                LOGGER.log(e2);
                try {
                    LOGGER.info("Delete versioninfo");
                    Files.deleteRecursiv(Application.getResource("update/versioninfo/"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LOGGER.log(e);
            throw new JDLauncherFailedException(e);
        }
    }

    private static void checkJar(String string) throws Exception {
        if (!Application.getResource(string).exists()) {
            throw new Exception("Missing: " + string);
        }
        if (CrossSystem.isWindows() && Application.getResource(string).lastModified() < new Date(113, 0, 28).getTime()) {
            throw new Exception("OLD: " + string);
        }
    }

    static {
        File file;
        if (System.getProperty("org.appwork.LoggerFactory") == null) {
            System.setProperty("org.appwork.LoggerFactory", LogSourceRedirector.class.getName());
        }
        if (System.getProperty("java.net.preferIPv6Addresses") == null) {
            System.setProperty("java.net.preferIPv6Addresses", "system");
        }
        Application.setApplication(".jd_home");
        String root = Application.getRoot(SecondLevelLauncher.class);
        LogV3.info("Application Root: " + root);
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        try {
            ByPassEntropyBlock.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AWUTheme.I().setNameSpace("org/jdownloader/");
        ShutdownController.getInstance().setLogger(LogController.getInstance().getLogger(ShutdownController.class.getName()));
        if (System.getProperty("syserr") != null) {
            file = new File(System.getProperty("syserr"));
            Application.PauseableOutputStream stream = Application.ERR_OUT;
            Application.addStreamCopy(file, stream);
        }
        if (System.getProperty("sysout") != null) {
            file = new File(System.getProperty("sysout"));
            Application.addStreamCopy(file, Application.STD_OUT);
        }
    }
}

