/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jdownloader.logging.LogController;

public class JUndoManager {
    public static void addUndoRedo(JTextComponent area) {
        final UndoManager undo = new UndoManager();
        area.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        AbstractAction undo_action = new AbstractAction(){
            private static final long serialVersionUID = -1151050746658519934L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException e) {
                    LogController.CL().log((Throwable)e);
                }
            }
        };
        AbstractAction redo_action = new AbstractAction(){
            private static final long serialVersionUID = 7373087464871959970L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException e) {
                    LogController.CL().log((Throwable)e);
                }
            }
        };
        area.getActionMap().put("Undo", undo_action);
        area.getInputMap().put(KeyStroke.getKeyStroke(90, 2), "Undo");
        area.getActionMap().put("Redo", redo_action);
        area.getInputMap().put(KeyStroke.getKeyStroke(89, 2), "Redo");
    }
}

