/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.linkbutton;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jd.gui.swing.components.JDUnderlinedText;
import jd.gui.swing.components.linkbutton.JLinkButtonEditor;
import jd.gui.swing.components.linkbutton.JLinkButtonRenderer;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.Eventsender;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.logging.LogController;

public class JLink
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final int CLICKED = 0;
    private URL url;
    private JDUnderlinedText mouseListener;
    private transient Eventsender<ActionListener, DefaultEvent> broadcaster;

    public static JLinkButtonEditor getJLinkButtonEditor() {
        return new JLinkButtonEditor();
    }

    public static JLinkButtonRenderer getJLinkButtonRenderer() {
        return new JLinkButtonRenderer();
    }

    public JLink() {
        this(null, null, null);
    }

    public JLink(Icon icon) {
        this(null, icon, null);
    }

    public JLink(Icon icon, URL url) {
        this(null, icon, url);
    }

    public JLink(String s) {
        this(s, null, null);
    }

    public JLink(String text, String urlstr) {
        super(text);
        URL url = null;
        try {
            url = new URL(urlstr);
        }
        catch (Exception e) {
            this.setEnabled(false);
        }
        this.init(text, url);
    }

    public JLink(String s, URL url) {
        this(s, null, url);
    }

    public JLink(URL url) {
        this(null, null, url);
    }

    public JLink(String text, Icon icon, URL url) {
        super(text);
        this.setIcon(icon);
        this.init(text, url);
    }

    private void initBroadcaster() {
        this.broadcaster = new Eventsender<ActionListener, DefaultEvent>(){

            protected void fireEvent(ActionListener listener, DefaultEvent event) {
                listener.actionPerformed(new ActionEvent(JLink.this, 0, JLink.this.getText()));
            }
        };
    }

    public Eventsender<ActionListener, DefaultEvent> getBroadcaster() {
        if (this.broadcaster == null) {
            this.initBroadcaster();
        }
        return this.broadcaster;
    }

    private void init(String text, URL url) {
        if (url == null && text != null) {
            if (text.matches("https?://.*")) {
                try {
                    url = new URL(text);
                }
                catch (MalformedURLException e1) {
                    LogController.CL().log((Throwable)e1);
                }
            } else if (text.matches("www\\..*?\\..*")) {
                try {
                    url = new URL("http://" + text);
                }
                catch (MalformedURLException e1) {
                    LogController.CL().log((Throwable)e1);
                }
            }
        }
        if (text == null && url != null) {
            this.setText(url.toExternalForm());
        }
        this.setUrl(url);
        this.setBackground(null);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.mouseListener = new JDUnderlinedText(this);
        this.addMouseListener(this.mouseListener);
        this.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (JLink.this.getUrl() != null) {
                        CrossSystem.openURL((URL)JLink.this.getUrl());
                    }
                    JLink.this.getBroadcaster().fireEvent(null);
                }
                catch (Exception e1) {
                    LogController.CL().log((Throwable)e1);
                }
            }
        });
    }

    public void removeMouseListener() {
        this.removeMouseListener(this.mouseListener);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
        if (url != null) {
            this.setToolTipText(url.toExternalForm());
        } else {
            this.setToolTipText(null);
        }
    }

    public static HyperlinkListener getHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    CrossSystem.openURL((URL)e.getURL());
                }
            }
        };
    }
}

