/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jd.SecondLevelLaunch;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.gui.swing.Factory;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.JDGui;
import jd.nutils.io.JDIO;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.os.ContainerRuntime;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.Flatpak;
import org.appwork.utils.os.Snap;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.gui.notify.BasicNotify;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;

public class AboutDialog
extends AbstractDialog<Integer> {
    private int labelHeight = 0;
    private static String JNA_VERSION_STRING = null;
    private static Double BC_VERSION = null;

    public AboutDialog() {
        super(280, _GUI.T.jd_gui_swing_components_AboutDialog_title(), null, null, null);
    }

    protected Integer createReturnValue() {
        return null;
    }

    protected boolean isResizable() {
        return true;
    }

    public static Thread showNonBlocking() {
        Thread thread = new Thread("AboutDialog"){
            {
                this.setName("AboutDialog");
                this.setDaemon(true);
            }

            @Override
            public void run() {
                AboutDialog aboutDialog = (AboutDialog)((Object)new EDTHelper<AboutDialog>(){

                    public AboutDialog edtRun() {
                        AboutDialog ret = new AboutDialog();
                        ret.setModalityType(Dialog.ModalityType.MODELESS);
                        return ret;
                    }
                }.getReturnValue());
                try {
                    Dialog.getInstance().showDialog((AbstractDialog)aboutDialog);
                }
                catch (DialogNoAnswerException dialogNoAnswerException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    public static void main(String[] args) throws Exception {
        Application.setApplication((String)".jd_home");
        AboutDialog.showNonBlocking().join();
    }

    public JComponent layoutDialogContent() {
        SVGFactory svgFactory;
        this.labelHeight = new JLabel((String)"HeightTester").getPreferredSize().height;
        JPanel contentpane = new JPanel();
        JLabel lbl = new JLabel("JDownloader\u00ae 2", 0);
        lbl.setFont(lbl.getFont().deriveFont((float)lbl.getFont().getSize() * 2.0f));
        JPanel links1stRow = new JPanel((LayoutManager)new MigLayout("ins 0", "[]push[]push[]push[]"));
        JPanel links2ndRow = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]push[]push"));
        try {
            final File file = Application.getResource((String)"licenses/jdownloader.license");
            if (file.isFile()) {
                JButton btn = Factory.createButton(_GUI.T.jd_gui_swing_components_AboutDialog_license(), (Icon)new AbstractIcon("premium", 16), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String license = JDIO.readFileToString((File)file);
                        try {
                            ConfirmDialog d = new ConfirmDialog(336, _GUI.T.jd_gui_swing_components_AboutDialog_license_title(), license, null, null, null){

                                protected boolean isResizable() {
                                    return true;
                                }
                            };
                            d.setPreferredSize(JDGui.getInstance().getMainFrame().getSize());
                            Dialog.getInstance().showDialog((AbstractDialog)d);
                        }
                        catch (DialogNoAnswerException dialogNoAnswerException) {
                            // empty catch block
                        }
                    }
                });
                btn.setBorder(null);
                links2ndRow.add(btn);
            }
            links1stRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_homepage(), (Icon)new AbstractIcon("home", 16), new URL("https://jdownloader.org/home")));
            links1stRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_forum(), (Icon)new AbstractIcon("board", 16), new URL("https://board.jdownloader.org/")));
            links1stRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_ticket(), (Icon)new AbstractIcon("board", 16), new URL("https://support.jdownloader.org/")));
            links1stRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_uninstall(), (Icon)new AbstractIcon("clear", 16), new URL("https://support.jdownloader.org/Knowledgebase/Article/View/how-can-i-uninstall-jdownloader")));
            links2ndRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_contributers(), (Icon)new AbstractIcon("edit", 16), new URL("https://support.jdownloader.org/Knowledgebase/Article/View/setup-ide-eclipse")));
            links2ndRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_imprint(), (Icon)new AbstractIcon("about", 16), new URL("https://jdownloader.org/impressum")));
            links2ndRow.add(new JLink(_GUI.T.jd_gui_swing_components_AboutDialog_privacy(), (Icon)new AbstractIcon("about", 16), new URL("https://my.jdownloader.org/legal/privacy.html#jdownloader")));
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        contentpane.setLayout((LayoutManager)new MigLayout("ins 10, wrap 1", "[grow,fill]"));
        contentpane.add((Component)new JLabel((Icon)new AbstractIcon("logo/jd_logo_64_64", -1)), "aligny center, spany 6");
        contentpane.add((Component)lbl, "");
        MigPanel stats = new MigPanel("ins 0,wrap 2", "[][grow,align right]", "[]");
        contentpane.add((Component)stats, "pushx,growx,spanx");
        Map map = null;
        try {
            stats.add((Component)this.createLink(_GUI.T.jd_gui_swing_components_AboutDialog_trademark(), "https://jdownloader.org/impressum"), (Object)"spanx,alignx center");
            try {
                File buildJson = Application.getResource((String)"build.json");
                if (buildJson.isFile()) {
                    map = (Map)JSonStorage.restoreFromString((String)IO.readFileToString((File)buildJson), (TypeRef)TypeRef.HASHMAP);
                }
            }
            catch (Exception e) {
                LoggerFactory.getDefaultLogger().log((Throwable)e);
            }
            if (map != null) {
                stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_builddate()));
                stats.add((Component)this.createLink(map.get("buildDate")));
            }
            stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_runtime()));
            stats.add((Component)this.createLink(TimeFormatter.formatMilliSeconds((long)(Time.systemIndependentCurrentJVMTimeMillis() - SecondLevelLaunch.startup), (int)0)));
            try {
                stats.add((Component)new JLabel("Java:"), (Object)"");
                MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                ExtButton comp = this.createLink(System.getProperty("java.vendor") + " - " + System.getProperty("java.runtime.name") + " - " + System.getProperty("java.version") + (JavaVersion.getVersion().isLTS() ? "(LTS/" : "(") + (Application.is64BitJvm() ? "64bit/" : "32bit/") + CrossSystem.getARCHFamily() + ")");
                stats.add((Component)comp);
                comp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CrossSystem.showInExplorer((File)new File(CrossSystem.getJavaBinary()));
                        try {
                            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                            List<String> arguments = runtimeMxBean.getInputArguments();
                            StringBuilder sb = new StringBuilder();
                            for (String s : arguments) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append(s);
                            }
                            StringSelection selection = new StringSelection(sb.toString());
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(selection, selection);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                try {
                    RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                    List<String> arguments = runtimeMxBean.getInputArguments();
                    StringBuilder sb = new StringBuilder();
                    for (String s : arguments) {
                        if (sb.length() > 0) {
                            sb.append("\r\n");
                        }
                        sb.append(s);
                    }
                    comp.setToolTipText(sb.toString());
                }
                catch (Throwable e1) {
                    LoggerFactory.getDefaultLogger().log(e1);
                }
                stats.add((Component)new JLabel("OS:"), (Object)"");
                stats.add((Component)this.createLink(CrossSystem.getOSFamily() + "(" + CrossSystem.getOS() + ")" + (CrossSystem.is64BitOperatingSystem() ? "(64bit)" : "(32bit)")));
                stats.add((Component)new JLabel("Memory:"), (Object)"");
                long used = memory.getUsed();
                long committed = memory.getCommitted();
                long max = memory.getMax();
                long minimumWarningLevel = max / 100L * 20L;
                if (max - used < minimumWarningLevel) {
                    comp = this.createLink("Usage: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)used) + " - Allocated: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)committed) + " - Max: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)max), "https://support.jdownloader.org/Knowledgebase/Article/View/troubleshooting-jdownloader-is-slow");
                    stats.add((Component)comp);
                    long minimumRedWarning = max / 100L * 10L;
                    if (max - used < minimumRedWarning) {
                        comp.setForeground(Color.RED);
                    } else {
                        comp.setForeground(Color.ORANGE.darker());
                    }
                } else {
                    comp = this.createLink("Usage: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)used) + " - Allocated: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)committed) + " - Max: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)max), "https://support.jdownloader.org/Knowledgebase/Article/View/vmoptions-file");
                    stats.add((Component)comp);
                }
                try {
                    List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
                    StringBuilder sb = new StringBuilder();
                    for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                        if (sb.length() > 0) {
                            sb.append("\r\n");
                        }
                        sb.append("Pool:").append(memoryPoolMXBean.getName()).append("\r\n");
                        sb.append("Type:").append((Object)memoryPoolMXBean.getType()).append("\r\n");
                        sb.append("Managed by:").append(Arrays.toString(memoryPoolMXBean.getMemoryManagerNames())).append("\r\n");
                        MemoryUsage collectionUsage = memoryPoolMXBean.getCollectionUsage();
                        if (collectionUsage != null) {
                            sb.append("Usage: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)collectionUsage.getUsed()) + " - Allocated: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)collectionUsage.getCommitted()) + " - Max: " + SizeFormatter.formatBytes((NumberFormat)NumberFormat.getInstance(Locale.ROOT), (long)collectionUsage.getMax()));
                        }
                        sb.append("\r\n");
                    }
                    comp.setToolTipText(sb.toString());
                }
                catch (Throwable e1) {
                    LoggerFactory.getDefaultLogger().log(e1);
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_installdir()), (Object)"");
            final File directory = Application.getResource((String)".");
            final String fullPath = "<html><u>" + directory + "</u></html>";
            final String anonPath = "<html><u>" + _GUI.T.jd_gui_swing_components_AboutDialog_installdir_anon() + "</u></html>";
            ExtButton bt = this.createLink(anonPath);
            stats.add((Component)bt);
            final ExtButton directoryButton = bt;
            bt.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    directoryButton.setText(anonPath);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    directoryButton.setText(fullPath);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            bt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CrossSystem.openFile((File)directory);
                }
            });
            JLabel envLabel = new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_environment());
            if (HardwareType.getHardware() != null) {
                if (envLabel != null) {
                    stats.add((Component)envLabel, (Object)"spanx");
                    envLabel = null;
                }
                stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_hardware()), (Object)"gapleft 10");
                stats.add((Component)this.createLink(HardwareType.getHardware().toString()));
            }
            if (Snap.isInsideSnap()) {
                if (envLabel != null) {
                    stats.add((Component)envLabel, (Object)"spanx");
                    envLabel = null;
                }
                stats.add((Component)new JLabel("Snap:"), (Object)"gapleft 10");
                stats.add((Component)this.createLink(Snap.getSnapInstanceName()));
            }
            if (Flatpak.isInsideFlatpak()) {
                if (envLabel != null) {
                    stats.add((Component)envLabel, (Object)"spanx");
                    envLabel = null;
                }
                stats.add((Component)new JLabel("Flatpak:"), (Object)"gapleft 10");
                stats.add((Component)this.createLink(Flatpak.getInstanceName()));
            }
            if (ContainerRuntime.isInsideContainer()) {
                if (envLabel != null) {
                    stats.add((Component)envLabel, (Object)"spanx");
                    envLabel = null;
                }
                stats.add((Component)new JLabel(ContainerRuntime.getType() + ":"), (Object)"gapleft 10");
                stats.add((Component)this.createLink(ContainerRuntime.getID()));
            }
            if (map != null) {
                stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_sourcerevisions()), (Object)"spanx");
                if (map.containsKey("JDownloaderRevision")) {
                    stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_core()), (Object)"gapleft 10");
                    stats.add((Component)this.createLink("#" + map.get("JDownloaderRevision"), "https://svn.jdownloader.org/build.php?check=" + map.get("JDownloaderRevision")));
                }
                if (map.containsKey("JDownloaderUpdaterRevision")) {
                    stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_launcher()), (Object)"gapleft 10");
                    stats.add((Component)this.createLink("#" + map.get("JDownloaderUpdaterRevision")));
                }
                if (map.containsKey("AppWorkUtilsRevision")) {
                    stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_appworkutilities()), (Object)"gapleft 10");
                    stats.add((Component)this.createLink("#" + map.get("AppWorkUtilsRevision")));
                }
                if (map.containsKey("JDBrowserRevision")) {
                    stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_browser()), (Object)"gapleft 10");
                    stats.add((Component)this.createLink("#" + map.get("JDBrowserRevision")));
                }
                if (map.containsKey("UpdateClientV2Revision")) {
                    stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_updater()), (Object)"gapleft 10");
                    stats.add((Component)this.createLink("#" + map.get("UpdateClientV2Revision")));
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().log(t);
        }
        int year = this.getCopyrightYear();
        lbl = new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_mopdules());
        contentpane.add((Component)lbl, "gaptop 5, spanx");
        stats = new MigPanel("ins 0 10 0 0,wrap 2", "[][grow,align right]", "[]");
        contentpane.add((Component)stats, "pushx,growx,spanx");
        stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_core()), (Object)"");
        stats.add((Component)this.createLink("Copyright \u00a9 2009-" + year + " AppWork GmbH"));
        stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_plugins()), (Object)"");
        stats.add((Component)this.createLink("Copyright \u00a9 2009-" + year + " JDownloader Community"));
        stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_translations()), (Object)"");
        stats.add((Component)this.createLink("Copyright \u00a9 2009-" + year + " JDownloader Community"));
        try {
            if (JNA_VERSION_STRING == null) {
                Class<?> clazz = Class.forName("com.sun.jna.Native");
                Field version = ReflectionUtils.getField((String)"com.sun.jna.Version", (String)"VERSION", clazz, String.class);
                Field versionNative = ReflectionUtils.getField((String)"com.sun.jna.Version", (String)"VERSION_NATIVE", clazz, String.class);
                String jnaVersion = (String)version.get(clazz);
                String jnaNativeVersion = (String)versionNative.get(clazz);
                JNA_VERSION_STRING = jnaVersion + "/" + jnaNativeVersion;
            }
            stats.add((Component)new JLabel("Java Native Access:"), (Object)"");
            stats.add((Component)this.createLink("JNA " + JNA_VERSION_STRING, "https://github.com/java-native-access/jna"));
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        try {
            SSLSocketStreamFactory ssl = HTTPConnectionImpl.getDefaultSSLSocketStreamFactory();
            if (!(ssl instanceof JavaSSLSocketStreamFactory)) {
                if (BC_VERSION == null) {
                    BC_VERSION = new BouncyCastleProvider().getVersion();
                }
                stats.add((Component)new JLabel("TLS:"), (Object)"");
                stats.add((Component)this.createLink("BouncyCastle " + BC_VERSION, "https://www.bouncycastle.org/releasenotes.html#r" + String.valueOf(BC_VERSION).replace(".", "rv")));
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        if ("SIMPLEUPNP".equals(ReconnectPluginController.getInstance().getActivePlugin().getID())) {
            stats.add((Component)new JLabel("UPNP:"), (Object)"");
            stats.add((Component)this.createLink("Cling", "https://github.com/4thline/cling"));
        }
        stats.add((Component)new JLabel("Extraction:"));
        JPanel extraction = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 2"));
        extraction.add((Component)this.createLink("7ZipJBindings (" + this.get7ZipJBindingDetails() + ")", "https://github.com/borisbrodski/sevenzipjbinding"));
        extraction.add((Component)this.createLink("Zip4J 1.3.3", "https://github.com/srikanth-lingala/zip4j"));
        stats.add((Component)extraction);
        ExtButton ffmpegLink = this.createLink("Loading.....please wait", "https://ffmpeg.org/");
        stats.add((Component)new JLabel("FFmpeg:"), (Object)"");
        stats.add((Component)ffmpegLink);
        this.loadFFmpegDetailsAsync(ffmpegLink);
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null) {
            stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_laf()), (Object)"");
            if (StringUtils.containsIgnoreCase((String)laf.getID(), (String)"FlatLaf")) {
                stats.add((Component)this.createLink(laf.getName(), "https://www.formdev.com/flatlaf/"));
            } else if (StringUtils.containsIgnoreCase((String)laf.getID(), (String)"Synthetica")) {
                stats.add((Component)this.createLink(laf.getName(), "https://www.jyloo.com/synthetica/"));
                try {
                    String version = ReflectionUtils.invoke(laf.getClass(), (String)"getSyntheticaVersion", (Object)laf, Class.forName("de.javasoft.util.IVersion"), (Object[])new Object[0]).toString();
                    stats.add((Component)this.createLink(version, "https://www.jyloo.com/synthetica/changelog/"), (Object)"skip");
                }
                catch (Throwable version) {
                    // empty catch block
                }
                try {
                    Object info = UIManager.get("Synthetica.license.info");
                    if (info instanceof String[]) {
                        String license = StringUtils.join(Arrays.asList((String[])info), (String)"\r");
                        String Licensee = new Regex(license, "Licensee\\s*=\\s*([^\r\n]+)").getMatch(0);
                        String LicenseRegistrationNumber = new Regex(license, "LicenseRegistrationNumber\\s*=\\s*([^\r\n]+)").getMatch(0);
                        stats.add((Component)this.createLink(_GUI.T.jd_gui_swing_components_AboutDialog_synthetica2(Licensee + "(#" + LicenseRegistrationNumber + ")"), "https://www.jyloo.com/synthetica/license/"), (Object)"skip");
                    }
                }
                catch (Throwable info) {}
            } else if (StringUtils.containsIgnoreCase((String)laf.getID(), (String)"Substance")) {
                stats.add((Component)this.createLink(laf.getName(), "https://github.com/kirill-grouchnikov/radiance"));
            } else {
                stats.add((Component)this.createLink(laf.getName(), ""));
            }
        }
        if ((svgFactory = IconIO.getSvgFactory()) != null && svgFactory.isSupported()) {
            String name = svgFactory.getClass().getSimpleName();
            if ("KitFoxFactory".equals(name)) {
                stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_svg()), (Object)"");
                stats.add((Component)this.createLink("svgSalamander", "https://github.com/blackears/svgSalamander"));
            } else if ("WeisjJSVGFactory".equals(name)) {
                stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_svg()), (Object)"");
                stats.add((Component)this.createLink("jsvg", "https://github.com/weisJ/jsvg"));
            }
        }
        stats.add((Component)new JLabel(_GUI.T.jd_gui_swing_components_AboutDialog_icons()), (Object)"");
        stats.add((Component)this.createLink("See /themes/* folder for Icon Licenses"), (Object)"");
        JPanel icons = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 3", "[grow,fill]", ""));
        icons.add((Component)this.createLink("Icons8", "https://icons8.com"));
        icons.add((Component)this.createLink("Tango Icons", "https://en.wikipedia.org/wiki/Tango_Desktop_Project"));
        icons.add((Component)this.createLink("FatCow-Farm Fresh Icons", "https://www.fatcow.com/free-icons"));
        icons.add((Component)this.createLink("Mimi Glyphs Set", "http://salleedesign.com/blog/mimi-glyphs/"));
        icons.add((Component)this.createLink("Bright Mix Set", "http://brightmix.com/blog/brightmix-icon-set-free-for-all/"));
        icons.add((Component)this.createLink("Picol Icon Set", "http://www.picol.org/"));
        icons.add((Component)this.createLink("Aha Soft Icon Set", "http://www.aha-soft.com"));
        icons.add((Component)this.createLink("Oxygen Team", "https://techbase.kde.org/Projects/Oxygen/Licensing"));
        icons.add((Component)this.createLink("further icons by AppWork GmbH"), "skip 2");
        icons.add((Component)this.createLink("& the JDownloader Community"));
        contentpane.add(icons);
        contentpane.add((Component)links1stRow, "gaptop 5, growx, pushx, spanx");
        contentpane.add((Component)links2ndRow, "growx, pushx, spanx");
        this.registerEscape(contentpane);
        if (this.isResizable()) {
            JScrollPane scrollPane = new JScrollPane(contentpane);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(20);
            return scrollPane;
        }
        return contentpane;
    }

    private void loadFFmpegDetailsAsync(final ExtButton ffmpegLink) {
        Thread thread = new Thread("FFmpegVersionLoader"){

            @Override
            public void run() {
                String version = "not available";
                try {
                    FFmpeg ffmpeg = new FFmpeg(null){

                        public LogInterface getLogger() {
                            return LogController.getFastPluginLogger((String)"ffmpeg");
                        }
                    };
                    if (ffmpeg.isAvailable()) {
                        String v = ffmpeg.getVersionString();
                        version = v != null ? v : "unknown version";
                    }
                }
                catch (Throwable ffmpeg) {
                    // empty catch block
                }
                final String finalVersion = version;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ffmpegLink.setText("<html><u>" + finalVersion + "</u></html>");
                        AboutDialog.this.pack();
                    }
                });
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private int getCopyrightYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int year = calendar.get(1);
        return Math.max(2025, year);
    }

    private String get7ZipJBindingDetails() {
        String version = "4.65";
        try {
            version = (String)ReflectionUtils.invoke((String)"net.sf.sevenzipjbinding.SevenZip", (String)"getSevenZipJBindingVersion", null, String.class, (Object[])new Object[0]);
            String usedPlatform = (String)ReflectionUtils.invoke((String)"net.sf.sevenzipjbinding.SevenZip", (String)"getUsedPlatform", null, String.class, (Object[])new Object[0]);
            if (usedPlatform != null) {
                return version + "/" + usedPlatform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    private ExtButton createLink(final Object object, final String url) {
        ExtButton ret = new ExtButton((AbstractAction)new AppAction(){
            private static final long serialVersionUID = 2L;
            {
                if (StringUtils.startsWithCaseInsensitive((String)url, (String)"http") && CrossSystem.isOpenBrowserSupported()) {
                    this.setName("<html><u>" + object + "</u></html>");
                } else {
                    this.setName(String.valueOf(object));
                }
            }

            public void actionPerformed(ActionEvent e) {
                ClipboardMonitoring.getINSTANCE().setCurrentContent(this.getName());
                if (url != null && url.matches("(?i)https?://.+") && CrossSystem.isOpenBrowserSupported()) {
                    CrossSystem.openURL((String)url);
                } else {
                    BubbleNotify.getInstance().show(new BubbleNotify.AbstractNotifyWindowFactory(){

                        public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                            return new BasicNotify(_GUI.T.lit_clipboard(), _GUI.T.AboutDialog_actionPerformed_clipboard_(this.getName()), (Icon)new AbstractIcon("clipboard", 20));
                        }
                    });
                }
            }
        });
        ret.setBorderPainted(false);
        ret.setContentAreaFilled(false);
        ret.setEnabled(true);
        ret.setMaximumSize(new Dimension(1000, this.labelHeight));
        return ret;
    }

    private ExtButton createLink(Object object) {
        return this.createLink(object, null);
    }
}

