/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Component;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtIconColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.Log;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class HosterChooserTableModel
extends ExtTableModel<LazyHostPlugin> {
    private static final long serialVersionUID = 1L;
    private List<LazyHostPlugin> allPlugins;
    private String text;

    public HosterChooserTableModel(List<LazyHostPlugin> plugins) {
        super("HosterChooserTableModel");
        this.allPlugins = plugins;
    }

    protected int[] guessSelectedRows(List<LazyHostPlugin> oldTableData, int leadIndex, int anchorIndex, BitSet selectedRowsBitSet) {
        return new int[]{0};
    }

    public void _fireTableStructureChanged(List<LazyHostPlugin> newtableData, boolean refreshSort) {
        String ltext = this.text;
        if (!StringUtils.isEmpty((String)ltext)) {
            try {
                String p = this.toRegex(ltext);
                Pattern pattern = Pattern.compile(p, 2);
                Iterator<LazyHostPlugin> it = newtableData.iterator();
                block2: while (it.hasNext()) {
                    LazyHostPlugin next = it.next();
                    if (pattern.matcher(this.clean(next.getHost())).find()) continue;
                    LazyPlugin.FEATURE[] features = next.getFeatures();
                    if (features != null) {
                        for (LazyPlugin.FEATURE f : features) {
                            if (!f.isInternal() && pattern.matcher(this.clean(f.getLabel())).find()) continue block2;
                        }
                    }
                    it.remove();
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        super._fireTableStructureChanged(newtableData, refreshSort);
    }

    public List<LazyHostPlugin> getSelectedObjects(int maxItems, BitSet selectedRows) {
        List ltableData;
        List ret = super.getSelectedObjects(maxItems, selectedRows);
        if ((ret == null || ret.size() == 0) && (ltableData = this.getTableData()) != null && ltableData.size() > 0) {
            ArrayList<LazyHostPlugin> ret2 = new ArrayList<LazyHostPlugin>();
            ret2.add((LazyHostPlugin)ltableData.get(0));
            return ret2;
        }
        return ret;
    }

    public List<LazyHostPlugin> sort(List<LazyHostPlugin> data, ExtColumn<LazyHostPlugin> column) {
        if (StringUtils.isEmpty((String)this.text)) {
            Comparator<LazyHostPlugin> compar = new Comparator<LazyHostPlugin>(){

                @Override
                public int compare(LazyHostPlugin o1, LazyHostPlugin o2) {
                    return o1.getHost().compareToIgnoreCase(o2.getHost());
                }
            };
            Collections.sort(data, compar);
            return data;
        }
        final Pattern patternStarts = Pattern.compile("^" + this.toRegex(this.text) + ".*$", 2);
        Comparator<LazyHostPlugin> compar = new Comparator<LazyHostPlugin>(){

            @Override
            public int compare(LazyHostPlugin o1, LazyHostPlugin o2) {
                int ret = CompareUtils.compareBoolean((boolean)patternStarts.matcher(HosterChooserTableModel.this.clean(o2.getHost())).matches(), (boolean)patternStarts.matcher(HosterChooserTableModel.this.clean(o1.getHost())).matches());
                if (ret == 0) {
                    ret = o1.getHost().compareToIgnoreCase(o2.getHost());
                }
                return ret;
            }
        };
        Collections.sort(data, compar);
        return data;
    }

    protected String toRegex(String text) {
        return this.clean(text).replaceAll("\\W", ".*");
    }

    public void refresh(String filterText) {
        this.text = this.clean(filterText);
        this._fireTableStructureChanged(new ArrayList<LazyHostPlugin>(this.allPlugins), true);
    }

    private String clean(String text) {
        if (text == null) {
            return "";
        }
        return text.toLowerCase(Locale.ENGLISH).replaceAll("\\W", "").replace("z", "s").replace("b", "p").replace("y", "i").replace("j", "i");
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtIconColumn<LazyHostPlugin>(_GUI.T.HosterChooserTableModel_column_icon()){

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                    private static final long serialVersionUID = 3938290423337000265L;

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon((Icon)new AbstractIcon("image", 16));
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        this.setToolTipText(_GUI.T.HosterChooserTableModel_column_icon());
                        return this;
                    }
                };
                return ret;
            }

            public boolean isResizable() {
                return false;
            }

            public boolean isSortable(LazyHostPlugin obj) {
                return false;
            }

            protected boolean isDefaultResizable() {
                return false;
            }

            protected Icon getIcon(LazyHostPlugin value) {
                return value.getDomainInfo().getFavIcon(false);
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<LazyHostPlugin>(_GUI.T.HosterChooserTableModel_column_domain()){

            public boolean isHidable() {
                return false;
            }

            public boolean isSortable(LazyHostPlugin obj) {
                return false;
            }

            public String getStringValue(LazyHostPlugin value) {
                return value.getDisplayName();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<LazyHostPlugin>(_GUI.T.HosterChooserTableModel_column_features()){

            public boolean isHidable() {
                return false;
            }

            public boolean isSortable(LazyHostPlugin obj) {
                return false;
            }

            protected String getTooltipText(LazyHostPlugin value) {
                StringBuilder sb = new StringBuilder();
                LazyPlugin.FEATURE[] features = value.getFeatures();
                if (features != null) {
                    for (LazyPlugin.FEATURE f : features) {
                        if (f.isInternal()) continue;
                        if (sb.length() > 0) {
                            sb.append("\r\n");
                        }
                        sb.append(f.getTooltip());
                    }
                }
                return sb.toString();
            }

            public String getStringValue(LazyHostPlugin value) {
                StringBuilder sb = new StringBuilder();
                LazyPlugin.FEATURE[] features = value.getFeatures();
                if (features != null) {
                    for (LazyPlugin.FEATURE f : features) {
                        if (f.isInternal()) continue;
                        if (sb.length() > 0) {
                            sb.append("; ");
                        }
                        sb.append(f.getLabel());
                    }
                }
                return sb.toString();
            }
        });
    }
}

