/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthTableUI;
import jd.gui.swing.jdgui.AlternateHighlighter;
import jd.gui.swing.jdgui.LockAllColumnsAction;
import jd.gui.swing.jdgui.TriStateSorterTableModel;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class BasicJDTable<T>
extends ExtTable<T>
implements GenericConfigEventListener<Integer> {
    private static final long serialVersionUID = -9181860215412270250L;
    protected int mouseOverRow = -1;
    private Color sortNotifyColor;
    protected final boolean overwriteHorizontalLinesPossible;
    private boolean showHorizontalLineBelowLastEntry = true;
    private boolean noRepaint = false;

    public BasicJDTable(ExtTableModel<T> tableModel) {
        super(tableModel);
        TableUI lui;
        this.setShowVerticalLines(true);
        this.setShowGrid(true);
        this.setShowHorizontalLinesWithoutRepaint(true);
        this.setSelectionMode(2);
        this.sortNotifyColor = CFG_GUI.SORT_COLUMN_HIGHLIGHT_ENABLED.isEnabled() ? LAFOptions.getInstance().getColorForTableSortedColumnView() : null;
        this.setBackground(LAFOptions.getInstance().getColorForPanelBackground());
        this.addSelectionHighlighter();
        if (CFG_GUI.TABLE_MOUSE_OVER_HIGHLIGHT_ENABLED.isEnabled()) {
            this.initMouseOverRowHighlighter();
        }
        this.initRowHeight();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.initAlternateRowHighlighter();
        this.overwriteHorizontalLinesPossible = Application.getJavaVersion() < Application.JAVA17 ? false : (lui = this.getUI()) != null && lui instanceof SynthTableUI;
        Color col = LAFOptions.getInstance().getColorForTableRowGap();
        if (col != null) {
            this.setGridColor(col);
        }
    }

    protected void showPopup(final JPopupMenu popup, final Point p) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                popup.show((Component)((Object)BasicJDTable.this), p.x, p.y);
            }
        });
    }

    protected void addSelectionHighlighter() {
        this.getModel().addExtComponentRowHighlighter(new ExtComponentRowHighlighter<T>(LAFOptions.getInstance().getColorForTableSelectedRowsForeground(), LAFOptions.getInstance().getColorForTableSelectedRowsBackground(), null){

            public boolean accept(ExtColumn<T> column, T value, boolean selected, boolean focus, int row) {
                return selected;
            }

            public int getPriority() {
                return Integer.MAX_VALUE;
            }
        });
    }

    protected JPopupMenu columnControlMenu(ExtColumn<T> extColumn) {
        JPopupMenu popup = super.columnControlMenu(extColumn);
        if (this.getModel().getTable().isColumnLockingFeatureEnabled()) {
            popup.add(new JMenuItem((Action)((Object)new LockAllColumnsAction(this))));
        }
        return popup;
    }

    protected void initAlternateRowHighlighter() {
        BooleanKeyHandler enabled = LAFOptions.TABLE_ALTERNATE_ROW_HIGHLIGHT_ENABLED;
        if (enabled != null && enabled.isEnabled()) {
            this.getModel().addExtComponentRowHighlighter(new AlternateHighlighter(LAFOptions.getInstance().getColorForTableAlternateRowForeground(), LAFOptions.getInstance().getColorForTableAlternateRowBackground(), null));
        }
    }

    protected void initMouseOverRowHighlighter() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int newRow = BasicJDTable.this.getRowIndexByPoint(e.getPoint());
                int oldRow = -1;
                if (newRow != BasicJDTable.this.mouseOverRow) {
                    oldRow = BasicJDTable.this.mouseOverRow;
                    BasicJDTable.this.mouseOverRow = newRow;
                    if (oldRow >= 0) {
                        this.repaintRow(oldRow);
                    }
                    if (BasicJDTable.this.mouseOverRow >= 0) {
                        this.repaintRow(BasicJDTable.this.mouseOverRow);
                    }
                }
            }

            protected void repaintRow(int newRow) {
                Rectangle rect = BasicJDTable.this.getCellRect(newRow, 0, true);
                rect.width = BasicJDTable.this.getWidth();
                BasicJDTable.this.repaint(rect.x, rect.y, rect.width, rect.height);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                int newRow = -1;
                int oldRow = -1;
                oldRow = BasicJDTable.this.mouseOverRow;
                BasicJDTable.this.mouseOverRow = newRow;
                if (oldRow >= 0) {
                    this.repaintRow(oldRow);
                }
            }

            protected void repaintRow(int newRow) {
                Rectangle rect = BasicJDTable.this.getCellRect(newRow, 0, true);
                rect.width = BasicJDTable.this.getWidth();
                BasicJDTable.this.repaint(rect.x, rect.y, rect.width, rect.height);
            }
        });
        Color f = LAFOptions.getInstance().getColorForTableMouseOverRowForeground();
        Color b = LAFOptions.getInstance().getColorForTableMouseOverRowBackground();
        this.getModel().addExtComponentRowHighlighter(new ExtComponentRowHighlighter<T>(f, b, null){

            public boolean accept(ExtColumn<T> column, T value, boolean selected, boolean focus, int row) {
                return BasicJDTable.this.mouseOverRow == row || BasicJDTable.this.getCellEditor() != null && BasicJDTable.this.editingRow == row;
            }

            protected Color getBackground(Color current) {
                return super.getBackground(current);
            }

            public int getPriority() {
                return 0x7FFFFFFE;
            }
        });
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        return super.editCellAt(row, column, e);
    }

    protected void initRowHeight() {
        this.setRowHeight(this.calculateAutoRowHeight());
    }

    protected int calculateAutoRowHeight() {
        ExtTextColumn<String> col = new ExtTextColumn<String>("Test"){

            public String getStringValue(String value) {
                return "Test";
            }
        };
        JComponent rend = col.getRendererComponent((Object)"Test", true, true, 1, 1);
        col.configureRendererComponent((Object)"T\u00a7gj\u00b2*", true, true, 1, 1);
        int prefHeight = rend.getPreferredSize().height;
        IntegerKeyHandler customRowHeight = LAFOptions.CUSTOM_TABLE_ROW_HEIGHT;
        Integer custom = null;
        if (customRowHeight != null) {
            custom = (Integer)customRowHeight.getValue();
            customRowHeight.getEventSender().addListener((EventListener)((Object)this), true);
        }
        if (custom != null && custom > 0) {
            return custom;
        }
        return prefHeight + 3;
    }

    public boolean isOriginalOrder() {
        return this.getModel().getSortColumn() == null;
    }

    public boolean isResizeableColumns() {
        return true;
    }

    public boolean isShowHorizontalLineBelowLastEntry() {
        return this.showHorizontalLineBelowLastEntry;
    }

    public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                BasicJDTable.this.initRowHeight();
                BasicJDTable.this.repaint();
            }
        };
    }

    public boolean getShowHorizontalLines() {
        return true;
    }

    public Color getGridColor() {
        return super.getGridColor();
    }

    public void paintComponent(Graphics g) {
        if (!this.overwriteHorizontalLinesPossible || this.isShowHorizontalLineBelowLastEntry()) {
            super.paintComponent(g);
        } else {
            boolean before = this.getShowHorizontalLines();
            try {
                if (!this.isShowHorizontalLineBelowLastEntry()) {
                    this.setShowHorizontalLinesWithoutRepaint(false);
                }
                super.paintComponent(g);
            }
            finally {
                this.setShowHorizontalLinesWithoutRepaint(before);
            }
            if (before && !this.isShowHorizontalLineBelowLastEntry()) {
                g.setColor(this.getGridColor());
                TableUI lui = this.getUI();
                if (lui instanceof SynthTableUI) {
                    SynthContext context = ((SynthTableUI)lui).getContext((JComponent)((Object)this));
                    int rMin = 0;
                    int cMin = 0;
                    Rectangle minCell = this.getCellRect(rMin, cMin, true);
                    int rMax = this.getRowCount() - 1;
                    int cMax = this.getColumnCount() - 1;
                    Rectangle maxCell = this.getCellRect(rMax, cMax, true);
                    Rectangle damagedArea = minCell.union(maxCell);
                    SynthGraphicsUtils synthG = context.getStyle().getGraphicsUtils(context);
                    int tableWidth = damagedArea.x + damagedArea.width;
                    int y = damagedArea.y;
                    for (int row = rMin; row <= rMax - 1; ++row) {
                        synthG.drawLine(context, "Table.grid", g, damagedArea.x, (y += this.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                    }
                }
            }
        }
        if (this.getModel() instanceof TriStateSorterTableModel) {
            ExtColumn sortColumn = this.getModel().getSortColumn();
            int filteredColumn = -1;
            if (this.sortNotifyColor != null && sortColumn != null) {
                filteredColumn = sortColumn.getIndex();
            }
            Graphics2D g2 = (Graphics2D)g;
            Composite comp = g2.getComposite();
            Rectangle visibleRect = this.getVisibleRect();
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            if (filteredColumn >= 0) {
                Rectangle first = this.getCellRect(0, filteredColumn, true);
                int w = this.getModel().getSortColumn().getWidth() - Math.max(0, visibleRect.x - first.x);
                if (w > 0) {
                    g2.setColor(this.sortNotifyColor);
                    g2.fillRect(Math.max(first.x, visibleRect.x), visibleRect.y, w, visibleRect.height);
                }
            }
            g2.setComposite(comp);
        }
    }

    public void repaint() {
        if (this.noRepaint) {
            return;
        }
        super.repaint();
    }

    public void setShowHorizontalLineBelowLastEntry(boolean showHorizontalLineBelowLastEntry) {
        this.showHorizontalLineBelowLastEntry = showHorizontalLineBelowLastEntry;
    }

    private void setShowHorizontalLinesWithoutRepaint(boolean b) {
        this.noRepaint = true;
        try {
            this.setShowHorizontalLines(b);
        }
        finally {
            this.noRepaint = false;
        }
    }
}

