/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.appwork.app.gui.ActiveDialogException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.swing.ExtJFrame;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.FrameStatus;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class JDownloaderMainFrame
extends ExtJFrame {
    private FrameStatus latestNormalState;
    private LogSource logger;
    private DelayedRunnable delayedStateSaver;
    private static final long serialVersionUID = -4218493713632551975L;
    private volatile boolean dialogShowing = false;
    private FrameStatus latestFrameStatus;

    public JDownloaderMainFrame(String string, LogSource logger) {
        super(string);
        this.logger = logger;
        this.delayedStateSaver = new DelayedRunnable(250L, 1000L){

            public void resetAndStart() {
                super.resetAndStart();
            }

            public String getID() {
                return "AddLinksDialog";
            }

            public void delayedrun() {
                JDownloaderMainFrame.this.updateFrameStatus();
            }
        };
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                JDownloaderMainFrame.this.delayedStateSaver.resetAndStart();
            }
        });
    }

    public FrameStatus getLatestNormalState() {
        return this.latestNormalState;
    }

    public void setLatestNormalState(FrameStatus latestNormalState) {
        this.latestNormalState = latestNormalState;
    }

    public void setSize(Dimension d) {
        super.setSize(d);
    }

    public void setSize(int width, int height) {
        System.out.println("Set Frame size: " + width + "x" + height);
        super.setSize(width, height);
    }

    public Point getLocation() {
        return super.getLocation();
    }

    public Point getLocation(Point rv) {
        return super.getLocation(rv);
    }

    public Point getLocationOnScreen() {
        return super.getLocationOnScreen();
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
    }

    public void dispose() {
        super.dispose();
    }

    public void setExtendedState(int i) {
        super.setExtendedState(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean b) {
        if (b && !this.isVisible() && CFG_GUI.PASSWORD_PROTECTION_ENABLED.isEnabled() && !StringUtils.isEmpty((String)CFG_GUI.PASSWORD.getValue())) {
            if (this.dialogShowing) {
                return;
            }
            try {
                this.dialogShowing = true;
                String password = Dialog.getInstance().showInputDialog(512, _GUI.T.JDGui_setVisible_password_(), _GUI.T.JDGui_setVisible_password_msg(), null, (Icon)new AbstractIcon("lock", 32), null, null);
                String internPw = CFG_GUI.PASSWORD.getValue();
                if (!internPw.equals(password)) {
                    Dialog.getInstance().showMessageDialog(_GUI.T.JDGui_setVisible_password_wrong());
                    return;
                }
            }
            catch (DialogNoAnswerException e) {
                return;
            }
            finally {
                this.dialogShowing = false;
            }
        }
        if (!b) {
            for (Window w : this.getOwnedWindows()) {
                if (!(w instanceof JDialog)) continue;
                boolean mod = ((JDialog)w).isModal();
                boolean v = w.isVisible();
                if (!mod || !v) continue;
                Toolkit.getDefaultToolkit().beep();
                this.logger.log((Throwable)new ActiveDialogException((JDialog)w));
                WindowManager.getInstance().setZState(w, WindowManager.FrameState.TO_FRONT_FOCUSED);
                return;
            }
        }
        super.setVisible(b);
    }

    public FrameStatus getLatestFrameStatus() {
        return this.latestFrameStatus;
    }

    public void setLatestFrameStatus(FrameStatus latestFrameStatus) {
        this.latestFrameStatus = latestFrameStatus;
    }

    public void toFront() {
        if (!this.isVisible()) {
            return;
        }
        super.toFront();
    }

    private void updateFrameStatus() {
        FrameStatus newState = FrameStatus.create((JFrame)((Object)this), (FrameStatus)this.latestFrameStatus);
        if (newState != null && newState.isLocationSet()) {
            this.latestFrameStatus = newState;
            if (newState.getExtendedState() == FrameStatus.ExtendedState.NORMAL) {
                this.latestNormalState = newState.clone();
                System.out.println("New Window State (Normal): " + JSonStorage.toString((Object)this.latestFrameStatus));
            } else {
                System.out.println("New Window State: " + JSonStorage.toString((Object)this.latestFrameStatus));
            }
        }
    }
}

