/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.borders;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class InsideShadowBorder
extends AbstractBorder {
    private static final long serialVersionUID = -2197110609454639482L;
    private final Insets insets;
    private Insets borderInsets;

    public InsideShadowBorder(int top, int left, int bottom, int right) {
        this.insets = new Insets(top, left, bottom, right);
        this.borderInsets = new Insets(0, 0, 0, 0);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public void setBorderInsets(int top, int left, int bottom, int right) {
        this.borderInsets = new Insets(top, left, bottom, right);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        AlphaComposite alpha;
        int i;
        Graphics2D g2D = (Graphics2D)g;
        Composite composite = g2D.getComposite();
        g2D.setColor(new Color(0, 16, 0));
        float alphaValue = 0.4f;
        for (i = 0; i < this.insets.top; ++i) {
            alpha = AlphaComposite.getInstance(3, alphaValue);
            g2D.setComposite(alpha);
            g.drawLine(x + Math.min(this.insets.left, i) + this.borderInsets.left, y + i + this.borderInsets.top, x + w - Math.min(this.insets.left, i) - Math.min(this.insets.right, i) - this.borderInsets.right, y + i + this.borderInsets.top);
            alphaValue -= alphaValue / 2.0f;
        }
        g2D.setColor(new Color(0, 16, 0));
        alphaValue = 0.4f;
        for (i = 0; i < this.insets.bottom; ++i) {
            alpha = AlphaComposite.getInstance(3, alphaValue);
            g2D.setComposite(alpha);
            g.drawLine(x + Math.min(this.insets.left, i) + this.borderInsets.left, y + h - i - 1 - this.borderInsets.bottom, x + w - Math.min(this.insets.left, i) - this.borderInsets.right - Math.min(this.insets.right, i), y + h - i - 1 - this.borderInsets.bottom);
            alphaValue -= alphaValue / 2.0f;
        }
        g2D.setColor(new Color(0, 16, 0));
        alphaValue = 0.4f;
        for (i = 0; i < this.insets.right; ++i) {
            alpha = AlphaComposite.getInstance(3, alphaValue);
            g2D.setComposite(alpha);
            g.drawLine(w - i - 1 - this.borderInsets.right, y + Math.min(this.insets.top, i) + this.borderInsets.top, w - i - 1 - this.borderInsets.right, y + h - Math.min(this.insets.top, i) - Math.min(this.insets.bottom, i) - this.borderInsets.bottom);
            alphaValue -= alphaValue / 2.0f;
        }
        g2D.setColor(new Color(0, 16, 0));
        alphaValue = 0.4f;
        for (i = 0; i < this.insets.left; ++i) {
            alpha = AlphaComposite.getInstance(3, alphaValue);
            g2D.setComposite(alpha);
            g.drawLine(x + i + this.borderInsets.left, y + Math.min(this.insets.top, i) + this.borderInsets.top, x + i + this.borderInsets.left, y + h - Math.min(this.insets.top, i) - Math.min(this.insets.bottom, i) - this.borderInsets.bottom);
            alphaValue -= alphaValue / 2.0f;
        }
        g2D.setComposite(composite);
    }
}

