/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import jd.gui.swing.jdgui.components.StatusBarImpl;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class JobLinkCrawlerIndicator
extends IconedProcessIndicator
implements ActionListener {
    private static final long serialVersionUID = -7267364376253248300L;
    private final WeakReference<LinkCollector.JobLinkCrawler> jobLinkCrawler;
    private final StatusBarImpl statusBar;
    private final Timer timer;
    private final int countDownMax = 5;
    private int countDown = 5;

    private static String getIconKey(LinkCollectingJob job) {
        LinkOrigin origin = job.getOrigin().getOrigin();
        if (origin != null) {
            switch (origin) {
                case CLIPBOARD: {
                    return "clipboard";
                }
                case ADD_CONTAINER_ACTION: 
                case DOWNLOADED_CONTAINER: {
                    return "addContainer";
                }
                case CNL: {
                    return "logo/cnl";
                }
                case MYJD: {
                    return "logo/myjdownloader";
                }
                case ADD_LINKS_DIALOG: 
                case DRAG_DROP_ACTION: {
                    return "add";
                }
            }
            return "linkgrabber";
        }
        return "linkgrabber";
    }

    public JobLinkCrawlerIndicator(StatusBarImpl statusBar, LinkCollector.JobLinkCrawler jobLinkCrawler) {
        super((Icon)new AbstractIcon(JobLinkCrawlerIndicator.getIconKey(jobLinkCrawler.getJob()), 16));
        this.statusBar = statusBar;
        this.jobLinkCrawler = new WeakReference<LinkCollector.JobLinkCrawler>(jobLinkCrawler);
        this.setTitle(_GUI.T.StatusBarImpl_initGUI_linkgrabber());
        this.setDescription(_GUI.T.StatusBarImpl_initGUI_linkgrabber_desc_inactive());
        this.setEnabled(true);
        this.timer = new Timer(1000, this);
        if (jobLinkCrawler.isRunning()) {
            statusBar.addProcessIndicator((JComponent)((Object)this));
            this.timer.start();
        }
    }

    private LinkCollector.JobLinkCrawler getCrawler() {
        return (LinkCollector.JobLinkCrawler)this.jobLinkCrawler.get();
    }

    private void update() {
        LinkCollector.JobLinkCrawler jobLinkCrawler = this.getCrawler();
        if (jobLinkCrawler != null && jobLinkCrawler.isRunning()) {
            this.countDown = 5;
            if (!this.isIndeterminate()) {
                this.setIndeterminate(true);
            }
            this.setDescription(_GUI.T.LinkCrawlerBubbleContent_update_runnning());
        } else if (jobLinkCrawler != null && jobLinkCrawler.getLinkChecker().isRunning()) {
            this.countDown = 5;
            if (!this.isIndeterminate()) {
                this.setIndeterminate(true);
            }
            this.setDescription(_GUI.T.LinkCrawlerBubbleContent_update_online());
        } else if (jobLinkCrawler != null && jobLinkCrawler.hasWaitingInQueue()) {
            this.countDown = 5;
            if (!this.isIndeterminate()) {
                this.setIndeterminate(true);
            }
            this.setDescription(_GUI.T.LinkCrawlerBubbleContent_update_processing());
        } else {
            if (this.isIndeterminate()) {
                this.setIndeterminate(false);
            }
            this.setDescription(_GUI.T.StatusBarImpl_initGUI_linkgrabber_desc_inactive());
            if (this.countDown-- == 0) {
                this.timer.stop();
                this.statusBar.removeProcessIndicator((JComponent)((Object)this));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add((Action)new AppAction(){
                private static final long serialVersionUID = -968768342263254431L;
                {
                    this.setIconKey("cancel");
                    this.setName(_GUI.T.StatusBarImpl_initGUI_abort_linkgrabber());
                    LinkCollector.JobLinkCrawler jobLinkCrawler = JobLinkCrawlerIndicator.this.getCrawler();
                    this.setEnabled(jobLinkCrawler != null && jobLinkCrawler.isCollecting());
                }

                public void actionPerformed(ActionEvent e) {
                    LinkCollector.JobLinkCrawler jobLinkCrawler = JobLinkCrawlerIndicator.this.getCrawler();
                    if (jobLinkCrawler != null) {
                        jobLinkCrawler.abort();
                    }
                }
            });
            popup.addSeparator();
            popup.add((Action)new AppAction(){
                private static final long serialVersionUID = -968768342263254431L;
                {
                    this.setIconKey("cancel");
                    this.setName(_GUI.T.StatusBarImpl_initGUI_abort_linkgrabber_all());
                    this.setEnabled(LinkCollector.getInstance().isCollecting());
                }

                public void actionPerformed(ActionEvent e) {
                    LinkCollector.getInstance().abort();
                }
            });
            popup.show((Component)((Object)this), e.getPoint().x, 0 - popup.getPreferredSize().height);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }
}

