/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.premiumbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jd.gui.swing.jdgui.components.premiumbar.AccountListTable;
import jd.gui.swing.jdgui.components.premiumbar.AccountListTableModel;
import jd.gui.swing.jdgui.components.premiumbar.AccountServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.AccountTooltipOwner;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountEntry;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.CaptchaType;
import jd.plugins.MultiHostHost;
import jd.plugins.PluginForHost;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.components.tooltips.PanelToolTip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.locator.AbstractLocator;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.captchasolver.abstractPluginForCaptchaSolver;
import org.jdownloader.updatev2.gui.LAFOptions;

public class AccountTooltip
extends PanelToolTip {
    private Color color;
    private AccountListTable table;
    private AccountListTableModel model;
    private AccountTooltipOwner owner;

    public Point getDesiredLocation(JComponent activeComponent, Point ttPosition) {
        if (this.owner instanceof ServicePanel) {
            ttPosition.y = activeComponent.getLocationOnScreen().y - this.getPreferredSize().height;
            ttPosition.x = activeComponent.getLocationOnScreen().x;
            return AbstractLocator.correct((Point)ttPosition, (Dimension)this.getPreferredSize());
        }
        Point mouseLocation = ToolTipController.getMouseLocation();
        if (mouseLocation != null) {
            return mouseLocation;
        }
        return ttPosition;
    }

    public AccountTooltip(AccountTooltipOwner owner, AccountServiceCollection accountCollection) {
        super(new TooltipPanel("ins 0,wrap 1", "[]", "[][][][][grow,fill]"){

            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                return pref;
            }
        });
        this.owner = owner;
        this.color = LAFOptions.getInstance().getColorForTooltipForeground();
        LinkedList<AccountEntry> domains = new LinkedList<AccountEntry>();
        for (Account acc : accountCollection) {
            domains.add(new AccountEntry(acc));
        }
        this.model = new AccountListTableModel(this, owner);
        this.table = new AccountListTable(this.model);
        this.model.setData(domains);
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (AccountTooltip.this.owner != null) {
                    AccountTooltip.this.owner.redraw();
                }
                AccountTooltip.this.table.getTableHeader().repaint();
            }
        });
        this.table.getTableHeader().setOpaque(false);
        boolean account_collection_is_multi = accountCollection.isMulti();
        boolean account_collection_is_captcha_solver = accountCollection.isCaptchaSolver();
        String txt = accountCollection.getDomainInfo().getTld();
        if (account_collection_is_multi) {
            txt = _GUI.T.AccountTooltip_AccountTooltip_multi(accountCollection.getDomainInfo().getTld());
        } else if (account_collection_is_captcha_solver) {
            txt = "Debug captcha solver account: " + accountCollection.getDomainInfo().getTld();
        }
        JLabel label = new JLabel(txt, accountCollection.getDomainInfo().getFavIcon(), 2);
        SwingUtils.toBold((JLabel)label);
        label.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        this.panel.add((Component)label, (Object)"gapleft 5,pushx,growx");
        this.panel.add((Component)this.table.getTableHeader());
        this.panel.add((Component)((Object)this.table));
        if (account_collection_is_multi) {
            this.panel.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][][][][grow,fill]"));
            label = new JLabel(_GUI.T.AccountTooltip_AccountTooltip_supported_hosters());
            SwingUtils.toBold((JLabel)label);
            label.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
            this.panel.add((Component)label);
            List<DomainInfo> dis = this.getMultihosterDomainInfos(accountCollection);
            JList<DomainInfo> list = new JList<DomainInfo>(dis.toArray(new DomainInfo[0]));
            list.setLayoutOrientation(1);
            final ListCellRenderer<DomainInfo> org = list.getCellRenderer();
            list.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DomainInfo di = (DomainInfo)value;
                    JLabel ret = (JLabel)org.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
                    ret.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
                    ret.setText(di.getTld());
                    ret.setIcon(di.getFavIcon());
                    ret.setOpaque(false);
                    ret.setBackground(null);
                    return ret;
                }
            });
            list.setVisibleRowCount(dis.size() / 5);
            list.setSelectionMode(0);
            list.setOpaque(false);
            this.panel.add(list);
        } else if (account_collection_is_captcha_solver) {
            this.panel.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][][][][grow,fill]"));
            label = new JLabel("These accounts can solve the following types of captchas:");
            SwingUtils.toBold((JLabel)label);
            label.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
            this.panel.add((Component)label);
            ArrayList dis = new ArrayList();
            for (Account acc : accountCollection) {
                abstractPluginForCaptchaSolver captchaplugin;
                List supported_captcha_types;
                PluginForHost plg = acc.getPlugin();
                if (plg == null || !(plg instanceof abstractPluginForCaptchaSolver) || (supported_captcha_types = (captchaplugin = (abstractPluginForCaptchaSolver)plg).getSupportedCaptchaTypes()) == null) continue;
                dis.addAll(supported_captcha_types);
            }
            JList<CaptchaType.CAPTCHA_TYPE> list = new JList<CaptchaType.CAPTCHA_TYPE>(dis.toArray(new CaptchaType.CAPTCHA_TYPE[0]));
            list.setLayoutOrientation(1);
            final ListCellRenderer org = list.getCellRenderer();
            list.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    CaptchaType.CAPTCHA_TYPE ctype = (CaptchaType.CAPTCHA_TYPE)value;
                    JLabel ret = (JLabel)org.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
                    ret.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
                    ret.setText(ctype.getDisplayName());
                    if (ctype.getDomain() != null) {
                        ret.setIcon((Icon)DomainInfo.getInstance((String)ctype.getDomain()));
                    }
                    ret.setOpaque(false);
                    ret.setBackground(null);
                    return ret;
                }
            });
            list.setVisibleRowCount(dis.size() / 5);
            list.setSelectionMode(0);
            list.setOpaque(false);
            this.panel.add((Component)list);
        } else {
            this.panel.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][][grow,fill]"));
        }
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    private List<DomainInfo> getMultihosterDomainInfos(AccountServiceCollection accountCollection) {
        HashSet<DomainInfo> domain_infos = new HashSet<DomainInfo>();
        for (Account acc : accountCollection) {
            List supported;
            AccountInfo ai = acc.getAccountInfo();
            if (ai == null || (supported = ai.getMultiHostSupportV2()) == null) continue;
            for (MultiHostHost mhost : supported) {
                switch (mhost.getStatus()) {
                    case WORKING: 
                    case WORKING_UNSTABLE: {
                        domain_infos.add(mhost.getDomainInfo());
                        break;
                    }
                }
            }
        }
        ArrayList<DomainInfo> ret = new ArrayList<DomainInfo>(domain_infos);
        if (ret.size() < 2) {
            return ret;
        }
        Collections.sort(ret, new Comparator<DomainInfo>(){

            @Override
            public int compare(DomainInfo o1, DomainInfo o2) {
                return o1.getTld().compareToIgnoreCase(o2.getTld());
            }
        });
        return ret;
    }

    public void update() {
        this.table.getModel().fireTableStructureChanged();
    }
}

