/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.premiumbar;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jd.SecondLevelLaunch;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.gui.swing.dialog.AddAccountDialog;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.components.premiumbar.AccountServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.AccountTooltipOwner;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanelExtender;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountManagerSettings;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.MultiHostHost;
import jd.plugins.PluginForHost;
import net.miginfocom.swing.MigLayout;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.DomainInfo;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class ServicePanel
extends JPanel
implements MouseListener,
AccountTooltipOwner {
    private static final long serialVersionUID = 7290466989514173719L;
    private DelayedRunnable redrawTimer;
    private final CopyOnWriteArrayList<ServicePanelExtender> extender;
    private static ServicePanel INSTANCE = new ServicePanel();
    private AtomicBoolean redrawing = new AtomicBoolean(false);

    public static ServicePanel getInstance() {
        return INSTANCE;
    }

    public void addExtender(ServicePanelExtender ex) {
        if (!Application.isHeadless() && this.extender.addIfAbsent(ex)) {
            this.redrawTimer.delayedrun();
        }
    }

    public void requestUpdate(boolean immediately) {
        if (immediately) {
            this.redrawTimer.delayedrun();
        } else {
            this.redraw();
        }
    }

    public void removeExtender(ServicePanelExtender ex) {
        if (this.extender.remove(ex)) {
            this.redrawTimer.delayedrun();
        }
    }

    private ServicePanel() {
        super((LayoutManager)new MigLayout("ins 0 2 0", "0[]0[]0[]0[]0", "0[]0"));
        this.extender = new CopyOnWriteArrayList();
        this.setOpaque(false);
        ScheduledExecutorService scheduler = DelayedRunnable.getNewScheduledExecutorService();
        this.redrawTimer = new DelayedRunnable(scheduler, 1000L, 5000L){

            public String getID() {
                return "PremiumStatusRedraw";
            }

            public void delayedrun() {
                ServicePanel.this.redraw();
            }
        };
        this.redraw();
        CFG_GUI.PREMIUM_STATUS_BAR_DISPLAY.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

            public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
                ServicePanel.this.redraw();
            }
        });
        CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                ServicePanel.this.redraw();
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
        SecondLevelLaunch.ACCOUNTLIST_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        ServicePanel.this.redrawTimer.run();
                        AccountController.getInstance().getEventSender().addListener((EventListener)new AccountControllerListener(){

                            public void onAccountControllerEvent(AccountControllerEvent event) {
                                if (CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled()) {
                                    ServicePanel.this.redrawTimer.run();
                                }
                            }
                        });
                        ServicePanel.this.redraw();
                    }
                }.start();
            }
        });
    }

    @Override
    public void redraw() {
        if (!SecondLevelLaunch.ACCOUNTLIST_LOADED.isReached()) {
            return;
        }
        if (!this.redrawing.compareAndSet(false, true)) {
            return;
        }
        try {
            final List<ServiceCollection<?>> services = this.groupServices(CFG_GUI.CFG.getPremiumStatusBarDisplay(), true, null, null);
            new EDTHelper<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object edtRun() {
                    try {
                        try {
                            ServicePanel.this.removeAll();
                            StringBuilder sb = new StringBuilder();
                            sb.append("2");
                            for (int i = 0; i < services.size(); ++i) {
                                sb.append("[22!]0");
                            }
                            boolean hasValidAccount = false;
                            for (ServiceCollection s : services) {
                                if (!(s instanceof AccountServiceCollection)) continue;
                                hasValidAccount = true;
                                break;
                            }
                            if (!hasValidAccount) {
                                sb.append("[]0");
                            }
                            ServicePanel.this.setLayout((LayoutManager)new MigLayout("ins 0 2 0 0", sb.toString(), "[22!]"));
                            for (ServiceCollection s : services) {
                                JComponent c = s.createIconComponent(ServicePanel.this);
                                if (c == null) continue;
                                ServicePanel.this.add((Component)c, "gapleft 0,gapright 0");
                            }
                            if (!hasValidAccount && CFG_GUI.CFG.isStatusBarAddPremiumButtonVisible()) {
                                ExtButton addPremium = new ExtButton((AbstractAction)new AppAction(){
                                    {
                                        this.setName(_GUI.T.StatusBarImpl_add_premium());
                                    }

                                    public void actionPerformed(ActionEvent e) {
                                        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
                                        JDGui.getInstance().setContent(ConfigurationView.getInstance(), true);
                                        ConfigurationView.getInstance().setSelectedSubPanel(AccountManagerSettings.class);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                AddAccountDialog.showDialog(null, null);
                                            }
                                        });
                                    }
                                });
                                addPremium.setRolloverEffectEnabled(true);
                                addPremium.setHorizontalAlignment(2);
                                addPremium.setIcon((Icon)new AbstractIcon("add", 18));
                                ServicePanel.this.add((Component)addPremium, "height 20!,gapright 10!");
                            }
                            ServicePanel.this.revalidate();
                            ServicePanel.this.repaint();
                        }
                        catch (Throwable e) {
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                        ServicePanel.this.invalidate();
                    }
                    finally {
                        ServicePanel.this.redrawing.compareAndSet(true, false);
                    }
                    return null;
                }
            }.start();
        }
        catch (Throwable e) {
            this.redrawing.compareAndSet(true, false);
        }
    }

    public List<ServiceCollection<?>> groupServices(GraphicalUserInterfaceSettings.PremiumStatusBarDisplay premiumStatusBarDisplay, boolean extend, String hostFilter, Account account) {
        List accounts = AccountController.getInstance().list();
        HashMap<DomainInfo, AccountServiceCollection> servicesMap = new HashMap<DomainInfo, AccountServiceCollection>();
        ArrayList services = new ArrayList();
        try {
            Collections.sort(accounts, new Comparator<Account>(){

                @Override
                public int compare(boolean x, boolean y) {
                    return x == y ? 0 : (x ? 1 : -1);
                }

                @Override
                public int compare(Account o1, Account o2) {
                    return this.compare(o1.isMultiHost(), o2.isMultiHost());
                }
            });
        }
        catch (Throwable e) {
            LogController.CL((boolean)true).log(e);
        }
        if (account != null) {
            accounts.remove(account);
            accounts.add(0, account);
        }
        block6: for (Account account2 : accounts) {
            PluginForHost plugin;
            if (account2.getLastValidTimestamp() < 0L && account2.getError() != null) continue;
            long expireTimeMS = (long)(CFG_GUI.CFG.getPremiumStatusBarDisabledAccountExpire() * 7 * 24 * 60 * 60) * 1000L;
            long timeSinceValidLogin = System.currentTimeMillis() - account2.getLastValidTimestamp();
            boolean debug = false;
            if (account2.getLastValidTimestamp() == -1L || !account2.isEnabled() && timeSinceValidLogin > expireTimeMS || (plugin = account2.getPlugin()) == null) continue;
            DomainInfo domainInfo = DomainInfo.getInstance((String)plugin.getHost());
            String domainTld = domainInfo.getTld();
            switch (premiumStatusBarDisplay) {
                case DONT_GROUP: {
                    if (hostFilter != null && !StringUtils.equals((String)hostFilter, (String)domainTld)) break;
                    AccountServiceCollection asc = new AccountServiceCollection(domainInfo);
                    asc.add(account2);
                    services.add(asc);
                    break;
                }
                case GROUP_BY_ACCOUNT_TYPE: 
                case GROUP_BY_SUPPORTED_ACCOUNTS: 
                case GROUP_BY_SUPPORTED_HOSTS: {
                    List supportedhosts;
                    AccountInfo ai;
                    AccountServiceCollection asc;
                    if (hostFilter == null || StringUtils.equals((String)hostFilter, (String)domainTld)) {
                        asc = (AccountServiceCollection)servicesMap.get(domainInfo);
                        if (asc == null) {
                            asc = new AccountServiceCollection(domainInfo);
                            servicesMap.put(domainInfo, asc);
                            services.add(asc);
                        }
                        asc.add(account2);
                    }
                    if (GraphicalUserInterfaceSettings.PremiumStatusBarDisplay.GROUP_BY_ACCOUNT_TYPE.equals((Object)premiumStatusBarDisplay) || (ai = account2.getAccountInfo()) == null || (supportedhosts = ai.getMultiHostSupportV2()) == null) break;
                    for (MultiHostHost mhost : supportedhosts) {
                        DomainInfo multiDomainInfo = mhost.getDomainInfo();
                        if (multiDomainInfo == null || hostFilter != null && !StringUtils.equals((String)hostFilter, (String)multiDomainInfo.getTld())) continue;
                        AccountServiceCollection asc2 = (AccountServiceCollection)servicesMap.get(multiDomainInfo);
                        if (asc2 == null) {
                            asc2 = new AccountServiceCollection(multiDomainInfo);
                            servicesMap.put(multiDomainInfo, asc2);
                            services.add(asc2);
                        }
                        asc2.add(account2);
                    }
                    continue block6;
                }
            }
        }
        if (GraphicalUserInterfaceSettings.PremiumStatusBarDisplay.GROUP_BY_SUPPORTED_ACCOUNTS.equals((Object)premiumStatusBarDisplay)) {
            for (ServiceCollection serviceCollection : services) {
                ((AccountServiceCollection)serviceCollection).disableMulti();
            }
        }
        if (extend) {
            for (ServicePanelExtender servicePanelExtender : this.extender) {
                servicePanelExtender.extendServicePabel(services);
            }
        }
        Collections.sort(services);
        return services;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    static {
        if (Application.isHeadless()) {
            throw new HeadlessException();
        }
    }
}

