/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.gui.swing.components.SetIconInterface;
import jd.gui.swing.components.SetLabelInterface;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.components.speedmeter.SpeedMeterPanel;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtJToggleButton;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.views.downloads.QuickSettingsPopup;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class MainToolBar
extends JToolBar
implements MouseListener,
DownloadWatchdogListener,
GenericConfigEventListener<Boolean> {
    private static final long serialVersionUID = 922971719957349497L;
    private static MainToolBar INSTANCE = null;
    private volatile SpeedMeterPanel speedmeter;
    private JRootPane rootpane;
    private boolean initDone = false;
    private LogSource logger = LogController.getInstance().getLogger("MainToolbar");
    private HashMap<KeyStroke, Action> shortCutActions;

    public boolean isInitDone() {
        return this.initDone;
    }

    public static synchronized MainToolBar getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MainToolBar();
        }
        return INSTANCE;
    }

    private MainToolBar() {
        this.addMouseListener(this);
        this.setRollover(true);
        this.setFloatable(false);
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        MainToolBar.this.speedmeter = new SpeedMeterPanel(true, false);
                        MainToolBar.this.speedmeter.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                QuickSettingsPopup pu = new QuickSettingsPopup();
                                pu.show((Component)e.getSource(), e.getX(), e.getY());
                            }
                        });
                        CFG_GUI.SPEED_METER_VISIBLE.getEventSender().addListener((EventListener)MainToolBar.this, false);
                    }
                };
                DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)MainToolBar.this);
            }
        });
        SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        if (!MainToolBar.this.isInitDone()) {
                            MainToolBar.this.updateToolbar();
                        }
                    }
                };
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    QuickSettingsPopup pu = new QuickSettingsPopup();
                    pu.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        LAFOptions.getInstance().getExtension().customizeToolbar((JToolBar)this);
    }

    public void registerAccelerators(JDGui jdGui) {
        this.rootpane = jdGui.getMainFrame().getRootPane();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    public final void updateToolbar() {
        if (!SecondLevelLaunch.GUI_COMPLETE.isReached()) {
            return;
        }
        this.initDone = true;
        new EDTRunner(){

            protected void runInEDT() {
                MainToolBar.this.setVisible(false);
                MainToolBar.this.removeAll();
                MainToolBar.this.initToolbar();
                MainToolBar.this.updateSpecial();
                MainToolBar.this.setVisible(true);
                MainToolBar.this.revalidate();
            }
        };
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp != this.speedmeter) {
            comp.removeMouseListener(this);
            comp.addMouseListener(this);
        }
    }

    private void fillActions(MenuContainer menuData) {
        if (!menuData._isValidated()) {
            return;
        }
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        for (MenuItemData mi : menuData.getItems()) {
            if (!mi._isValidated()) {
                return;
            }
            if (mi instanceof MenuContainer) {
                this.fillActions((MenuContainer)mi);
                continue;
            }
            if (mi instanceof SeparatorData || mi instanceof MenuLink) continue;
            try {
                List moreShortCuts;
                KeyStroke keystroke;
                if (mi.getActionData() == null || !mi.getActionData()._isValidDataForCreatingAnAction()) continue;
                CustomizableAppAction action = mi.createAction();
                if (StringUtils.isNotEmpty((String)mi.getShortcut())) {
                    keystroke = KeyStroke.getKeyStroke(mi.getShortcut());
                    if (keystroke != null) {
                        action.setAccelerator(keystroke);
                    }
                } else if (MenuItemData.isEmptyValue((String)mi.getShortcut())) {
                    action.setAccelerator(null);
                }
                keystroke = (KeyStroke)action.getValue("AcceleratorKey");
                this.linkAction(input, input2, input3, actions, (AppAction)action, keystroke);
                if (!(action instanceof CustomizableAppAction) || (moreShortCuts = action.getAdditionalShortcuts(keystroke)) == null) continue;
                for (KeyStroke ks : moreShortCuts) {
                    if (ks == null) continue;
                    this.linkAction(input, input2, input3, actions, (AppAction)action, ks);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void linkAction(InputMap input, InputMap input2, InputMap input3, ActionMap actions, AppAction action, KeyStroke keystroke) {
        if (action != null && keystroke != null) {
            Object old;
            String key = "CONTEXT_ACTION_" + keystroke;
            try {
                old = input.get(keystroke);
                if (old != null && action.getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + action + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            try {
                old = input2.get(keystroke);
                if (old != null && action.getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + action + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            try {
                old = input3.get(keystroke);
                if (old != null && action.getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + action + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            this.logger.info(keystroke + " -> " + action);
            input.put(keystroke, key);
            input2.put(keystroke, key);
            input3.put(keystroke, key);
            actions.put(key, (Action)action);
            this.shortCutActions.put(keystroke, (Action)action);
        }
    }

    public void updateContextShortcuts(MenuContainerRoot container) {
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        if (this.shortCutActions != null) {
            for (Map.Entry<KeyStroke, Action> ks : this.shortCutActions.entrySet()) {
                Object binding = input.get(ks.getKey());
                input.remove(ks.getKey());
                input2.remove(ks.getKey());
                input3.remove(ks.getKey());
                actions.remove(binding);
            }
        }
        this.shortCutActions = new HashMap();
        this.fillActions((MenuContainer)container);
    }

    private void initToolbar() {
        MenuContainerRoot container = MenuManagerMainToolbar.getInstance().getMenuData();
        this.updateContextShortcuts(container);
        ArrayList list = container.getItems();
        this.setLayout((LayoutManager)new MigLayout("ins 0 3 0 0", "[]", "[grow,32!]"));
        MenuItemData last = null;
        for (final MenuItemData menudata : list) {
            Object bt = null;
            try {
                if (!menudata.isVisible()) continue;
                if (menudata instanceof SeparatorData) {
                    if (last != null && last instanceof SeparatorData) continue;
                    this.add((Component)new JSeparator(1), "gapleft 10,gapright 10,width 2!,pushy,growy");
                    last = menudata;
                    continue;
                }
                if (menudata._getValidateException() != null) continue;
                if (menudata.getType() == MenuItemData.Type.CONTAINER) {
                    bt = new ExtButton((AbstractAction)new AppAction(){
                        private ExtPopupMenu root = null;
                        {
                            this.setTooltipText(menudata.getName());
                            this.setName(menudata.getName());
                            this.putValue("SwingLargeIconKey", MainToolBar.this.createDropdownImage(MainToolBar.this.validateIconKey(menudata.getIconKey())));
                        }

                        public void actionPerformed(final ActionEvent e) {
                            ExtPopupMenu lroot = this.root;
                            if (lroot != null && lroot.isShowing()) {
                                return;
                            }
                            Object src = e.getSource();
                            if (e.getSource() instanceof Component) {
                                final ExtPopupMenu finalMenu = lroot = new ExtPopupMenu();
                                final MouseListener ml = new MouseListener(){
                                    private Timer timer;
                                    {
                                        final 1 ml = this;
                                        this.timer = new Timer(1000, new ActionListener(){

                                            @Override
                                            public void actionPerformed(ActionEvent e2) {
                                                finalMenu.setVisible(false);
                                                ((JComponent)e.getSource()).removeMouseListener(ml);
                                            }
                                        });
                                        this.timer.setRepeats(false);
                                    }

                                    @Override
                                    public void mouseClicked(MouseEvent e2) {
                                    }

                                    @Override
                                    public void mousePressed(MouseEvent e2) {
                                    }

                                    @Override
                                    public void mouseReleased(MouseEvent e2) {
                                    }

                                    @Override
                                    public void mouseEntered(MouseEvent e2) {
                                        this.timer.stop();
                                    }

                                    @Override
                                    public void mouseExited(MouseEvent e2) {
                                        this.timer.stop();
                                        this.timer.start();
                                    }
                                };
                                ((JComponent)e.getSource()).addMouseListener(ml);
                                new MenuBuilder((ContextMenuManager)MenuManagerMainToolbar.getInstance(), (JComponent)lroot, (MenuContainer)menudata){

                                    protected void addContainer(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                                        JMenu submenu = (JMenu)inst.addTo(root, (MenuBuilder)this);
                                        if (submenu == null) {
                                            return;
                                        }
                                        submenu.addMouseListener(ml);
                                        this.createLayer(submenu, (MenuContainer)inst);
                                        if (submenu.getMenuComponentCount() == 0) {
                                            root.remove(submenu);
                                        }
                                    }

                                    protected void addAction(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                                        JComponent ret = inst.addTo(root, (MenuBuilder)this);
                                        if (ret != null) {
                                            ret.addMouseListener(ml);
                                        }
                                    }
                                }.run();
                                Component button = (Component)e.getSource();
                                Dimension prefSize = lroot.getPreferredSize();
                                Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
                                this.root = lroot;
                                lroot.show(button, -insets.left, button.getHeight() - insets.top);
                            }
                        }
                    });
                    last = menudata;
                    ExtButton finalBt = bt;
                    ((Component)bt).addMouseListener(new MouseListener((AbstractButton)finalBt){
                        private Timer timer;
                        final /* synthetic */ AbstractButton val$finalBt;
                        {
                            this.val$finalBt = abstractButton;
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            Timer ltimer = this.timer;
                            this.timer = null;
                            if (ltimer != null) {
                                ltimer.stop();
                            }
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            Timer ltimer = this.timer;
                            this.timer = null;
                            if (ltimer != null) {
                                ltimer.stop();
                            }
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            Timer ltimer = this.timer;
                            this.timer = null;
                            if (ltimer != null) {
                                ltimer.stop();
                            }
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            Timer ltimer = this.timer;
                            this.timer = null;
                            if (ltimer != null) {
                                ltimer.stop();
                            }
                            ltimer = new Timer(200, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    e.setSource(val$finalBt);
                                    val$finalBt.getAction().actionPerformed(e);
                                }
                            });
                            ltimer.setRepeats(false);
                            ltimer.start();
                            this.timer = ltimer;
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            Timer ltimer = this.timer;
                            this.timer = null;
                            if (ltimer != null) {
                                ltimer.stop();
                            }
                        }
                    });
                    this.add((Component)bt, "width 32!,height 32!,hidemode 3");
                    ((AbstractButton)bt).setHideActionText(true);
                    continue;
                }
                if (menudata instanceof MenuLink) {
                    final JComponent item = menudata.createItem(null);
                    if (StringUtils.isNotEmpty((String)menudata.getIconKey())) {
                        if (item instanceof AbstractButton) {
                            ((AbstractButton)item).setIcon(NewTheme.I().getIcon(this.validateIconKey(menudata.getIconKey()), 24));
                        } else if (item instanceof SetIconInterface) {
                            ((SetIconInterface)((Object)item)).setIcon(NewTheme.I().getIcon(this.validateIconKey(menudata.getIconKey()), 24));
                        }
                    }
                    if (StringUtils.isNotEmpty((String)menudata.getName()) && item instanceof SetLabelInterface) {
                        ((SetLabelInterface)((Object)item)).setText(menudata.getName());
                    }
                    if (item instanceof JMenu) {
                        bt = new ExtButton((AbstractAction)new AppAction(){
                            {
                                this.setName(((JMenu)item).getText());
                                Icon ico = ((JMenu)item).getIcon();
                                if (ico == null || Math.max(ico.getIconHeight(), ico.getIconWidth()) < 24) {
                                    ico = MainToolBar.this.createDropdownImage("menu");
                                    this.putValue("SwingLargeIconKey", ico);
                                    this.setSmallIcon(ico);
                                } else if (ico instanceof ImageIcon) {
                                    if (Math.max(ico.getIconHeight(), ico.getIconWidth()) != 24) {
                                        ico = ImageProvider.scaleImageIcon((ImageIcon)((ImageIcon)ico), (int)24, (int)24);
                                    }
                                    ico = MainToolBar.this.createDropdownImage(((ImageIcon)ico).getImage());
                                    this.putValue("SwingLargeIconKey", ico);
                                    this.setSmallIcon(ico);
                                } else {
                                    this.putValue("SwingLargeIconKey", ico);
                                    this.setSmallIcon(ico);
                                }
                            }

                            public void actionPerformed(ActionEvent e) {
                                ExtPopupMenu root = new ExtPopupMenu();
                                for (Component c : ((JMenu)item).getMenuComponents()) {
                                    root.add(c);
                                }
                                Object src = e.getSource();
                                if (e.getSource() instanceof Component) {
                                    Component button = (Component)e.getSource();
                                    Dimension prefSize = root.getPreferredSize();
                                    Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
                                    root.show(button, -insets.left, button.getHeight() - insets.top);
                                }
                            }
                        });
                        this.add((Component)bt, "width 32!,height 32!,hidemode 3");
                        ((AbstractButton)bt).setHideActionText(true);
                        continue;
                    }
                    this.add((Component)item, "aligny center,hidemode 3");
                    continue;
                }
                if (menudata.getActionData() == null || !menudata.getActionData()._isValidDataForCreatingAnAction()) continue;
                CustomizableAppAction action = menudata.createAction();
                bt = null;
                if (action instanceof AbstractToolBarAction) {
                    action.requestUpdate((Object)this);
                    bt = ((AbstractToolBarAction)action).createButton();
                }
                if (bt == null) {
                    if (action.isToggle()) {
                        action.requestUpdate((Object)this);
                        bt = new ExtJToggleButton((AbstractAction)action);
                        String iconKey = this.validateIconKey(action.getIconKey());
                        Icon icon = NewTheme.I().getCheckBoxImage(iconKey, false, 24);
                        ((AbstractButton)bt).setIcon(icon);
                        ((AbstractButton)bt).setRolloverIcon(icon);
                        icon = NewTheme.I().getCheckBoxImage(iconKey, true, 24);
                        ((AbstractButton)bt).setSelectedIcon(icon);
                        ((AbstractButton)bt).setRolloverSelectedIcon(icon);
                    } else {
                        action.requestUpdate((Object)this);
                        bt = new ExtButton((AbstractAction)action);
                        ((AbstractButton)bt).setIcon(NewTheme.I().getIcon(this.validateIconKey(action.getIconKey()), 24));
                    }
                    ((AbstractButton)bt).setHideActionText(true);
                }
                this.add((Component)bt, "width 32!,height 32!,hidemode 3");
                action.addVisibilityPropertyChangeListener((JComponent)bt);
                ((JComponent)bt).setVisible(action.isVisible());
                last = menudata;
                Object value = action.getValue("AcceleratorKey");
                if (value == null) continue;
                KeyStroke ks = (KeyStroke)value;
                this.rootpane.getInputMap(1).put(ks, action);
                this.rootpane.getInputMap(2).put(ks, action);
                this.rootpane.getActionMap().put(action, (Action)action);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.add(Box.createHorizontalGlue(), "pushx,growx");
    }

    public String validateIconKey(String key) {
        if (StringUtils.isEmpty((String)key) || !NewTheme.I().hasIcon(key)) {
            return "question";
        }
        return key;
    }

    protected ImageIcon createDropdownImage(String iconKey) {
        if (MenuItemData.isEmptyValue((String)iconKey)) {
            iconKey = "question";
        }
        Image back = NewTheme.I().getImage(iconKey, 20);
        return this.createDropdownImage(back);
    }

    protected ImageIcon createDropdownImage(Image back) {
        Image checkBox = NewTheme.I().getImage("popDownSmall", -1);
        back = ImageProvider.merge((Image)back, (Image)checkBox, (int)0, (int)0, (int)(24 - checkBox.getWidth(null)), (int)(24 - checkBox.getHeight(null)));
        return new ImageIcon(back);
    }

    protected void updateSpecial() {
        if (this.speedmeter != null && CFG_GUI.SPEED_METER_VISIBLE.isEnabled()) {
            this.add((Component)((Object)this.speedmeter), "width 32:300:300,pushy,growy");
        }
    }

    public SpeedMeterPanel getSpeedMeter() {
        return this.speedmeter;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void onDownloadWatchdogDataUpdate() {
    }

    public void onDownloadWatchdogStateIsIdle() {
        new EDTRunner(){

            protected void runInEDT() {
                if (MainToolBar.this.speedmeter != null) {
                    MainToolBar.this.speedmeter.stop();
                }
            }
        };
    }

    public void onDownloadWatchdogStateIsPause() {
    }

    public void onDownloadWatchdogStateIsRunning() {
        new EDTRunner(){

            protected void runInEDT() {
                if (MainToolBar.this.speedmeter != null) {
                    MainToolBar.this.speedmeter.start();
                }
            }
        };
    }

    public void onDownloadWatchdogStateIsStopped() {
        new EDTRunner(){

            protected void runInEDT() {
                if (MainToolBar.this.speedmeter != null) {
                    MainToolBar.this.speedmeter.stop();
                }
            }
        };
    }

    public void onDownloadWatchdogStateIsStopping() {
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

            public void execute(DownloadSession currentSession) {
                final boolean running = DownloadWatchDog.getInstance().isRunning();
                new EDTRunner(){

                    protected void runInEDT() {
                        if (CFG_GUI.SPEED_METER_VISIBLE.isEnabled()) {
                            if (MainToolBar.this.speedmeter != null && running) {
                                MainToolBar.this.speedmeter.start();
                            }
                        } else if (MainToolBar.this.speedmeter != null) {
                            MainToolBar.this.speedmeter.stop();
                        }
                    }
                };
            }

            public void interrupt() {
            }

            public boolean isHighPriority() {
                return false;
            }
        });
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }
}

